/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAggregatedCellList;
import java.util.NoSuchElementException;

public class GCFreeListIteratorAggregatedCellList
extends GCFreeListHeapIterator {
    protected GCHeapLinkedFreeHeader _currentFreeEntry = null;
    protected GCMemoryPoolAggregatedCellList _memoryPool = null;

    public GCFreeListIteratorAggregatedCellList(GCMemoryPoolAggregatedCellList gCMemoryPoolAggregatedCellList) throws CorruptDataException {
        this._memoryPool = gCMemoryPoolAggregatedCellList;
        this._currentFreeEntry = gCMemoryPoolAggregatedCellList.getFirstFreeEntry();
        if (!this._memoryPool.getRegion().containsObjects() || this._currentFreeEntry.getHeader().isNull()) {
            this._currentFreeEntry = null;
        }
    }

    private void advanceFreeListEntry() {
        try {
            this._currentFreeEntry = this._currentFreeEntry.getNext();
            if (this._currentFreeEntry.getHeader().isNull()) {
                this._currentFreeEntry = null;
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", corruptDataException, false);
            this._currentFreeEntry = null;
        }
    }

    @Override
    public int getFreeListNumber() {
        return 0;
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCHeapLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return gCHeapLinkedFreeHeader;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public String toString() {
        GCFreeListIteratorAggregatedCellList gCFreeListIteratorAggregatedCellList = null;
        try {
            gCFreeListIteratorAggregatedCellList = new GCFreeListIteratorAggregatedCellList(this._memoryPool);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCFreeListIteratorAggregatedCellList.hasNext()) {
            stringBuilder.append(gCFreeListIteratorAggregatedCellList.next().toString() + string);
        }
        return stringBuilder.toString();
    }
}

