/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GCVMThreadSlotIterator
extends GCIterator {
    protected J9VMThreadPointer vmThread;
    protected Iterator<StructurePointer.StructureField> slotIterator;

    protected GCVMThreadSlotIterator(J9VMThreadPointer j9VMThreadPointer) {
        this.vmThread = j9VMThreadPointer;
        StructurePointer.StructureField[] structureFieldArray = j9VMThreadPointer.getStructureFields();
        ArrayList<StructurePointer.StructureField> arrayList = new ArrayList<StructurePointer.StructureField>();
        for (StructurePointer.StructureField structureField : structureFieldArray) {
            if (!structureField.type.equals("j9object_t")) continue;
            if (structureField.value != null && ((J9ObjectPointer)structureField.value).notNull()) {
                arrayList.add(structureField);
                continue;
            }
            if (structureField.cde == null) continue;
            arrayList.add(structureField);
        }
        this.slotIterator = arrayList.iterator();
    }

    public static GCVMThreadSlotIterator fromJ9VMThread(J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        return new GCVMThreadSlotIterator(j9VMThreadPointer);
    }

    @Override
    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            StructurePointer.StructureField structureField = this.slotIterator.next();
            if (structureField.cde == null) {
                return (J9ObjectPointer)structureField.value;
            }
            EventManager.raiseCorruptDataEvent("Unable to retrieve thread slot", structureField.cde, false);
            return null;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            StructurePointer.StructureField structureField = this.slotIterator.next();
            if (structureField.cde == null) {
                return VoidPointer.cast(this.vmThread.addOffset(structureField.offset));
            }
            EventManager.raiseCorruptDataEvent("Unable to retrieve thread slot", structureField.cde, false);
            return null;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

