/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.JITLook;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.SendSlot;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.JITRegMap;
import com.ibm.j9ddr.vm29.j9.stackwalker.MethodMetaData;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9I2JStatePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITDecompilationInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITStackAtlasPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9OSRBufferPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9OSRFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJ2IFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJITResolveFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFNativeMethodFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFSpecialFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9StackWalkFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9JITFrame;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9SFJ2IFrame;
import com.ibm.j9ddr.vm29.structure.J9SFJITResolveFrame;
import com.ibm.j9ddr.vm29.structure.J9SFNativeMethodFrame;
import com.ibm.j9ddr.vm29.structure.J9SFSpecialFrame;
import com.ibm.j9ddr.vm29.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm29.structure.J9StackWalkState;
import com.ibm.j9ddr.vm29.structure.MethodMetaDataConstants;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.LinkedList;

public class JITStackWalker {
    private static IJITStackWalker impl;
    private static final AlgorithmPicker<IJITStackWalker> picker;

    static FrameCallbackResult jitWalkStackFrames(WalkState walkState) throws CorruptDataException {
        return JITStackWalker.getImpl().jitWalkStackFrames(walkState);
    }

    static void jitPrintRegisterMapArray(WalkState walkState, String string) throws CorruptDataException {
        JITStackWalker.getImpl().jitPrintRegisterMapArray(walkState, string);
    }

    static J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer j9VMThreadPointer, U8Pointer u8Pointer) throws CorruptDataException {
        return JITStackWalker.getImpl().jitGetExceptionTableFromPC(j9VMThreadPointer, u8Pointer);
    }

    private static IJITStackWalker getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<IJITStackWalker>("ALG_JIT_STACK_WALKER_VERSION"){

            @Override
            protected Iterable<? extends IJITStackWalker> allAlgorithms() {
                LinkedList<JITStackWalker_29_V0> linkedList = new LinkedList<JITStackWalker_29_V0>();
                linkedList.add(new JITStackWalker_29_V0());
                return linkedList;
            }
        };
    }

    private static class JITStackWalker_29_V0
    extends BaseAlgorithm
    implements IJITStackWalker {
        UDATAPointer stackSpillCursor;
        UDATA stackSpillCount;
        UDATA floatRegistersRemaining;
        UDATAPointer pendingSendScanCursor;
        int charIndex;
        private U8 jitDescriptionBits;
        private U8 stackAllocMapBits;
        private U8Pointer jitDescriptionCursor;
        private U8Pointer stackAllocMapCursor;
        private UDATA jitBitsRemaining;
        private UDATA mapBytesRemaining;

        protected JITStackWalker_29_V0() {
            super(90, 0);
        }

        private static U8Pointer MASK_PC(AbstractPointer abstractPointer) {
            if (J9BuildFlags.arch_s390 && !J9BuildFlags.env_data64) {
                return U8Pointer.cast(UDATA.cast(abstractPointer).bitAnd(Integer.MAX_VALUE));
            }
            return U8Pointer.cast(abstractPointer);
        }

        private static void UPDATE_PC_FROM(WalkState walkState, PointerPointer pointerPointer) throws CorruptDataException {
            if (J9BuildFlags.jit_fullSpeedDebug) {
                walkState.pcAddress = pointerPointer;
                walkState.pc = JITStackWalker_29_V0.MASK_PC(pointerPointer.at(0L));
            } else {
                walkState.pc = JITStackWalker_29_V0.MASK_PC(pointerPointer.at(0L));
            }
        }

        private static void SET_A0_CP_METHOD(WalkState walkState) throws CorruptDataException {
            walkState.arg0EA = UDATAPointer.cast(U8Pointer.cast(walkState.bp.add(walkState.jitInfo.slots())).add(J9JITFrame.SIZEOF).sub(UDATA.SIZEOF));
            walkState.method = walkState.jitInfo.ramMethod();
            walkState.constantPool = walkState.jitInfo.constantPool();
            walkState.argCount = new UDATA(walkState.jitInfo.slots());
        }

        @Override
        public FrameCallbackResult jitWalkStackFrames(WalkState walkState) throws CorruptDataException {
            FrameCallbackResult frameCallbackResult = FrameCallbackResult.STOP_ITERATING;
            MethodMetaData.JITMaps jITMaps = new MethodMetaData.JITMaps();
            frameCallbackResult = this.walkTransitionFrame(walkState);
            if (frameCallbackResult != FrameCallbackResult.KEEP_ITERATING) {
                return frameCallbackResult;
            }
            walkState.frameFlags = new UDATA(0L);
            while ((walkState.jitInfo = this.jitGetExceptionTable(walkState)).notNull()) {
                walkState.bp = walkState.unwindSP.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                walkState.sp = J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP ? walkState.unwindSP.sub(walkState.argCount) : walkState.unwindSP;
                walkState.outgoingArgCount = walkState.argCount;
                if ((walkState.flags & J9Consts.J9_STACKWALK_SKIP_INLINES) == 0L && MethodMetaData.getJitInlinedCallInfo(walkState.jitInfo).notNull()) {
                    MethodMetaData.jitGetMapsFromPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), jITMaps);
                    if (jITMaps.inlineMap.notNull()) {
                        VoidPointer voidPointer = MethodMetaData.getFirstInlinedCallSite(walkState.jitInfo, VoidPointer.cast(jITMaps.inlineMap));
                        walkState.arg0EA = UDATAPointer.NULL;
                        if (voidPointer.notNull()) {
                            walkState.inlineDepth = MethodMetaData.getJitInlineDepthFromCallSite(walkState.jitInfo, voidPointer).longValue();
                            walkState.arg0EA = UDATAPointer.NULL;
                            do {
                                J9MethodPointer j9MethodPointer;
                                walkState.method = j9MethodPointer = J9MethodPointer.cast(MethodMetaData.getInlinedMethod(voidPointer));
                                walkState.constantPool = ConstantPoolHelpers.J9_CP_FROM_METHOD(walkState.method);
                                walkState.bytecodePCOffset = U8Pointer.cast(MethodMetaData.getCurrentByteCodeIndexAndIsSameReceiver(walkState.jitInfo, VoidPointer.cast(jITMaps.inlineMap), voidPointer, null));
                                JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT inline");
                                frameCallbackResult = StackWalker.walkFrame(walkState);
                                if (frameCallbackResult != FrameCallbackResult.KEEP_ITERATING) {
                                    return frameCallbackResult;
                                }
                                voidPointer = MethodMetaData.getNextInlinedCallSite(walkState.jitInfo, voidPointer);
                            } while (--walkState.inlineDepth > 0L);
                        }
                    }
                } else if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                    MethodMetaData.jitGetMapsFromPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), jITMaps);
                }
                JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                    walkState.bytecodePCOffset = jITMaps.inlineMap.isNull() ? U8Pointer.cast(-1L) : U8Pointer.cast(MethodMetaData.getCurrentByteCodeIndexAndIsSameReceiver(walkState.jitInfo, VoidPointer.cast(jITMaps.inlineMap), VoidPointer.NULL, null));
                }
                JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT");
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
                    MethodMetaData.markClassesInInlineRanges(walkState.jitInfo, walkState);
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        this.jitWalkFrame(walkState, true, VoidPointer.cast(jITMaps.stackMap));
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", corruptDataException);
                    }
                }
                if ((frameCallbackResult = StackWalker.walkFrame(walkState)) != FrameCallbackResult.KEEP_ITERATING) {
                    return frameCallbackResult;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                    try {
                        this.CLEAR_LOCAL_REGISTER_MAP_ENTRIES(walkState);
                        MethodMetaData.jitAddSpilledRegisters(walkState, VoidPointer.cast(jITMaps.stackMap));
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", corruptDataException);
                    }
                }
                this.UNWIND_TO_NEXT_FRAME(walkState);
            }
            U8Pointer u8Pointer = walkState.pc;
            PointerPointer pointerPointer = PointerPointer.cast(walkState.walkThread.javaVM().jitConfig().i2jReturnTable());
            if (pointerPointer.notNull()) {
                long l;
                for (l = 0L; l < J9StackWalkConstants.J9SW_JIT_RETURN_TABLE_SIZE && !u8Pointer.eq(U8Pointer.cast(pointerPointer.at(l))); ++l) {
                }
                if (l == J9StackWalkConstants.J9SW_JIT_RETURN_TABLE_SIZE) {
                    throw new AddressedCorruptDataException(u8Pointer.getAddress(), "Invalid JIT return address");
                }
            }
            JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, walkState.i2jState.pcEA());
            walkState.literals = walkState.i2jState.literals();
            walkState.arg0EA = walkState.i2jState.a0();
            UDATAPointer uDATAPointer = walkState.i2jState.returnSP();
            walkState.previousFrameFlags = new UDATA(0L);
            walkState.walkSP = uDATAPointer.untag(3L);
            StackWalkerUtils.swPrintf(walkState, 2, "I2J values: PC = {0}, A0 = {1}, walkSP = {2}, literals = {3}, JIT PC = {4}, pcAddress = {5}, decomp = {6}", walkState.pc.getHexAddress(), walkState.arg0EA.getHexAddress(), walkState.walkSP.getHexAddress(), walkState.literals.getHexAddress(), u8Pointer.getHexAddress(), J9BuildFlags.jit_fullSpeedDebug ? walkState.pcAddress.getHexAddress() : "0", J9BuildFlags.jit_fullSpeedDebug ? walkState.decompilationStack.getHexAddress() : "0");
            return frameCallbackResult;
        }

        private J9JITExceptionTablePointer jitGetExceptionTable(WalkState walkState) throws CorruptDataException {
            if (!J9BuildFlags.jit_fullSpeedDebug) {
                return this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
            }
            J9JITExceptionTablePointer j9JITExceptionTablePointer = this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
            walkState.decompilationRecord = J9JITDecompilationInfoPointer.NULL;
            if (j9JITExceptionTablePointer.notNull()) {
                return j9JITExceptionTablePointer;
            }
            if (walkState.decompilationStack != null && walkState.decompilationStack.notNull()) {
                StackWalkerUtils.swPrintf(walkState, 3, "(ws pcaddr = {0}, dc tos = {1}, pcaddr = {2}, pc = {3})", walkState.pcAddress.getHexAddress(), walkState.decompilationStack.getHexAddress(), walkState.decompilationStack.pcAddress().getHexAddress(), walkState.decompilationStack.pc().getHexAddress());
                if (walkState.pcAddress.eq(walkState.decompilationStack.pcAddress())) {
                    walkState.pc = walkState.decompilationStack.pc();
                    if (walkState.resolveFrameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK).eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                        walkState.pc = walkState.pc.add(1L);
                    }
                    walkState.decompilationRecord = walkState.decompilationStack;
                    walkState.decompilationStack = walkState.decompilationStack.next();
                    return this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
                }
                J9JITDecompilationInfoPointer j9JITDecompilationInfoPointer = walkState.decompilationStack;
                while ((j9JITDecompilationInfoPointer = j9JITDecompilationInfoPointer.next()).notNull()) {
                    if (walkState.pcAddress != walkState.decompilationStack.pcAddress()) continue;
                    StackWalkerUtils.swPrintf(walkState, 1, "**** decomp found not on TOS! ****", new Object[0]);
                }
            }
            return J9JITExceptionTablePointer.NULL;
        }

        @Override
        public J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer j9VMThreadPointer, U8Pointer u8Pointer) throws CorruptDataException {
            J9JITConfigPointer j9JITConfigPointer = j9VMThreadPointer.javaVM().jitConfig();
            if (j9JITConfigPointer.isNull()) {
                return J9JITExceptionTablePointer.NULL;
            }
            return JITLook.jit_artifact_search(j9JITConfigPointer.translationArtifacts(), UDATA.cast(JITStackWalker_29_V0.MASK_PC(u8Pointer)));
        }

        private void jitWalkResolveMethodFrame(WalkState walkState) throws CorruptDataException {
            StructurePointer structurePointer;
            DataType dataType;
            StructurePointer structurePointer2;
            boolean bl;
            UDATA uDATA;
            J9UTF8Pointer j9UTF8Pointer;
            Object object;
            this.stackSpillCount = null;
            this.stackSpillCursor = null;
            this.floatRegistersRemaining = new UDATA(0L);
            if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                this.floatRegistersRemaining = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT);
            }
            UDATA uDATA2 = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = -1;
            if (uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE)) {
                object = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 1)));
                j9UTF8Pointer = ROMHelp.J9ROMMETHOD_SIGNATURE((J9ROMMethodPointer)object);
                uDATA = new UDATA(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD((J9ROMMethodPointer)object));
                bl = ((J9ROMMethodPointer)object).modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic);
                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                    this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    this.stackSpillCursor = walkState.unwindSP.sub(1L);
                }
                walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitRecompilationResolvePushes());
            } else if (uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE)) {
                object = UDATAPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 2));
                structurePointer2 = J9ClassPointer.cast(((UDATAPointer)object).at(0L));
                if (AlgorithmVersion.getVersionOf("ALG_VM_ITABLE_VERSION").getAlgorithmVersion() < 1) {
                    dataType = ((UDATAPointer)object).at(1L);
                    structurePointer = ((J9ClassPointer)structurePointer2).romClass().romMethods();
                    while (!((Scalar)dataType).eq(0L)) {
                        structurePointer = ROMHelp.nextROMMethod((J9ROMMethodPointer)structurePointer);
                        dataType = ((UDATA)dataType).sub(1L);
                    }
                } else {
                    J9ClassPointer j9ClassPointer;
                    StructurePointer structurePointer3;
                    long l;
                    J9MethodPointer j9MethodPointer;
                    long l2 = ((UDATAPointer)object).at(1L).longValue();
                    if (0L != (l2 & J9Consts.J9_ITABLE_OFFSET_DIRECT)) {
                        j9MethodPointer = J9MethodPointer.cast(l2).untag(J9Consts.J9_ITABLE_OFFSET_TAG_BITS);
                    } else if (0L != (l2 & J9Consts.J9_ITABLE_OFFSET_VIRTUAL)) {
                        l = l2 & (J9Consts.J9_ITABLE_OFFSET_TAG_BITS ^ 0xFFFFFFFFFFFFFFFFL);
                        structurePointer3 = walkState.walkThread.javaVM();
                        j9ClassPointer = ((J9JavaVMPointer)structurePointer3).booleanArrayClass();
                        j9MethodPointer = J9MethodPointer.cast(PointerPointer.cast(j9ClassPointer.longValue() + l).at(0L));
                    } else {
                        l = (l2 - J9ITable.SIZEOF) / (long)UDATA.SIZEOF;
                        structurePointer3 = J9ITablePointer.cast(((J9ClassPointer)structurePointer2).iTable());
                        while (true) {
                            long l3;
                            if (l < (l3 = (j9ClassPointer = ((J9ITablePointer)structurePointer3).interfaceClass()).romClass().romMethodCount().longValue())) {
                                j9MethodPointer = j9ClassPointer.ramMethods().add(l);
                                break;
                            }
                            l -= l3;
                            structurePointer3 = ((J9ITablePointer)structurePointer3).next();
                        }
                    }
                    structurePointer = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer);
                }
                j9UTF8Pointer = ROMHelp.J9ROMMETHOD_SIGNATURE((J9ROMMethodPointer)structurePointer);
                uDATA = new UDATA(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD((J9ROMMethodPointer)structurePointer));
                bl = true;
                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                    this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    this.stackSpillCursor = walkState.unwindSP.sub(1L);
                }
                if (J9StackWalkFlags.J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER_DEFINED && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (picBuilder interface saved receiver)", new Object[0]);
                        StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.unwindSP.add(J9StackWalkConstants.J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER)));
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", corruptDataException);
                    }
                }
                walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitVirtualMethodResolvePushes());
            } else {
                if (uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                    throw new CorruptDataException("Induced OSR resolve not handled yet");
                }
                if (uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE) || uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE)) {
                    if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.floatRegistersRemaining = new UDATA(0L);
                    }
                    structurePointer2 = J9ConstantPoolPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 2));
                    object = StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 3);
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitStaticMethodResolvePushes());
                    bl = uDATA2.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE);
                    if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.stackSpillCount = new UDATA(0L);
                    }
                } else {
                    dataType = UDATAPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 1));
                    structurePointer2 = J9ConstantPoolPointer.cast(((UDATAPointer)dataType).at(0L));
                    object = ((UDATAPointer)dataType).at(1L);
                    bl = true;
                    if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                        walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                        this.stackSpillCursor = walkState.unwindSP.sub(1L);
                    }
                    if (J9StackWalkFlags.J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER_DEFINED && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (picBuilder virtual saved receiver)", new Object[0]);
                            StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.unwindSP.add(J9StackWalkConstants.J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER)));
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", corruptDataException);
                        }
                    }
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitVirtualMethodResolvePushes());
                }
                structurePointer = J9ROMMethodRefPointer.cast(((J9ConstantPoolPointer)structurePointer2).romConstantPool().add((Scalar)object));
                j9UTF8Pointer = ((J9ROMMethodRefPointer)structurePointer).nameAndSignature().signature();
                uDATA = SendSlot.getSendSlotsFromSignature(j9UTF8Pointer).add(bl ? 1L : 0L);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    char c;
                    this.pendingSendScanCursor = walkState.unwindSP.add(uDATA).sub(1L);
                    StackWalkerUtils.swPrintf(walkState, 3, "\tPending send scan cursor initialized to {0}", this.pendingSendScanCursor.getHexAddress());
                    if (bl) {
                        if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (receiver in register spill area)", new Object[0]);
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                try {
                                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor));
                                }
                                catch (CorruptDataException corruptDataException) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", corruptDataException);
                                }
                            }
                            this.stackSpillCount = this.stackSpillCount.sub(1L);
                            this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (receiver in stack)", new Object[0]);
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                try {
                                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor));
                                }
                                catch (CorruptDataException corruptDataException) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", corruptDataException);
                                }
                            }
                        }
                        this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
                    }
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMethod signature: {0}", J9UTF8Helper.stringValue(j9UTF8Pointer));
                    this.charIndex = 1;
                    object = J9UTF8Helper.stringValue(j9UTF8Pointer);
                    while ((c = this.jitNextSigChar((String)object)) != ')') {
                        switch (c) {
                            case 'L': {
                                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                        try {
                                            StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                                        }
                                        catch (CorruptDataException corruptDataException) {
                                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkMethodFrame", corruptDataException);
                                        }
                                    }
                                    this.stackSpillCount = this.stackSpillCount.sub(1L);
                                    this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                                    break;
                                }
                                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) == 0L) break;
                                try {
                                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                                }
                                catch (CorruptDataException corruptDataException) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkMethodFrame", corruptDataException);
                                }
                                break;
                            }
                            case 'D': {
                                if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                                    this.jitWalkResolveMethodFrame_walkD(walkState);
                                    break;
                                }
                                this.jitWalkResolveMethodFrame_walkJ(walkState);
                                break;
                            }
                            case 'F': {
                                if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                                    this.jitWalkResolveMethodFrame_walkF(walkState);
                                    break;
                                }
                                this.jitWalkResolveMethodFrame_walkI(walkState);
                                break;
                            }
                            case 'J': {
                                this.jitWalkResolveMethodFrame_walkJ(walkState);
                                break;
                            }
                            default: {
                                this.jitWalkResolveMethodFrame_walkI(walkState);
                            }
                        }
                        this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", corruptDataException);
                }
            }
            if (J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP) {
                walkState.unwindSP = walkState.unwindSP.add(uDATA);
            }
            walkState.argCount = uDATA;
        }

        private char jitNextSigChar(String string) throws CorruptDataException {
            int n = string.charAt(this.charIndex++);
            switch (n) {
                case 91: {
                    while ((n = string.charAt(this.charIndex++)) == 91) {
                    }
                    if (n != 76) {
                        n = 76;
                        break;
                    }
                }
                case 76: {
                    while (string.charAt(this.charIndex++) != ';') {
                    }
                    break;
                }
            }
            return (char)n;
        }

        private U64Pointer jitFPRParmAddress(WalkState walkState, UDATA uDATA) throws CorruptDataException {
            U64Pointer u64Pointer = U64Pointer.cast(walkState.walkedEntryLocalStorage.jitFPRegisterStorageBase());
            if (J9BuildFlags.arch_s390) {
                uDATA = uDATA.add(uDATA);
                if (0L != (walkState.walkThread.javaVM().extendedRuntimeFlags().longValue() & J9Consts.J9_EXTENDED_RUNTIME_USE_VECTOR_REGISTERS)) {
                    uDATA = uDATA.add(uDATA).add(16L);
                }
            }
            return u64Pointer.add(uDATA);
        }

        private void jitWalkResolveMethodFrame_walkI(WalkState walkState) throws CorruptDataException {
            if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkI", corruptDataException);
                    }
                }
                this.stackSpillCount = this.stackSpillCount.sub(1L);
                this.stackSpillCursor = this.stackSpillCursor.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkI", corruptDataException);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkF(WalkState walkState) throws CorruptDataException {
            if (!this.floatRegistersRemaining.eq(0L)) {
                UDATA uDATA = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT).sub(this.floatRegistersRemaining);
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer uDATAPointer = UDATAPointer.cast(this.jitFPRParmAddress(walkState, uDATA));
                        if (J9StackWalkFlags.J9SW_JIT_FLOATS_PASSED_AS_DOUBLES_DEFINED && !J9BuildFlags.env_data64) {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer.add(1L)), "JIT-sig-reg-");
                        }
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkF", corruptDataException);
                    }
                }
                this.floatRegistersRemaining = this.floatRegistersRemaining.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkF", corruptDataException);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkJ(WalkState walkState) throws CorruptDataException {
            this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
            if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", corruptDataException);
                }
                this.stackSpillCount = this.stackSpillCount.sub(1L);
                this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                if (!J9BuildFlags.env_data64) {
                    if (!this.stackSpillCount.eq(0L)) {
                        try {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", corruptDataException);
                        }
                        this.stackSpillCount = this.stackSpillCount.sub(1L);
                        this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                    } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-stk-");
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", corruptDataException);
                        }
                    }
                }
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!J9BuildFlags.env_data64) {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-stk-");
                    }
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", corruptDataException);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkD(WalkState walkState) throws CorruptDataException {
            this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
            if (!this.floatRegistersRemaining.eq(0L)) {
                UDATA uDATA = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT).sub(this.floatRegistersRemaining);
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer uDATAPointer = UDATAPointer.cast(this.jitFPRParmAddress(walkState, uDATA));
                        if (!J9BuildFlags.env_data64) {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer.add(1L)), "JIT-sig-reg-");
                        }
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkD", corruptDataException);
                    }
                }
                this.floatRegistersRemaining = this.floatRegistersRemaining.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!J9BuildFlags.env_data64) {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-reg-");
                    }
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException corruptDataException) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkD", corruptDataException);
                }
            }
        }

        private FrameCallbackResult walkTransitionFrame(WalkState walkState) throws CorruptDataException {
            if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                walkState.flags &= J9Consts.J9_STACKWALK_START_AT_JIT_FRAME ^ 0xFFFFFFFFFFFFFFFFL;
                walkState.unwindSP = walkState.walkSP;
                if (J9BuildFlags.jit_fullSpeedDebug) {
                    walkState.pcAddress = PointerPointer.NULL;
                }
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RESOLVE_FRAME)) {
                J9SFJITResolveFramePointer j9SFJITResolveFramePointer = J9SFJITResolveFramePointer.cast(U8Pointer.cast(walkState.bp).sub(J9SFJITResolveFrame.SIZEOF).add(UDATA.SIZEOF));
                UDATA uDATA = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
                if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_GENERIC_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tGeneric resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tStack overflow resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_DATA_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tData resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RUNTIME_HELPER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tRuntime helper resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInterface lookup resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInterface method resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tSpecial method resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tStatic method resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tVirtual method resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tRecompilation resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMonitor enter resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_METHOD_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMethod monitor enter resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tFailed method monitor enter resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_ALLOCATION_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAllocation resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_BEFORE_ANEWARRAY_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tBefore anewarray resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_BEFORE_MULTIANEWARRAY_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tBefore multianewarray resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInduce OSR resolve", new Object[0]);
                } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tException catch resolve", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tUnknown resolve type {0}", uDATA.getHexValue());
                }
                if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAt exception catch - incrementing PC to make map fetching work", new Object[0]);
                    walkState.pc = walkState.pc.add(1L);
                }
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, j9SFJITResolveFramePointer.returnAddressEA());
                if (J9BuildFlags.jit_fullSpeedDebug) {
                    walkState.resolveFrameFlags = walkState.frameFlags;
                }
                walkState.unwindSP = UDATAPointer.cast(j9SFJITResolveFramePointer.taggedRegularReturnSP()).untag(3L);
                StackWalkerUtils.swPrintf(walkState, 3, "\tunwindSP initialized to {0}", walkState.unwindSP.getHexAddress());
                if (J9StackWalkFlags.J9SW_JIT_HELPERS_PASS_PARAMETERS_ON_STACK) {
                    walkState.unwindSP = walkState.unwindSP.add(j9SFJITResolveFramePointer.parmCount());
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAdding {0} slots of pushed resolve parameters", j9SFJITResolveFramePointer.parmCount());
                }
                if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_DATA_RESOLVE)) {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        MethodMetaData.jitAddSpilledRegistersForDataResolve(walkState);
                    }
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitDataResolvePushes());
                    StackWalkerUtils.swPrintf(walkState, 3, "\tData resolve added {0} slots", MethodMetaData.getJitDataResolvePushes());
                } else {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        this.jitAddSpilledRegistersForResolve(walkState);
                    }
                    if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                        this.jitWalkResolveMethodFrame(walkState);
                    } else if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME) || uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE)) {
                        boolean bl = uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME);
                        walkState.jitInfo = this.jitGetExceptionTable(walkState);
                        walkState.bp = walkState.unwindSP;
                        if (!bl) {
                            walkState.bp = walkState.bp.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                        }
                        walkState.outgoingArgCount = new UDATA(0L);
                        JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                        JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT (hidden)");
                        try {
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                this.jitWalkFrame(walkState, !bl, VoidPointer.NULL);
                            }
                        }
                        catch (CorruptDataException corruptDataException) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkTransitionFrame", corruptDataException);
                        }
                        if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES) != 0L) {
                            walkState.frameFlags = new UDATA(0L);
                            FrameCallbackResult frameCallbackResult = StackWalker.walkFrame(walkState);
                            if (frameCallbackResult != FrameCallbackResult.KEEP_ITERATING) {
                                return frameCallbackResult;
                            }
                        }
                        if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                            this.CLEAR_LOCAL_REGISTER_MAP_ENTRIES(walkState);
                        }
                        this.UNWIND_TO_NEXT_FRAME(walkState);
                    }
                }
            } else if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_JNI_CALL_OUT_FRAME)) {
                J9SFNativeMethodFramePointer j9SFNativeMethodFramePointer = J9SFNativeMethodFramePointer.cast(walkState.bp.subOffset(J9SFNativeMethodFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, j9SFNativeMethodFramePointer.savedCPEA());
                if (J9BuildFlags.interp_growableStacks && walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED) && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer uDATAPointer = walkState.bp;
                        walkState.jitInfo = this.jitGetExceptionTable(walkState);
                        walkState.unwindSP = UDATAPointer.cast(j9SFNativeMethodFramePointer.savedPC()).add(1L);
                        walkState.bp = walkState.unwindSP.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                        JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                        JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT (redirected JNI refs)");
                        this.jitWalkFrame(walkState, true, VoidPointer.NULL);
                        walkState.bp = uDATAPointer;
                    }
                    catch (CorruptDataException corruptDataException) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkTransitionFrame", corruptDataException);
                    }
                }
                walkState.unwindSP = walkState.bp.add(1L);
            } else if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_CALL_IN_FRAME)) {
                UDATA uDATA = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
                if (uDATA.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_CALL_IN_TYPE_J2_I)) {
                    J9SFJ2IFramePointer j9SFJ2IFramePointer = J9SFJ2IFramePointer.cast(walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                    walkState.i2jState = J9I2JStatePointer.cast(j9SFJ2IFramePointer.i2jStateEA());
                    walkState.j2iFrame = j9SFJ2IFramePointer.previousJ2iFrame();
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        this.jitAddSpilledRegistersForJ2I(walkState);
                    }
                    walkState.unwindSP = j9SFJ2IFramePointer.taggedReturnSP().untag(3L);
                    JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, j9SFJ2IFramePointer.returnAddressEA());
                }
            } else {
                J9SFSpecialFramePointer j9SFSpecialFramePointer = J9SFSpecialFramePointer.cast(walkState.bp.subOffset(J9SFSpecialFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                    this.jitAddSpilledRegistersForINL(walkState);
                }
                walkState.unwindSP = J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP ? walkState.arg0EA.add(1L) : j9SFSpecialFramePointer.savedA0().untag(3L);
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, j9SFSpecialFramePointer.savedCPEA());
            }
            return FrameCallbackResult.KEEP_ITERATING;
        }

        private void jitAddSpilledRegistersForResolve(WalkState walkState) throws CorruptDataException {
            try {
                UDATAPointer uDATAPointer = walkState.walkedEntryLocalStorage.jitGlobalStorageBase();
                int n = 0;
                int n2 = 0;
                while ((long)n2 < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                    walkState.registerEAs[n++] = uDATAPointer;
                    uDATAPointer = uDATAPointer.add(1L);
                    ++n2;
                }
                this.jitPrintRegisterMapArray(walkState, "Resolve");
            }
            catch (CorruptDataException corruptDataException) {
                StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", corruptDataException);
            }
        }

        private void jitAddSpilledRegistersForINL(WalkState walkState) throws CorruptDataException {
            UDATAPointer uDATAPointer = walkState.walkedEntryLocalStorage.jitGlobalStorageBase();
            int n = 0;
            while ((long)n < J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                int n2 = JITRegMap.jitCalleeSavedRegisterList[n];
                walkState.registerEAs[n2] = uDATAPointer.add(n2);
                ++n;
            }
            this.jitPrintRegisterMapArray(walkState, "INL");
        }

        private void jitAddSpilledRegistersForJ2I(WalkState walkState) throws CorruptDataException {
            J9SFJ2IFramePointer j9SFJ2IFramePointer = J9SFJ2IFramePointer.cast(walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF));
            UDATAPointer uDATAPointer = UDATAPointer.cast(j9SFJ2IFramePointer.previousJ2iFrameEA()).add(1L);
            int n = 0;
            while ((long)n < J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                int n2 = JITRegMap.jitCalleeSavedRegisterList[n];
                walkState.registerEAs[n2] = uDATAPointer;
                uDATAPointer = uDATAPointer.add(1L);
                ++n;
            }
            this.jitPrintRegisterMapArray(walkState, "J2I");
        }

        @Override
        public void jitPrintRegisterMapArray(WalkState walkState, String string) throws CorruptDataException {
            int n = 0;
            while ((long)n < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                UDATAPointer uDATAPointer = walkState.registerEAs[n];
                if (!uDATAPointer.eq(UDATAPointer.NULL)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-{0}-RegisterMap[{1}] = {2} ({3})", string, uDATAPointer.getHexAddress(), uDATAPointer.at(0L), JITRegMap.jitRegisterNames[n]);
                }
                ++n;
            }
        }

        private void CLEAR_LOCAL_REGISTER_MAP_ENTRIES(WalkState walkState) {
            int n = 0;
            while ((long)n < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                walkState.registerEAs[JITRegMap.jitCalleeDestroyedRegisterList[n]] = UDATAPointer.NULL;
                ++n;
            }
        }

        private void UNWIND_TO_NEXT_FRAME(WalkState walkState) throws CorruptDataException {
            if (J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP) {
                walkState.unwindSP = UDATAPointer.cast(J9JITFramePointer.cast(walkState.bp).add(1L)).add(walkState.argCount);
                this.COMMON_UNWIND_TO_NEXT_FRAME(walkState);
            } else {
                walkState.unwindSP = UDATAPointer.cast(J9JITFramePointer.cast(walkState.bp).add(1L));
                this.COMMON_UNWIND_TO_NEXT_FRAME(walkState);
            }
        }

        private void COMMON_UNWIND_TO_NEXT_FRAME(WalkState walkState) throws CorruptDataException {
            if (J9BuildFlags.jit_fullSpeedDebug) {
                walkState.resolveFrameFlags = new UDATA(0L);
            }
            JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, J9JITFramePointer.cast(walkState.bp).returnPCEA());
        }

        private void jitWalkFrame(WalkState walkState, boolean bl, VoidPointer voidPointer) throws CorruptDataException {
            J9OSRBufferPointer j9OSRBufferPointer;
            UDATAPointer uDATAPointer;
            StackWalkerUtils.WALK_METHOD_CLASS(walkState);
            if (voidPointer.isNull() && (voidPointer = MethodMetaData.getStackMapFromJitPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc))).isNull()) {
                throw new AddressedCorruptDataException(walkState.jitInfo.getAddress(), "Unable to locate JIT stack map");
            }
            J9JITStackAtlasPointer j9JITStackAtlasPointer = MethodMetaData.getJitGCStackAtlas(walkState.jitInfo);
            StackWalkerUtils.swPrintf(walkState, 2, "\tstackMap={0}, slots={1} parmBaseOffset={2}, parmSlots={3}, localBaseOffset={4}", voidPointer.getHexAddress(), walkState.jitInfo.slots(), j9JITStackAtlasPointer.parmBaseOffset(), j9JITStackAtlasPointer.numberOfParmSlots(), j9JITStackAtlasPointer.localBaseOffset());
            UDATAPointer uDATAPointer2 = MethodMetaData.getObjectArgScanCursor(walkState);
            this.jitBitsRemaining = new UDATA(0L);
            this.mapBytesRemaining = new UDATA(MethodMetaData.getJitNumberOfMapBytes(j9JITStackAtlasPointer));
            this.jitDescriptionCursor = MethodMetaData.getJitStackSlots(walkState.jitInfo, voidPointer);
            this.stackAllocMapCursor = U8Pointer.cast(MethodMetaData.getStackAllocMapFromJitPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), voidPointer));
            this.stackAllocMapBits = new U8(0L);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
            walkState.slotIndex = 0;
            if (!MethodMetaData.getJitNumberOfParmSlots(j9JITStackAtlasPointer).eq(0L)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tDescribed JIT args starting at {0} for {1} slots", uDATAPointer2.getHexAddress(), j9JITStackAtlasPointer.numberOfParmSlots());
                this.walkJITFrameSlots(walkState, uDATAPointer2, new UDATA(MethodMetaData.getJitNumberOfParmSlots(j9JITStackAtlasPointer)), voidPointer, J9JITStackAtlasPointer.NULL, ": a");
            }
            if (bl && !walkState.bp.sub(UDATA.cast(uDATAPointer = MethodMetaData.getObjectTempScanCursor(walkState))).eq(UDATAPointer.NULL)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tDescribed JIT temps starting at {0} for {1} slots", uDATAPointer.getHexAddress(), walkState.bp.sub(uDATAPointer));
                this.walkJITFrameSlots(walkState, uDATAPointer, new UDATA(walkState.bp.subOffset(UDATA.cast(uDATAPointer)).longValue() / (long)UDATA.SIZEOF), voidPointer, j9JITStackAtlasPointer, ": t");
            }
            this.jitWalkRegisterMap(walkState, voidPointer, j9JITStackAtlasPointer);
            J9JITDecompilationInfoPointer j9JITDecompilationInfoPointer = walkState.decompilationRecord;
            if (!j9JITDecompilationInfoPointer.isNull() && !(j9OSRBufferPointer = J9OSRBufferPointer.cast(j9JITDecompilationInfoPointer.osrBufferEA())).numberOfFrames().eq(0L)) {
                this.jitWalkOSRBuffer(walkState, j9OSRBufferPointer);
            }
        }

        private void walkJITFrameSlots(WalkState walkState, UDATAPointer uDATAPointer, UDATA uDATA, VoidPointer voidPointer, J9JITStackAtlasPointer j9JITStackAtlasPointer, String string) throws CorruptDataException {
            if (j9JITStackAtlasPointer.notNull() && MethodMetaData.getJitInternalPointerMap(j9JITStackAtlasPointer).notNull()) {
                MethodMetaData.walkJITFrameSlotsForInternalPointers(walkState, this.jitDescriptionCursor, uDATAPointer, voidPointer, j9JITStackAtlasPointer);
            }
            while (!uDATA.eq(0L)) {
                String string2;
                if (this.jitBitsRemaining.eq(0L)) {
                    if (!this.mapBytesRemaining.eq(0L)) {
                        this.jitDescriptionBits = MethodMetaData.getNextDescriptionBit(this.jitDescriptionCursor);
                        this.jitDescriptionCursor = this.jitDescriptionCursor.add(1L);
                        if (this.stackAllocMapCursor.notNull()) {
                            this.stackAllocMapBits = MethodMetaData.getNextDescriptionBit(this.stackAllocMapCursor);
                            this.stackAllocMapCursor = this.stackAllocMapCursor.add(1L);
                        }
                        this.mapBytesRemaining = this.mapBytesRemaining.sub(1L);
                    } else {
                        this.jitDescriptionBits = new U8(0L);
                    }
                    this.jitBitsRemaining = new UDATA(8L);
                }
                if (this.jitDescriptionBits.anyBitsIn(1L)) {
                    string2 = String.format("O-Slot: %s%d", string, uDATA.sub(1L).intValue());
                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(uDATAPointer), string2);
                } else if (this.stackAllocMapBits.anyBitsIn(1L)) {
                    JITStackWalker_29_V0.jitWalkStackAllocatedObject(walkState, J9ObjectPointer.cast(uDATAPointer));
                } else {
                    string2 = String.format("I-Slot: %s%d", string, uDATA.sub(1L).intValue());
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(uDATAPointer), string2);
                }
                ++walkState.slotIndex;
                uDATAPointer = uDATAPointer.add(1L);
                this.jitBitsRemaining = this.jitBitsRemaining.sub(1L);
                this.jitDescriptionBits = this.jitDescriptionBits.rightShift(1);
                this.stackAllocMapBits = this.stackAllocMapBits.rightShift(1);
                uDATA = uDATA.sub(1L);
            }
        }

        private static void jitWalkStackAllocatedObject(WalkState walkState, J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\tSA-Obj[{0}]", Long.toHexString(j9ObjectPointer.getAddress()));
            GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, false);
            while (gCObjectIterator.hasNext()) {
                ObjectReferencePointer objectReferencePointer = ObjectReferencePointer.cast(gCObjectIterator.nextAddress());
                StackWalkerUtils.swPrintf(walkState, 4, "\t\t\tF-Slot[{0}] = {1}", objectReferencePointer.getHexAddress(), objectReferencePointer.at(0L).getHexAddress());
                if (walkState.callBacks == null) continue;
                walkState.callBacks.fieldSlotWalkFunction(walkState.walkThread, walkState, objectReferencePointer, VoidPointer.cast(objectReferencePointer));
            }
        }

        private static void jitPrintFrameType(WalkState walkState, String string) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 2, "{0} frame: bp = {1}, pc = {2}, unwindSP = {3}, cp = {4}, arg0EA = {5}, jitInfo = {6}", string, walkState.bp.getHexAddress(), walkState.pc.getHexAddress(), walkState.unwindSP.getHexAddress(), walkState.constantPool.getHexAddress(), walkState.arg0EA.getHexAddress(), walkState.jitInfo.getHexAddress());
            try {
                StackWalkerUtils.swPrintMethod(walkState);
            }
            catch (CorruptDataException corruptDataException) {
                StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", corruptDataException);
            }
            StackWalkerUtils.swPrintf(walkState, 3, "\tBytecode index = {0}, inlineDepth = {1}, PC offset = {2}", UDATA.cast(walkState.bytecodePCOffset).longValue(), walkState.inlineDepth, walkState.pc.sub(UDATA.cast(walkState.method.extra())).getHexAddress());
        }

        private void jitWalkRegisterMap(WalkState walkState, VoidPointer voidPointer, J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            UDATA uDATA = new UDATA(MethodMetaData.getJitRegisterMap(walkState.jitInfo, voidPointer).bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK));
            StackWalkerUtils.swPrintf(walkState, 200, "\tIn jitWalkRegisterMap. stackMap={0}, gcStackAtlas={1}", Long.toHexString(voidPointer.getAddress()), Long.toHexString(j9JITStackAtlasPointer.getAddress()));
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-RegisterMap = {0}", uDATA);
            if (j9JITStackAtlasPointer.internalPointerMap().notNull()) {
                uDATA = uDATA.bitAnd(new UDATA(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK).bitNot());
            }
            if (!uDATA.eq(0L)) {
                int n = (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS;
                int n2 = 0;
                n2 = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? 0 : (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - 1;
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_JIT_REGISTER_MAP;
                walkState.slotIndex = 0;
                while (n != 0) {
                    Pointer pointer;
                    if (uDATA.anyBitsIn(1L)) {
                        J9ObjectPointer j9ObjectPointer;
                        pointer = PointerPointer.cast(walkState.registerEAs[n2]);
                        J9ObjectPointer j9ObjectPointer2 = pointer.isNull() ? J9ObjectPointer.NULL : J9ObjectPointer.cast(((PointerPointer)pointer).at(0L));
                        StackWalkerUtils.swPrintf(walkState, 4, "\t\tJIT-RegisterMap-O-Slot[{0}] = {1} ({2})", pointer.getHexAddress(), j9ObjectPointer2.getHexAddress(), JITRegMap.jitRegisterNames[n2]);
                        walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, (PointerPointer)pointer, VoidPointer.cast(pointer));
                        J9ObjectPointer j9ObjectPointer3 = j9ObjectPointer = pointer.isNull() ? J9ObjectPointer.NULL : J9ObjectPointer.cast(((PointerPointer)pointer).at(0L));
                        if (!j9ObjectPointer2.eq(j9ObjectPointer)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\t\t\t-> {0}\n", j9ObjectPointer);
                        }
                    } else {
                        pointer = walkState.registerEAs[n2];
                        if (pointer.notNull()) {
                            StackWalkerUtils.swPrintf(walkState, 5, "\t\tJIT-RegisterMap-I-Slot[{0}] = {1} ({2})", pointer.getHexAddress(), ((UDATAPointer)pointer).at(0L), JITRegMap.jitRegisterNames[n2]);
                        }
                    }
                    ++walkState.slotIndex;
                    --n;
                    uDATA = uDATA.rightShift(1);
                    if (J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH) {
                        ++n2;
                        continue;
                    }
                    --n2;
                }
            }
        }

        private J9OSRFramePointer jitWalkOSRFrame(WalkState walkState, J9OSRFramePointer j9OSRFramePointer) throws CorruptDataException {
            J9MethodPointer j9MethodPointer = j9OSRFramePointer.method();
            UDATA uDATA = j9OSRFramePointer.bytecodePCOffset();
            UDATA uDATA2 = j9OSRFramePointer.numberOfLocals();
            UDATA uDATA3 = j9OSRFramePointer.maxStack();
            UDATA uDATA4 = j9OSRFramePointer.pendingStackHeight();
            U8Pointer u8Pointer = j9MethodPointer.bytecodes().add(uDATA);
            UDATAPointer uDATAPointer = UDATAPointer.cast(j9OSRFramePointer.add(1L)).add(uDATA3);
            UDATAPointer uDATAPointer2 = uDATAPointer.add(uDATA2);
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-OSRFrame = {0}, bytecodePC = {1}, numberOfLocals = {2}, maxStack = {3}, pendingStackHeight = {4}", j9OSRFramePointer.getHexAddress(), u8Pointer.getHexAddress(), uDATA2, uDATA3, uDATA4);
            StackWalkerUtils.swPrintMethod(walkState, j9MethodPointer);
            StackWalker.walkBytecodeFrameSlots(walkState, j9MethodPointer, uDATA, uDATAPointer.sub(1L), uDATA4, uDATAPointer2.sub(1L), uDATA2);
            return J9OSRFramePointer.cast(uDATAPointer2);
        }

        private void jitWalkOSRBuffer(WalkState walkState, J9OSRBufferPointer j9OSRBufferPointer) throws CorruptDataException {
            long l = j9OSRBufferPointer.numberOfFrames().longValue();
            J9OSRFramePointer j9OSRFramePointer = J9OSRFramePointer.cast(j9OSRBufferPointer.add(1L));
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-OSRBuffer = {0}, numberOfFrames = {1}", j9OSRBufferPointer.getHexAddress(), l);
            do {
                j9OSRFramePointer = this.jitWalkOSRFrame(walkState, j9OSRFramePointer);
            } while (0L != --l);
        }
    }

    private static interface IJITStackWalker
    extends IAlgorithm {
        public FrameCallbackResult jitWalkStackFrames(WalkState var1) throws CorruptDataException;

        public void jitPrintRegisterMapArray(WalkState var1, String var2) throws CorruptDataException;

        public J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer var1, U8Pointer var2) throws CorruptDataException;
    }
}

