/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<StructType extends DataType>
implements Iterator<StructType> {
    private final int total;
    private int current = 0;
    private PointerPointer node = null;
    protected Class<StructType> structType;
    private long address = 0L;

    public <T extends DataType> ArrayIterator(Class<T> clazz, int n, PointerPointer pointerPointer) throws CorruptDataException {
        this.structType = clazz;
        this.total = n;
        if (n > 0) {
            this.node = pointerPointer;
            this.address = this.node.at(0L).getAddress();
            this.setNextItem();
        }
    }

    public Iterator<StructType> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.total;
    }

    @Override
    public StructType next() {
        if (this.hasNext()) {
            try {
                DataType dataType = (DataType)DataType.getStructure(this.structType, this.address);
                this.address = 0L;
                this.setNextItem();
                return (StructType)dataType;
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, true);
                return null;
            }
        }
        throw new NoSuchElementException();
    }

    private void setNextItem() throws CorruptDataException {
        while (this.current < this.total && this.address == 0L) {
            this.node = this.node.add(1L);
            ++this.current;
            this.address = this.node.at(0L).getAddress();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

