/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class WhatisCommand
extends BaseJdmpviewCommand {
    public WhatisCommand() {
        this.addCommand("whatis", "[hex address]", "gives information about what is stored at the given memory address");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 0) {
            printStream.println("missing address argument");
            return;
        }
        Long l = Utils.longFromString(stringArray[0]);
        if (null == l) {
            printStream.println("cannot convert \"" + stringArray[0] + "\" to numeric value");
            return;
        }
        long l2 = l;
        this.findInRuntime(l2);
        printStream.print("\n");
    }

    private void findInRuntime(long l) {
        Iterator iterator = this.ctx.getRuntime().getHeaps();
        int n = 1;
        while (iterator.hasNext()) {
            JavaHeap javaHeap = (JavaHeap)iterator.next();
            this.out.print("\theap #" + n + " - name: ");
            this.out.print(javaHeap.getName() + "\n");
            this.findInHeap(javaHeap, l);
            ++n;
        }
    }

    private void findInHeap(JavaHeap javaHeap, long l) {
        if (this.isWithinImageSections(javaHeap.getSections(), null, false, l)) {
            if (!this.isStartOfObj(javaHeap.getObjects(), l) && !this.isWithinObjectRange(javaHeap.getObjects(), l)) {
                this.out.print("\t\t0x" + Long.toHexString(l) + " is orphaned on the heap.\n");
            }
        } else {
            this.out.print("\t\t0x" + Long.toHexString(l) + " is not within this heap.\n");
            long l2 = 12L;
            this.checkClassInRange(javaHeap.getObjects(), l2, l);
            this.checkMethodInRange(javaHeap.getObjects(), l);
        }
    }

    private void checkMethodInRange(Iterator iterator, long l) {
        while (iterator.hasNext()) {
            JavaClass javaClass;
            JavaObject javaObject = (JavaObject)iterator.next();
            try {
                javaClass = javaObject.getJavaClass();
            }
            catch (CorruptDataException corruptDataException) {
                continue;
            }
            Iterator iterator2 = javaClass.getDeclaredMethods();
            while (iterator2.hasNext()) {
                JavaMethod javaMethod = (JavaMethod)iterator2.next();
                Iterator iterator3 = javaMethod.getBytecodeSections();
                Iterator iterator4 = javaMethod.getCompiledSections();
                if (this.isWithinImageSections(iterator3, javaMethod, false, l)) {
                    return;
                }
                if (!this.isWithinImageSections(iterator4, javaMethod, true, l)) continue;
                return;
            }
        }
    }

    private void checkClassInRange(Iterator iterator, long l, long l2) {
        while (iterator.hasNext()) {
            String string;
            JavaClass javaClass;
            JavaObject javaObject = (JavaObject)iterator.next();
            try {
                javaClass = javaObject.getJavaClass();
                string = javaClass.getName();
            }
            catch (CorruptDataException corruptDataException) {
                continue;
            }
            long l3 = javaClass.getID().getAddress();
            long l4 = l3 + l;
            if (l2 == l3) {
                this.out.print("\t0x" + Long.toHexString(l2) + " is the address of the java/lang/Class object for " + string);
                return;
            }
            if (!this.isWithinRange(l3, l4, l2)) continue;
            this.out.print("0x" + Long.toHexString(l2) + " is within the java/lang/Class object for " + string);
            return;
        }
    }

    private boolean isWithinObjectRange(Iterator iterator, long l) {
        while (iterator.hasNext()) {
            long l2;
            long l3;
            String string;
            JavaObject javaObject = (JavaObject)iterator.next();
            try {
                string = javaObject.getJavaClass().getName();
                l3 = javaObject.getID().getAddress();
                l2 = l3 + javaObject.getSize();
            }
            catch (CorruptDataException corruptDataException) {
                continue;
            }
            if (!this.isWithinRange(l3, l2, l)) continue;
            this.out.print("\t\t0x" + Long.toHexString(l) + " is within an object on the heap:\n\t\t\toffset " + (l - l3) + " within " + string + " instance @ 0x" + Long.toHexString(l3) + "\n");
            return true;
        }
        return false;
    }

    private boolean isWithinRange(long l, long l2, long l3) {
        return l3 <= l2 && l3 > l;
    }

    private boolean isStartOfObj(Iterator iterator, long l) {
        long l2 = 0L;
        while (iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                ++l2;
                continue;
            }
            JavaObject javaObject = (JavaObject)e;
            if (l != javaObject.getID().getAddress()) continue;
            try {
                string = javaObject.getJavaClass().getName();
            }
            catch (CorruptDataException corruptDataException) {
                string = "<corrupt class name>";
            }
            this.out.print("\t\t0x" + Long.toHexString(l) + " is the start of an object of type " + string);
            return true;
        }
        if (l2 > 0L) {
            this.out.println("\t\t[skipped " + l2 + " corrupt object(s) in heap]");
        }
        return false;
    }

    private boolean isWithinImageSections(Iterator iterator, Object object, boolean bl, long l) {
        while (iterator.hasNext()) {
            long l2;
            ImageSection imageSection = (ImageSection)iterator.next();
            long l3 = imageSection.getBaseAddress().getAddress();
            long l4 = l3 + (l2 = imageSection.getSize());
            if (l > l4 || l < l3) continue;
            if (null == object) {
                this.out.print("\t\t0x" + Long.toHexString(l) + " is within heap segment: " + Long.toHexString(l3) + " -- " + Long.toHexString(l4) + "\n");
                return true;
            }
            if (!(object instanceof JavaMethod)) continue;
            String string = "N/A";
            String string2 = "N/A";
            String string3 = "N/A";
            try {
                string = ((JavaMethod)object).getName();
                string2 = ((JavaMethod)object).getSignature();
                string3 = ((JavaMethod)object).getDeclaringClass().getName();
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
            String string4 = bl ? "compiled code" : "byte code";
            this.out.print("\t0x" + Long.toHexString(l) + " is within the " + string4 + " range: " + Long.toHexString(l3) + " -- " + Long.toHexString(l4) + "\n\t...of method " + string + " with signature " + string2 + "\n\t...in class " + string3 + "\n");
            return true;
        }
        return false;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("gives information about what is stored at the given memory address\n\nparameters: <hex_address>\n\nthe whatis command examines the memory location at <hex_address> and tries to find out more information about this address - for example whether it is within an object in a heap or within the byte codes associated with a class method.");
    }
}

