/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import com.ibm.dtfj.corereaders.zos.util.IntEnumeration;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHashMap
implements Serializable {
    static final int INITIAL_SIZE = 17;
    long[] keys = new long[17];
    int tableSize = 17;
    int slotsInUse;
    int deletedSlots;
    byte[] state = new byte[17];
    static final byte EMPTY = 0;
    static final byte OCCUPIED = 1;
    static final byte DELETED = 2;
    private boolean inRehash;
    private static Logger log = Logger.getLogger(AbstractHashMap.class.getName());
    private static final boolean debug = log.isLoggable(Level.FINER);
    private static int callsToGetIndex;
    private static int callsToGetIndexSuccess;
    private static int loopsInGetIndex;
    private static int loopsBecauseNotEqual;
    private static int loopsBecauseDeleted;
    private static int callsToRehash;
    private static final int[] smallPrimes;

    abstract Object getValuesArray();

    abstract void allocNewValuesArray(int var1);

    abstract void put(long var1, Object var3, int var4);

    void rehash() {
        this.inRehash = true;
        if (debug) {
            ++callsToRehash;
            log.finer("rehashing, current size " + this.tableSize + " slots in use " + this.slotsInUse + " deleted " + this.deletedSlots);
            AbstractHashMap.printStats();
        }
        long[] lArray = this.keys;
        Object object = this.getValuesArray();
        byte[] byArray = this.state;
        if (this.tableNeedsResize()) {
            this.tableSize <<= 1;
            while (!AbstractHashMap.isprime(++this.tableSize)) {
            }
            if (debug) {
                log.finer("new table size is " + this.tableSize);
            }
        }
        this.keys = new long[this.tableSize];
        this.allocNewValuesArray(this.tableSize);
        this.state = new byte[this.tableSize];
        this.slotsInUse = 0;
        this.deletedSlots = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (byArray[i] != 1) continue;
            this.put(lArray[i], object, i);
        }
        this.inRehash = false;
    }

    int getIndex(long l) {
        if (debug) {
            ++callsToGetIndex;
        }
        for (int i = 0; i < this.tableSize; ++i) {
            int n = this.h(l & Long.MAX_VALUE, i);
            if (this.state[n] == 0) {
                return -1;
            }
            if (this.state[n] == 1 && this.keys[n] == l) {
                if (debug) {
                    ++callsToGetIndexSuccess;
                }
                return n;
            }
            if (!debug) continue;
            ++loopsInGetIndex;
            if (this.state[n] == 1) {
                ++loopsBecauseNotEqual;
                continue;
            }
            ++loopsBecauseDeleted;
        }
        return -1;
    }

    private static void printStats() {
        log.finer("callsToGetIndex = " + callsToGetIndex);
        log.finer("callsToGetIndexSuccess = " + callsToGetIndexSuccess);
        log.finer("loopsInGetIndex = " + loopsInGetIndex);
        log.finer("loopsBecauseNotEqual = " + loopsBecauseNotEqual);
        log.finer("loopsBecauseDeleted = " + loopsBecauseDeleted);
        log.finer("callsToRehash = " + callsToRehash);
    }

    int removeIndex(long l) {
        int n = this.getIndex(l);
        if (n != -1) {
            this.state[n] = 2;
            ++this.deletedSlots;
            --this.slotsInUse;
        }
        return n;
    }

    private boolean tableNeedsResize() {
        return this.slotsInUse > this.tableSize * 2 / 3;
    }

    void checkRehash() {
        if ((this.tableNeedsResize() || this.deletedSlots > this.tableSize / 3) && !this.inRehash) {
            this.rehash();
        }
    }

    int putIndex(long l) {
        for (int i = 0; i < this.tableSize; ++i) {
            int n = this.h(l & Long.MAX_VALUE, i);
            if (this.state[n] != 1) {
                this.keys[n] = l;
                if (this.state[n] == 2) {
                    --this.deletedSlots;
                }
                this.state[n] = 1;
                ++this.slotsInUse;
                return n;
            }
            if (this.keys[n] != l) continue;
            return n;
        }
        throw new Error("table full! key = " + l + " tableSize = " + this.tableSize + " slotsInUse = " + this.slotsInUse);
    }

    public IntEnumeration getKeys() {
        return new KeyEnum();
    }

    public long[] getKeysArray() {
        long[] lArray = new long[this.slotsInUse];
        int n = 0;
        for (int i = 0; i < this.tableSize; ++i) {
            if (this.state[i] != 1) continue;
            lArray[n++] = this.keys[i];
        }
        return lArray;
    }

    private int h(long l, int n) {
        long l2 = (long)this.h1(l) + (long)n * (long)this.h2(l);
        return (int)(l2 % (long)this.tableSize);
    }

    private int h1(long l) {
        return (int)(l % (long)this.tableSize);
    }

    private int h2(long l) {
        return (int)(1L + l % (long)(this.tableSize - 2));
    }

    private static boolean isprime(int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < smallPrimes.length; ++i) {
            n3 = smallPrimes[i];
            if (n % n3 != 0) continue;
            return false;
        }
        for (n2 = n; n / n2 < n2; n2 >>= 1) {
        }
        n2 <<= 1;
        n3 += 2;
        while (n3 < n2) {
            if (n % n3 == 0) {
                return false;
            }
            n3 += 2;
        }
        return true;
    }

    static {
        smallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};
    }

    private class KeyEnum
    implements IntEnumeration {
        int index = 0;
        boolean hasMore = true;

        KeyEnum() {
            this.reset();
        }

        void next() {
            while (this.index < AbstractHashMap.this.tableSize && AbstractHashMap.this.state[this.index] != 1) {
                ++this.index;
            }
            if (this.index == AbstractHashMap.this.tableSize) {
                this.hasMore = false;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            return this.nextInt();
        }

        @Override
        public long nextInt() {
            long l = AbstractHashMap.this.keys[this.index++];
            this.next();
            return l;
        }

        public long peekInt() {
            return AbstractHashMap.this.keys[this.index];
        }

        public void reset() {
            this.index = 0;
            this.hasMore = true;
            this.next();
        }
    }
}

