/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class SimpleFileManager
extends FileManager {
    protected final File managedFile;
    private long filesize = Long.MAX_VALUE;

    public SimpleFileManager(File file) {
        this.managedFile = file;
    }

    @Override
    public List<ManagedImageSource> getImageSources() throws IOException {
        ArrayList<ManagedImageSource> arrayList = new ArrayList<ManagedImageSource>();
        ImageInputStream imageInputStream = this.getStream();
        if (this.identifiedCoreFile(arrayList, imageInputStream)) {
            imageInputStream.close();
            return arrayList;
        }
        if (this.identifiedJavaCore(arrayList, imageInputStream)) {
            imageInputStream.close();
            return arrayList;
        }
        if (this.identifiedPHD(arrayList, imageInputStream)) {
            imageInputStream.close();
            return arrayList;
        }
        imageInputStream.close();
        throw new IOException("No Image sources were found for " + this.managedFile.getAbsolutePath());
    }

    private boolean identifiedCoreFile(ArrayList<ManagedImageSource> arrayList, ImageInputStream imageInputStream) throws IOException {
        if (FileSniffer.isCoreFile(imageInputStream, this.filesize)) {
            ManagedImageSource managedImageSource = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.CORE);
            managedImageSource.setPath(this.managedFile.getPath());
            File file = new File(this.managedFile.getParent(), this.managedFile.getName() + ".xml");
            logger.finer("Identified core file : " + managedImageSource.toURI());
            if (SimpleFileManager.fileExists(file)) {
                ManagedImageSource managedImageSource2 = new ManagedImageSource(file.getName(), ImageSourceType.META);
                managedImageSource2.setPath(file.getPath());
                managedImageSource.setMetadata(managedImageSource2);
                logger.finer("Identified core file metadata : " + managedImageSource2.toURI());
            }
            arrayList.add(managedImageSource);
            return true;
        }
        return false;
    }

    private boolean identifiedJavaCore(ArrayList<ManagedImageSource> arrayList, ImageInputStream imageInputStream) throws IOException {
        if (FileSniffer.isJavaCoreFile(imageInputStream, this.filesize)) {
            ManagedImageSource managedImageSource = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.JAVACORE);
            managedImageSource.setPath(this.managedFile.getPath());
            arrayList.add(managedImageSource);
            logger.finer("Identified javacore file : " + managedImageSource.toURI());
            return true;
        }
        return false;
    }

    private boolean identifiedPHD(ArrayList<ManagedImageSource> arrayList, ImageInputStream imageInputStream) throws IOException {
        if (FileSniffer.isPHDFile(imageInputStream, this.filesize)) {
            ManagedImageSource managedImageSource = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.PHD);
            managedImageSource.setPath(this.managedFile.getPath());
            String[] stringArray = this.getJavaCoreNameFromPHD(this.managedFile.getName());
            logger.finer("Identified PHD file : " + managedImageSource.toURI());
            for (String string : stringArray) {
                File file = new File(this.managedFile.getParent(), string);
                if (!SimpleFileManager.fileExists(file)) continue;
                ManagedImageSource managedImageSource2 = new ManagedImageSource(string, ImageSourceType.META);
                managedImageSource2.setPath(file.getPath());
                managedImageSource.setMetadata(managedImageSource2);
                logger.finer("Identified associated javacore file : " + managedImageSource2.toURI());
                break;
            }
            arrayList.add(managedImageSource);
            return true;
        }
        return false;
    }

    @Override
    public ImageInputStream getStream() throws IOException {
        if (this.managedFile.exists()) {
            this.filesize = this.managedFile.length();
            return new FileImageInputStream(this.managedFile);
        }
        throw new FileNotFoundException("The specified file " + this.managedFile.getAbsolutePath() + " was not found");
    }
}

