/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.ZipMemoryCacheImageInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class ZipFileManager
extends CompressedFileManager {
    public ZipFileManager(File file) {
        super(file);
    }

    @Override
    public List<ManagedImageSource> getImageSources() throws IOException {
        ArrayList<ManagedImageSource> arrayList = new ArrayList<ManagedImageSource>();
        ZipFile zipFile = new ZipFile(this.managedFile);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.isDirectory() && !this.identifiedCoreFile(zipFile, zipEntry, arrayList) && !this.identifiedJavaCore(zipFile, zipEntry, arrayList) && !this.identifiedPHD(zipFile, zipEntry, arrayList)) continue;
        }
        zipFile.close();
        return arrayList;
    }

    private boolean identifiedCoreFile(ZipFile zipFile, ZipEntry zipEntry, ArrayList<ManagedImageSource> arrayList) throws IOException {
        if (zipEntry.getSize() < 0x1400000L) {
            return false;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        if (FileSniffer.isCoreFile(inputStream, zipEntry.getSize())) {
            ManagedImageSource managedImageSource = new ManagedImageSource(zipEntry.getName(), ImageSourceType.CORE);
            managedImageSource.setArchive(this.managedFile);
            logger.finer("Identified core file : " + managedImageSource.toURI());
            ZipEntry zipEntry2 = zipFile.getEntry(zipEntry.getName() + ".xml");
            if (zipEntry2 != null) {
                ManagedImageSource managedImageSource2 = new ManagedImageSource(zipEntry2.getName(), ImageSourceType.META);
                managedImageSource2.setArchive(this.managedFile);
                managedImageSource.setMetadata(managedImageSource2);
                logger.finer("Identified core file metadata : " + managedImageSource2.toURI());
            }
            arrayList.add(managedImageSource);
            return true;
        }
        return false;
    }

    private boolean identifiedJavaCore(ZipFile zipFile, ZipEntry zipEntry, ArrayList<ManagedImageSource> arrayList) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        if (FileSniffer.isJavaCoreFile(inputStream, zipEntry.getSize())) {
            ManagedImageSource managedImageSource = new ManagedImageSource(zipEntry.getName(), ImageSourceType.JAVACORE);
            managedImageSource.setArchive(this.managedFile);
            arrayList.add(managedImageSource);
            logger.finer("Identified javacore file : " + managedImageSource.toURI());
            return true;
        }
        return false;
    }

    private boolean identifiedPHD(ZipFile zipFile, ZipEntry zipEntry, ArrayList<ManagedImageSource> arrayList) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        if (FileSniffer.isPHDFile(inputStream, zipEntry.getSize())) {
            String[] stringArray;
            ManagedImageSource managedImageSource = new ManagedImageSource(zipEntry.getName(), ImageSourceType.PHD);
            managedImageSource.setArchive(this.managedFile);
            logger.finer("Identified PHD file : " + managedImageSource.toURI());
            for (String string : stringArray = this.getJavaCoreNameFromPHD(zipEntry.getName())) {
                if (zipFile.getEntry(string) == null) continue;
                ManagedImageSource managedImageSource2 = new ManagedImageSource(string, ImageSourceType.META);
                managedImageSource2.setArchive(this.managedFile);
                managedImageSource.setMetadata(managedImageSource2);
                logger.finer("Identified associated javacore file : " + managedImageSource2.toURI());
                break;
            }
            arrayList.add(managedImageSource);
            return true;
        }
        return false;
    }

    @Override
    public void extract(ManagedImageSource managedImageSource, File file) throws IOException {
        this.checkDirectoryToExtractTo(file);
        File file2 = this.getExtractLocation(managedImageSource.getName(), file);
        ZipFile zipFile = new ZipFile(this.managedFile);
        ZipEntry zipEntry = zipFile.getEntry(managedImageSource.getName());
        this.extractEntry(zipFile, zipEntry, file2);
        managedImageSource.setExtractedTo(file2);
        managedImageSource.incRefCount();
    }

    private File getExtractLocation(String string, File file) throws IOException {
        File file2;
        String string2;
        String string3 = file.getCanonicalPath();
        File file3 = new File(string3);
        String string4 = string.replace('\\', '/');
        if (string4.length() > 2 && string4.charAt(1) == ':') {
            string4 = string4.substring(2);
        }
        if (!(string2 = (file2 = new File(string3, string4)).getCanonicalPath()).startsWith(string3)) {
            throw new IOException(string2 + " should be subdirectory of " + string3);
        }
        String[] stringArray = string4.split("/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].length() <= 0) continue;
            file3 = new File(file3, stringArray[i]);
            file3.deleteOnExit();
            file3.mkdir();
        }
        File file4 = new File(file3, stringArray[stringArray.length - 1]);
        file4.deleteOnExit();
        return file4;
    }

    private void extractEntry(ZipFile zipFile, ZipEntry zipEntry, File file) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        this.extractEntry(inputStream, file);
    }

    @Override
    public ImageInputStream getStream(ManagedImageSource managedImageSource) throws IOException {
        ZipFile zipFile = new ZipFile(managedImageSource.getArchive());
        ZipEntry zipEntry = zipFile.getEntry(managedImageSource.getName());
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        ZipMemoryCacheImageInputStream zipMemoryCacheImageInputStream = new ZipMemoryCacheImageInputStream(zipEntry, inputStream, managedImageSource);
        return zipMemoryCacheImageInputStream;
    }

    @Override
    public void extract(File file) throws IOException {
        ZipFile zipFile = new ZipFile(this.managedFile);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = this.getExtractLocation(zipEntry.getName(), file);
            this.extractEntry(zipFile, zipEntry, file2);
        }
    }
}

