#ifdef GL_ES 
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif

varying vec4 v_color;  
varying vec2 v_texCoords;  
uniform float u_scaleX;
uniform float u_scaleY;
uniform float u_alpha;
uniform vec4 u_bounds;

uniform sampler2D u_texture;  

#define PI 3.1415926538

void main(){              
  vec4 col = v_color * texture2D(u_texture, v_texCoords);
  vec2 ratioPos = (gl_FragCoord.xy - u_bounds.xy) / u_bounds.zw;  
 
  if(0.5-abs(0.5 - ratioPos.x) < u_alpha ) {
    col.a=0.0;
  } else  if(0.5-abs(0.5 - ratioPos.y) < u_scaleY/2.1 ) {    
    col.a=0.0;
  }
 	float factor = pow(u_scaleY, 7.0);
	col.r += factor*.6;
  col.g += factor*0.7;
  col.b += factor*0.9;
  



  gl_FragColor = col;
}

