/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_float;
import com.badlogic.gdx.physics.bullet.collision.btBU_Simplex1to4;
import com.badlogic.gdx.physics.bullet.collision.btBox2dShape;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.badlogic.gdx.physics.bullet.collision.btBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCapsuleShape;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConeShape;
import com.badlogic.gdx.physics.bullet.collision.btConvex2dShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexPointCloudShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCylinderShape;
import com.badlogic.gdx.physics.bullet.collision.btEmptyShape;
import com.badlogic.gdx.physics.bullet.collision.btHeightfieldTerrainShape;
import com.badlogic.gdx.physics.bullet.collision.btMinkowskiSumShape;
import com.badlogic.gdx.physics.bullet.collision.btMultiSphereShape;
import com.badlogic.gdx.physics.bullet.collision.btMultimaterialTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btScaledBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btSphereShape;
import com.badlogic.gdx.physics.bullet.collision.btStaticPlaneShape;
import com.badlogic.gdx.physics.bullet.collision.btTriangleShape;
import com.badlogic.gdx.physics.bullet.collision.btUniformScalingShape;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;

public class btCollisionShape
extends BulletBase {
    private long swigCPtr;

    protected btCollisionShape(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btCollisionShape(long cPtr, boolean cMemoryOwn) {
        this("btCollisionShape", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btCollisionShape obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btCollisionShape(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static btCollisionShape newDerivedObject(long swigCPtr, boolean owner) {
        if (swigCPtr == 0L) {
            return null;
        }
        int shapeType = CollisionJNI.btCollisionShape_getShapeType(swigCPtr, null);
        switch (shapeType) {
            case 0: {
                return new btBoxShape(swigCPtr, owner);
            }
            case 1: {
                return new btTriangleShape(swigCPtr, owner);
            }
            case 2: {
                return new btBU_Simplex1to4(swigCPtr, owner);
            }
            case 3: {
                return new btConvexTriangleMeshShape(swigCPtr, owner);
            }
            case 4: {
                return new btConvexHullShape(swigCPtr, owner);
            }
            case 5: {
                return new btConvexPointCloudShape(swigCPtr, owner);
            }
            case 6: {
                break;
            }
            case 8: {
                return new btSphereShape(swigCPtr, owner);
            }
            case 9: {
                return new btMultiSphereShape(swigCPtr, owner);
            }
            case 10: {
                return new btCapsuleShape(swigCPtr, owner);
            }
            case 11: {
                return new btConeShape(swigCPtr, owner);
            }
            case 12: {
                return new btConvexShape(swigCPtr, owner);
            }
            case 13: {
                return new btCylinderShape(swigCPtr, owner);
            }
            case 14: {
                return new btUniformScalingShape(swigCPtr, owner);
            }
            case 15: {
                break;
            }
            case 16: {
                return new btMinkowskiSumShape(swigCPtr, owner);
            }
            case 17: {
                return new btBox2dShape(swigCPtr, owner);
            }
            case 18: {
                return new btConvex2dShape(swigCPtr, owner);
            }
            case 19: {
                break;
            }
            case 21: {
                return new btBvhTriangleMeshShape(swigCPtr, owner);
            }
            case 22: {
                return new btScaledBvhTriangleMeshShape(swigCPtr, owner);
            }
            case 23: {
                break;
            }
            case 24: {
                return new btHeightfieldTerrainShape(swigCPtr, owner);
            }
            case 26: {
                return new btMultimaterialTriangleMeshShape(swigCPtr, owner);
            }
            case 27: {
                return new btEmptyShape(swigCPtr, owner);
            }
            case 28: {
                return new btStaticPlaneShape(swigCPtr, owner);
            }
            case 29: {
                break;
            }
            case 31: {
                return new btCompoundShape(swigCPtr, owner);
            }
        }
        throw new RuntimeException("Unknown shape type " + Integer.toString(shapeType));
    }

    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btCollisionShape_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        CollisionJNI.btCollisionShape_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btCollisionShape_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btCollisionShape_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btCollisionShape_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btCollisionShape_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btCollisionShape_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btCollisionShape_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public void getAabb(Matrix4 t, Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btCollisionShape_getAabb(this.swigCPtr, this, t, aabbMin, aabbMax);
    }

    public void getBoundingSphere(Vector3 center, SWIGTYPE_p_float radius) {
        CollisionJNI.btCollisionShape_getBoundingSphere(this.swigCPtr, this, center, SWIGTYPE_p_float.getCPtr(radius));
    }

    public float getAngularMotionDisc() {
        return CollisionJNI.btCollisionShape_getAngularMotionDisc(this.swigCPtr, this);
    }

    public float getContactBreakingThreshold(float defaultContactThresholdFactor) {
        return CollisionJNI.btCollisionShape_getContactBreakingThreshold(this.swigCPtr, this, defaultContactThresholdFactor);
    }

    public void calculateTemporalAabb(Matrix4 curTrans, Vector3 linvel, Vector3 angvel, float timeStep, Vector3 temporalAabbMin, Vector3 temporalAabbMax) {
        CollisionJNI.btCollisionShape_calculateTemporalAabb(this.swigCPtr, this, curTrans, linvel, angvel, timeStep, temporalAabbMin, temporalAabbMax);
    }

    public boolean isPolyhedral() {
        return CollisionJNI.btCollisionShape_isPolyhedral(this.swigCPtr, this);
    }

    public boolean isConvex2d() {
        return CollisionJNI.btCollisionShape_isConvex2d(this.swigCPtr, this);
    }

    public boolean isConvex() {
        return CollisionJNI.btCollisionShape_isConvex(this.swigCPtr, this);
    }

    public boolean isNonMoving() {
        return CollisionJNI.btCollisionShape_isNonMoving(this.swigCPtr, this);
    }

    public boolean isConcave() {
        return CollisionJNI.btCollisionShape_isConcave(this.swigCPtr, this);
    }

    public boolean isCompound() {
        return CollisionJNI.btCollisionShape_isCompound(this.swigCPtr, this);
    }

    public boolean isSoftBody() {
        return CollisionJNI.btCollisionShape_isSoftBody(this.swigCPtr, this);
    }

    public boolean isInfinite() {
        return CollisionJNI.btCollisionShape_isInfinite(this.swigCPtr, this);
    }

    public void setLocalScaling(Vector3 scaling) {
        CollisionJNI.btCollisionShape_setLocalScaling(this.swigCPtr, this, scaling);
    }

    public Vector3 getLocalScaling() {
        return CollisionJNI.btCollisionShape_getLocalScaling(this.swigCPtr, this);
    }

    public void calculateLocalInertia(float mass, Vector3 inertia) {
        CollisionJNI.btCollisionShape_calculateLocalInertia(this.swigCPtr, this, mass, inertia);
    }

    public String getName() {
        return CollisionJNI.btCollisionShape_getName(this.swigCPtr, this);
    }

    public int getShapeType() {
        return CollisionJNI.btCollisionShape_getShapeType(this.swigCPtr, this);
    }

    public Vector3 getAnisotropicRollingFrictionDirection() {
        return CollisionJNI.btCollisionShape_getAnisotropicRollingFrictionDirection(this.swigCPtr, this);
    }

    public void setMargin(float margin) {
        CollisionJNI.btCollisionShape_setMargin(this.swigCPtr, this, margin);
    }

    public float getMargin() {
        return CollisionJNI.btCollisionShape_getMargin(this.swigCPtr, this);
    }

    public void setUserPointer(long userPtr) {
        CollisionJNI.btCollisionShape_setUserPointer(this.swigCPtr, this, userPtr);
    }

    public long getUserPointer() {
        return CollisionJNI.btCollisionShape_getUserPointer(this.swigCPtr, this);
    }

    public void setUserIndex(int index) {
        CollisionJNI.btCollisionShape_setUserIndex(this.swigCPtr, this, index);
    }

    public int getUserIndex() {
        return CollisionJNI.btCollisionShape_getUserIndex(this.swigCPtr, this);
    }

    public int calculateSerializeBufferSize() {
        return CollisionJNI.btCollisionShape_calculateSerializeBufferSize(this.swigCPtr, this);
    }

    public String serialize(long dataBuffer, btSerializer serializer) {
        return CollisionJNI.btCollisionShape_serialize(this.swigCPtr, this, dataBuffer, btSerializer.getCPtr(serializer), serializer);
    }

    public void serializeSingleShape(btSerializer serializer) {
        CollisionJNI.btCollisionShape_serializeSingleShape(this.swigCPtr, this, btSerializer.getCPtr(serializer), serializer);
    }
}

