/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.ContactResultCallback;
import com.badlogic.gdx.physics.bullet.collision.ConvexResultCallback;
import com.badlogic.gdx.physics.bullet.collision.RayResultCallback;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseInterface;
import com.badlogic.gdx.physics.bullet.collision.btCollisionConfiguration;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObjectArray;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObjectWrapper;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexShape;
import com.badlogic.gdx.physics.bullet.collision.btDispatcher;
import com.badlogic.gdx.physics.bullet.collision.btDispatcherInfo;
import com.badlogic.gdx.physics.bullet.collision.btOverlappingPairCache;
import com.badlogic.gdx.physics.bullet.linearmath.btIDebugDraw;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;

public class btCollisionWorld
extends BulletBase {
    private long swigCPtr;

    protected btCollisionWorld(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btCollisionWorld(long cPtr, boolean cMemoryOwn) {
        this("btCollisionWorld", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btCollisionWorld obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btCollisionWorld(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btCollisionWorld(btDispatcher dispatcher, btBroadphaseInterface broadphasePairCache, btCollisionConfiguration collisionConfiguration) {
        this(CollisionJNI.new_btCollisionWorld(btDispatcher.getCPtr(dispatcher), dispatcher, btBroadphaseInterface.getCPtr(broadphasePairCache), broadphasePairCache, btCollisionConfiguration.getCPtr(collisionConfiguration), collisionConfiguration), true);
    }

    public void setBroadphase(btBroadphaseInterface pairCache) {
        CollisionJNI.btCollisionWorld_setBroadphase(this.swigCPtr, this, btBroadphaseInterface.getCPtr(pairCache), pairCache);
    }

    public btBroadphaseInterface getBroadphaseConst() {
        long cPtr = CollisionJNI.btCollisionWorld_getBroadphaseConst(this.swigCPtr, this);
        return cPtr == 0L ? null : new btBroadphaseInterface(cPtr, false);
    }

    public btBroadphaseInterface getBroadphase() {
        long cPtr = CollisionJNI.btCollisionWorld_getBroadphase(this.swigCPtr, this);
        return cPtr == 0L ? null : new btBroadphaseInterface(cPtr, false);
    }

    public btOverlappingPairCache getPairCache() {
        long cPtr = CollisionJNI.btCollisionWorld_getPairCache(this.swigCPtr, this);
        return cPtr == 0L ? null : new btOverlappingPairCache(cPtr, false);
    }

    public btDispatcher getDispatcher() {
        long cPtr = CollisionJNI.btCollisionWorld_getDispatcher(this.swigCPtr, this);
        return cPtr == 0L ? null : new btDispatcher(cPtr, false);
    }

    public btDispatcher getDispatcherConst() {
        long cPtr = CollisionJNI.btCollisionWorld_getDispatcherConst(this.swigCPtr, this);
        return cPtr == 0L ? null : new btDispatcher(cPtr, false);
    }

    public void updateSingleAabb(btCollisionObject colObj) {
        CollisionJNI.btCollisionWorld_updateSingleAabb(this.swigCPtr, this, btCollisionObject.getCPtr(colObj), colObj);
    }

    public void updateAabbs() {
        CollisionJNI.btCollisionWorld_updateAabbs(this.swigCPtr, this);
    }

    public void computeOverlappingPairs() {
        CollisionJNI.btCollisionWorld_computeOverlappingPairs(this.swigCPtr, this);
    }

    public void setDebugDrawer(btIDebugDraw debugDrawer) {
        CollisionJNI.btCollisionWorld_setDebugDrawer(this.swigCPtr, this, btIDebugDraw.getCPtr(debugDrawer), debugDrawer);
    }

    public btIDebugDraw getDebugDrawer() {
        long cPtr = CollisionJNI.btCollisionWorld_getDebugDrawer(this.swigCPtr, this);
        return cPtr == 0L ? null : new btIDebugDraw(cPtr, false);
    }

    public void debugDrawWorld() {
        CollisionJNI.btCollisionWorld_debugDrawWorld(this.swigCPtr, this);
    }

    public void debugDrawObject(Matrix4 worldTransform, btCollisionShape shape, Vector3 color) {
        CollisionJNI.btCollisionWorld_debugDrawObject(this.swigCPtr, this, worldTransform, btCollisionShape.getCPtr(shape), shape, color);
    }

    public int getNumCollisionObjects() {
        return CollisionJNI.btCollisionWorld_getNumCollisionObjects(this.swigCPtr, this);
    }

    public void rayTest(Vector3 rayFromWorld, Vector3 rayToWorld, RayResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_rayTest(this.swigCPtr, this, rayFromWorld, rayToWorld, RayResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public void convexSweepTest(btConvexShape castShape, Matrix4 from, Matrix4 to, ConvexResultCallback resultCallback, float allowedCcdPenetration) {
        CollisionJNI.btCollisionWorld_convexSweepTest__SWIG_0(this.swigCPtr, this, btConvexShape.getCPtr(castShape), castShape, from, to, ConvexResultCallback.getCPtr(resultCallback), resultCallback, allowedCcdPenetration);
    }

    public void convexSweepTest(btConvexShape castShape, Matrix4 from, Matrix4 to, ConvexResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_convexSweepTest__SWIG_1(this.swigCPtr, this, btConvexShape.getCPtr(castShape), castShape, from, to, ConvexResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public void contactTest(btCollisionObject colObj, ContactResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_contactTest(this.swigCPtr, this, btCollisionObject.getCPtr(colObj), colObj, ContactResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public void contactPairTest(btCollisionObject colObjA, btCollisionObject colObjB, ContactResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_contactPairTest(this.swigCPtr, this, btCollisionObject.getCPtr(colObjA), colObjA, btCollisionObject.getCPtr(colObjB), colObjB, ContactResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public static void rayTestSingle(Matrix4 rayFromTrans, Matrix4 rayToTrans, btCollisionObject collisionObject, btCollisionShape collisionShape, Matrix4 colObjWorldTransform, RayResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_rayTestSingle(rayFromTrans, rayToTrans, btCollisionObject.getCPtr(collisionObject), collisionObject, btCollisionShape.getCPtr(collisionShape), collisionShape, colObjWorldTransform, RayResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public static void rayTestSingleInternal(Matrix4 rayFromTrans, Matrix4 rayToTrans, btCollisionObjectWrapper collisionObjectWrap, RayResultCallback resultCallback) {
        CollisionJNI.btCollisionWorld_rayTestSingleInternal(rayFromTrans, rayToTrans, btCollisionObjectWrapper.getCPtr(collisionObjectWrap), collisionObjectWrap, RayResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public static void objectQuerySingle(btConvexShape castShape, Matrix4 rayFromTrans, Matrix4 rayToTrans, btCollisionObject collisionObject, btCollisionShape collisionShape, Matrix4 colObjWorldTransform, ConvexResultCallback resultCallback, float allowedPenetration) {
        CollisionJNI.btCollisionWorld_objectQuerySingle(btConvexShape.getCPtr(castShape), castShape, rayFromTrans, rayToTrans, btCollisionObject.getCPtr(collisionObject), collisionObject, btCollisionShape.getCPtr(collisionShape), collisionShape, colObjWorldTransform, ConvexResultCallback.getCPtr(resultCallback), resultCallback, allowedPenetration);
    }

    public static void objectQuerySingleInternal(btConvexShape castShape, Matrix4 convexFromTrans, Matrix4 convexToTrans, btCollisionObjectWrapper colObjWrap, ConvexResultCallback resultCallback, float allowedPenetration) {
        CollisionJNI.btCollisionWorld_objectQuerySingleInternal(btConvexShape.getCPtr(castShape), castShape, convexFromTrans, convexToTrans, btCollisionObjectWrapper.getCPtr(colObjWrap), colObjWrap, ConvexResultCallback.getCPtr(resultCallback), resultCallback, allowedPenetration);
    }

    public void addCollisionObject(btCollisionObject collisionObject, int collisionFilterGroup, int collisionFilterMask) {
        CollisionJNI.btCollisionWorld_addCollisionObject__SWIG_0(this.swigCPtr, this, btCollisionObject.getCPtr(collisionObject), collisionObject, collisionFilterGroup, collisionFilterMask);
    }

    public void addCollisionObject(btCollisionObject collisionObject, int collisionFilterGroup) {
        CollisionJNI.btCollisionWorld_addCollisionObject__SWIG_1(this.swigCPtr, this, btCollisionObject.getCPtr(collisionObject), collisionObject, collisionFilterGroup);
    }

    public void addCollisionObject(btCollisionObject collisionObject) {
        CollisionJNI.btCollisionWorld_addCollisionObject__SWIG_2(this.swigCPtr, this, btCollisionObject.getCPtr(collisionObject), collisionObject);
    }

    public btCollisionObjectArray getCollisionObjectArray() {
        return new btCollisionObjectArray(CollisionJNI.btCollisionWorld_getCollisionObjectArray(this.swigCPtr, this), false);
    }

    public btCollisionObjectArray getCollisionObjectArrayConst() {
        return new btCollisionObjectArray(CollisionJNI.btCollisionWorld_getCollisionObjectArrayConst(this.swigCPtr, this), false);
    }

    public void removeCollisionObject(btCollisionObject collisionObject) {
        CollisionJNI.btCollisionWorld_removeCollisionObject(this.swigCPtr, this, btCollisionObject.getCPtr(collisionObject), collisionObject);
    }

    public void performDiscreteCollisionDetection() {
        CollisionJNI.btCollisionWorld_performDiscreteCollisionDetection(this.swigCPtr, this);
    }

    public btDispatcherInfo getDispatchInfo() {
        return new btDispatcherInfo(CollisionJNI.btCollisionWorld_getDispatchInfo(this.swigCPtr, this), false);
    }

    public btDispatcherInfo getDispatchInfoConst() {
        return new btDispatcherInfo(CollisionJNI.btCollisionWorld_getDispatchInfoConst(this.swigCPtr, this), false);
    }

    public boolean getForceUpdateAllAabbs() {
        return CollisionJNI.btCollisionWorld_getForceUpdateAllAabbs(this.swigCPtr, this);
    }

    public void setForceUpdateAllAabbs(boolean forceUpdateAllAabbs) {
        CollisionJNI.btCollisionWorld_setForceUpdateAllAabbs(this.swigCPtr, this, forceUpdateAllAabbs);
    }

    public void serialize(btSerializer serializer) {
        CollisionJNI.btCollisionWorld_serialize(this.swigCPtr, this, btSerializer.getCPtr(serializer), serializer);
    }
}

