/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.softbody;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.btMatrix3x3FloatData;
import com.badlogic.gdx.physics.bullet.linearmath.btTransformFloatData;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3FloatData;
import com.badlogic.gdx.physics.bullet.softbody.SoftbodyJNI;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class SoftBodyClusterData
extends BulletBase {
    private long swigCPtr;

    protected SoftBodyClusterData(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public SoftBodyClusterData(long cPtr, boolean cMemoryOwn) {
        this("SoftBodyClusterData", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(SoftBodyClusterData obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SoftbodyJNI.delete_SoftBodyClusterData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setFramexform(btTransformFloatData value) {
        SoftbodyJNI.SoftBodyClusterData_framexform_set(this.swigCPtr, this, btTransformFloatData.getCPtr(value), value);
    }

    public btTransformFloatData getFramexform() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_framexform_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTransformFloatData(cPtr, false);
    }

    public void setLocii(btMatrix3x3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_locii_set(this.swigCPtr, this, btMatrix3x3FloatData.getCPtr(value), value);
    }

    public btMatrix3x3FloatData getLocii() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_locii_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMatrix3x3FloatData(cPtr, false);
    }

    public void setInvwi(btMatrix3x3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_invwi_set(this.swigCPtr, this, btMatrix3x3FloatData.getCPtr(value), value);
    }

    public btMatrix3x3FloatData getInvwi() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_invwi_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMatrix3x3FloatData(cPtr, false);
    }

    public void setCom(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_com_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getCom() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_com_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setVimpulses(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_vimpulses_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getVimpulses() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_vimpulses_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setDimpulses(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_dimpulses_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getDimpulses() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_dimpulses_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setLv(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_lv_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getLv() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_lv_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setAv(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_av_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getAv() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_av_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setFramerefs(btVector3FloatData value) {
        SoftbodyJNI.SoftBodyClusterData_framerefs_set(this.swigCPtr, this, btVector3FloatData.getCPtr(value), value);
    }

    public btVector3FloatData getFramerefs() {
        long cPtr = SoftbodyJNI.SoftBodyClusterData_framerefs_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3FloatData(cPtr, false);
    }

    public void setNodeIndices(IntBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        SoftbodyJNI.SoftBodyClusterData_nodeIndices_set(this.swigCPtr, this, value);
    }

    public IntBuffer getNodeIndices() {
        return SoftbodyJNI.SoftBodyClusterData_nodeIndices_get(this.swigCPtr, this);
    }

    public void setMasses(FloatBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        SoftbodyJNI.SoftBodyClusterData_masses_set(this.swigCPtr, this, value);
    }

    public FloatBuffer getMasses() {
        return SoftbodyJNI.SoftBodyClusterData_masses_get(this.swigCPtr, this);
    }

    public void setNumFrameRefs(int value) {
        SoftbodyJNI.SoftBodyClusterData_numFrameRefs_set(this.swigCPtr, this, value);
    }

    public int getNumFrameRefs() {
        return SoftbodyJNI.SoftBodyClusterData_numFrameRefs_get(this.swigCPtr, this);
    }

    public void setNumNodes(int value) {
        SoftbodyJNI.SoftBodyClusterData_numNodes_set(this.swigCPtr, this, value);
    }

    public int getNumNodes() {
        return SoftbodyJNI.SoftBodyClusterData_numNodes_get(this.swigCPtr, this);
    }

    public void setNumMasses(int value) {
        SoftbodyJNI.SoftBodyClusterData_numMasses_set(this.swigCPtr, this, value);
    }

    public int getNumMasses() {
        return SoftbodyJNI.SoftBodyClusterData_numMasses_get(this.swigCPtr, this);
    }

    public void setIdmass(float value) {
        SoftbodyJNI.SoftBodyClusterData_idmass_set(this.swigCPtr, this, value);
    }

    public float getIdmass() {
        return SoftbodyJNI.SoftBodyClusterData_idmass_get(this.swigCPtr, this);
    }

    public void setImass(float value) {
        SoftbodyJNI.SoftBodyClusterData_imass_set(this.swigCPtr, this, value);
    }

    public float getImass() {
        return SoftbodyJNI.SoftBodyClusterData_imass_get(this.swigCPtr, this);
    }

    public void setNvimpulses(int value) {
        SoftbodyJNI.SoftBodyClusterData_nvimpulses_set(this.swigCPtr, this, value);
    }

    public int getNvimpulses() {
        return SoftbodyJNI.SoftBodyClusterData_nvimpulses_get(this.swigCPtr, this);
    }

    public void setNdimpulses(int value) {
        SoftbodyJNI.SoftBodyClusterData_ndimpulses_set(this.swigCPtr, this, value);
    }

    public int getNdimpulses() {
        return SoftbodyJNI.SoftBodyClusterData_ndimpulses_get(this.swigCPtr, this);
    }

    public void setNdamping(float value) {
        SoftbodyJNI.SoftBodyClusterData_ndamping_set(this.swigCPtr, this, value);
    }

    public float getNdamping() {
        return SoftbodyJNI.SoftBodyClusterData_ndamping_get(this.swigCPtr, this);
    }

    public void setLdamping(float value) {
        SoftbodyJNI.SoftBodyClusterData_ldamping_set(this.swigCPtr, this, value);
    }

    public float getLdamping() {
        return SoftbodyJNI.SoftBodyClusterData_ldamping_get(this.swigCPtr, this);
    }

    public void setAdamping(float value) {
        SoftbodyJNI.SoftBodyClusterData_adamping_set(this.swigCPtr, this, value);
    }

    public float getAdamping() {
        return SoftbodyJNI.SoftBodyClusterData_adamping_get(this.swigCPtr, this);
    }

    public void setMatching(float value) {
        SoftbodyJNI.SoftBodyClusterData_matching_set(this.swigCPtr, this, value);
    }

    public float getMatching() {
        return SoftbodyJNI.SoftBodyClusterData_matching_get(this.swigCPtr, this);
    }

    public void setMaxSelfCollisionImpulse(float value) {
        SoftbodyJNI.SoftBodyClusterData_maxSelfCollisionImpulse_set(this.swigCPtr, this, value);
    }

    public float getMaxSelfCollisionImpulse() {
        return SoftbodyJNI.SoftBodyClusterData_maxSelfCollisionImpulse_get(this.swigCPtr, this);
    }

    public void setSelfCollisionImpulseFactor(float value) {
        SoftbodyJNI.SoftBodyClusterData_selfCollisionImpulseFactor_set(this.swigCPtr, this, value);
    }

    public float getSelfCollisionImpulseFactor() {
        return SoftbodyJNI.SoftBodyClusterData_selfCollisionImpulseFactor_get(this.swigCPtr, this);
    }

    public void setContainsAnchor(int value) {
        SoftbodyJNI.SoftBodyClusterData_containsAnchor_set(this.swigCPtr, this, value);
    }

    public int getContainsAnchor() {
        return SoftbodyJNI.SoftBodyClusterData_containsAnchor_get(this.swigCPtr, this);
    }

    public void setCollide(int value) {
        SoftbodyJNI.SoftBodyClusterData_collide_set(this.swigCPtr, this, value);
    }

    public int getCollide() {
        return SoftbodyJNI.SoftBodyClusterData_collide_get(this.swigCPtr, this);
    }

    public void setClusterIndex(int value) {
        SoftbodyJNI.SoftBodyClusterData_clusterIndex_set(this.swigCPtr, this, value);
    }

    public int getClusterIndex() {
        return SoftbodyJNI.SoftBodyClusterData_clusterIndex_get(this.swigCPtr, this);
    }

    public SoftBodyClusterData() {
        this(SoftbodyJNI.new_SoftBodyClusterData(), true);
    }
}

