/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest;

import com.tann.dice.gameplay.battleTest.BattleResult;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.battleTest.testProvider.BattleTestProvider;
import com.tann.dice.gameplay.battleTest.testProvider.TierStats;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BattleTest {
    static final boolean print = false;
    BattleTestProvider tierStats;
    static final List<MonsterType> types = new ArrayList<MonsterType>();
    static List<MonsterType> attackers = new ArrayList<MonsterType>();
    private static final boolean partialDamageCountsAsReduction = true;

    public BattleTest(int playerTier, Difficulty difficulty, MonsterType ... types) {
        this((BattleTestProvider)new TierStats(playerTier, difficulty), types);
    }

    public BattleTest(BattleTestProvider btp, MonsterType ... types) {
        this(btp, Arrays.asList(types));
    }

    public BattleTest(BattleTestProvider btp, List<MonsterType> types) {
        this.setup(btp, types);
    }

    void setup(BattleTestProvider ts, List<MonsterType> types) {
        BattleTest.types.clear();
        BattleTest.types.addAll(types);
        this.tierStats = ts;
    }

    public BattleResult runBattle() {
        float remainingMonsterHp = 0.0f;
        for (int i = 0; i < types.size(); ++i) {
            MonsterType t = types.get(i);
            remainingMonsterHp += t.getEffectiveHp();
        }
        float startingMonsterHp = remainingMonsterHp;
        float totalDamageToPlayer = 0.0f;
        float unspentPlayerDamageCounter = 0.0f;
        int turn = 0;
        int MAX_TURNS = 20;
        while (types.size() > 0) {
            MonsterType bestTarget;
            float bestTargetHp;
            float livingHeroesMult = TierStats.getLivingHeroesMultiplier(totalDamageToPlayer / this.tierStats.getTotalHealth());
            if (livingHeroesMult <= 0.0f) {
                return new BattleResult(false, 1.0f - remainingMonsterHp / startingMonsterHp);
            }
            float playerDmgOutput = this.tierStats.getAvgDamage() * livingHeroesMult;
            remainingMonsterHp -= playerDmgOutput;
            unspentPlayerDamageCounter += playerDmgOutput;
            float playerDefOutput = this.tierStats.getAvgMitigation() * livingHeroesMult;
            List<MonsterType> attackingMonsters = this.getAttackingMonsters();
            while (unspentPlayerDamageCounter > 0.0f && types.size() > 0 && attackingMonsters.size() > 0 && unspentPlayerDamageCounter >= (bestTargetHp = (bestTarget = BattleTest.getBestTarget(attackingMonsters, turn)).getEffectiveHp())) {
                unspentPlayerDamageCounter -= bestTargetHp;
                types.remove(bestTarget);
                attackingMonsters.remove(bestTarget);
            }
            if (types.size() > 0) {
                float enemyDamage = this.calculateEnemyDamage(attackingMonsters, unspentPlayerDamageCounter, BattleTest.getBestTarget(attackingMonsters, turn));
                float actualDamage = Math.max(0.0f, enemyDamage - playerDefOutput);
                totalDamageToPlayer += Math.max(0.0f, actualDamage);
            }
            if (++turn < 20) continue;
            return new BattleResult(false, -1.0f);
        }
        return new BattleResult(true, totalDamageToPlayer / this.tierStats.getTotalHealth());
    }

    private List<MonsterType> getAttackingMonsters() {
        attackers.clear();
        int totalFullness = 0;
        for (int i = 0; i < types.size(); ++i) {
            MonsterType type = types.get(i);
            if ((totalFullness += type.size.getReinforceSize()) > 165) break;
            attackers.add(type);
        }
        return attackers;
    }

    public String toString() {
        String result = "Battletest";
        for (MonsterType mt : types) {
            result = result + mt.getName(false) + ",";
        }
        return result;
    }

    private float calculateEnemyDamage(List<MonsterType> attackingMonsters, float unspentDmg, MonsterType bestTarget) {
        float total = 0.0f;
        int attackingMonstersSize = attackingMonsters.size();
        for (int i = 0; i < attackingMonstersSize; ++i) {
            MonsterType mt = attackingMonsters.get(i);
            total += mt.getAvgEffectTier();
        }
        if (bestTarget != null) {
            if (unspentDmg > bestTarget.getEffectiveHp() * 0.9f) {
                float ratio = 0.75f;
                total -= bestTarget.getAvgEffectTier() * ratio;
            } else if ((double)unspentDmg > (double)bestTarget.getEffectiveHp() * 0.8) {
                float ratio = 0.4f;
                total -= bestTarget.getAvgEffectTier() * ratio;
            }
        }
        return total;
    }

    private static MonsterType getBestTarget(List<MonsterType> attackingMonsters, int turn) {
        MonsterType mt = BattleTest.getBestTarget(attackingMonsters, false, turn);
        if (mt != null) {
            return mt;
        }
        mt = BattleTest.getBestTarget(attackingMonsters, true, turn);
        if (mt != null) {
            return mt;
        }
        if (attackingMonsters.size() > 0) {
            return attackingMonsters.get(0);
        }
        return null;
    }

    private static MonsterType getBestTarget(List<MonsterType> attackingMonsters, boolean ranged, int turn) {
        float bestRatio = -500.0f;
        MonsterType best = null;
        for (int i = 0; i < attackingMonsters.size(); ++i) {
            float ratio;
            MonsterType t = attackingMonsters.get(i);
            if (!ranged && t.calcBackRow(turn) || !((ratio = t.getBattleTestRatio()) > bestRatio)) continue;
            bestRatio = ratio;
            best = t;
        }
        return best;
    }
}

