/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest;

import com.tann.dice.gameplay.battleTest.BattleResult;
import com.tann.dice.gameplay.battleTest.BattleTest;
import com.tann.dice.gameplay.battleTest.NoLevelGeneratedException;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.battleTest.template.LevelTemplate;
import com.tann.dice.gameplay.battleTest.testProvider.BattleTestProvider;
import com.tann.dice.gameplay.battleTest.testProvider.TierStats;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.level.Level;
import com.tann.dice.util.NDimension;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BattleTestUtils {
    public static final int MAX_DIMENSION_LOOKBACK = 2;
    public static final int MAX_ENEMIES = 8;
    public static final int MAX_ENEMIES_SINGLE = 12;
    public static final int ATTEMPTS = 40;
    public static final int BOSS_ATTEMPTS = 6;
    public static final float TARGET_HEALTH_LOST_RATIO = 0.45f;
    public static final float MIN_HEALTH_LOST_RATIO = 0.14999999f;
    public static final float ACCEPTED_HP_DIFF = 0.08f;
    private static MonsterType barrel;
    private static MonsterType chief;
    private static MonsterType bandit;
    private static MonsterType slimer;
    private static MonsterType slate;
    private static MonsterType log;
    private static MonsterType goblin;
    static Map<MonsterType, Integer> map;
    static List<MonsterType> allMonsters;

    public static Level generateStdLevel(Zone zone, TierStats ts, List<NDimension> closeLevels, boolean printInfo) throws NoLevelGeneratedException {
        float rarityRandom = Tann.random();
        ArrayList<TP<Float, List<MonsterType>>> result = new ArrayList<TP<Float, List<MonsterType>>>();
        for (int i = 0; i < 40; ++i) {
            LevelTemplate zoneTemplate = new LevelTemplate(zone, ts, rarityRandom);
            TP<Float, List<MonsterType>> t = BattleTestUtils.generateMonsterList(zoneTemplate, ts, 1, printInfo);
            if (t == null) continue;
            result.add(t);
        }
        return BattleTestUtils.generateFromResults(result, closeLevels);
    }

    public static Level generateBossLevel(LevelTemplate template, TierStats ts, List<NDimension> closeLevels, boolean printInfo) throws NoLevelGeneratedException {
        ArrayList<TP<Float, List<MonsterType>>> result = new ArrayList<TP<Float, List<MonsterType>>>();
        for (int i = 0; i < 6; ++i) {
            template.resetExtras();
            TP<Float, List<MonsterType>> t = BattleTestUtils.generateMonsterList(template, ts, 1, printInfo);
            if (t == null) continue;
            result.add(t);
        }
        return BattleTestUtils.generateFromResults(result, closeLevels);
    }

    private static Level generateFromResults(List<TP<Float, List<MonsterType>>> result, final List<NDimension> closeLevels) throws NoLevelGeneratedException {
        if (result.size() == 0) {
            TannLog.log("Failed to generate level");
            throw new NoLevelGeneratedException();
        }
        ArrayList<Integer> seen = new ArrayList<Integer>();
        for (int ri = result.size() - 1; ri >= 0; --ri) {
            int hash = 0;
            List list = (List)result.get((int)ri).b;
            for (int mi = 0; mi < list.size(); ++mi) {
                hash += ((MonsterType)list.get(mi)).hashCode();
            }
            if (seen.contains(hash)) {
                result.remove(ri);
                continue;
            }
            seen.add(hash);
        }
        Collections.sort(result, new Comparator<TP<Float, List<MonsterType>>>(){

            @Override
            public int compare(TP<Float, List<MonsterType>> o1, TP<Float, List<MonsterType>> o2) {
                boolean o2ok;
                boolean o1ok = Math.abs(((Float)o1.a).floatValue()) < 0.08f;
                boolean bl = o2ok = Math.abs(((Float)o2.a).floatValue()) < 0.08f;
                if (closeLevels.size() > 0 && o1ok && o2ok) {
                    return (int)(-Math.signum(BattleTestUtils.fromTypeList((List)o1.b).getMinDist(closeLevels) - BattleTestUtils.fromTypeList((List)o2.b).getMinDist(closeLevels)));
                }
                if (o1ok && o2ok) {
                    return 0;
                }
                return (int)Math.signum(Math.abs(((Float)o1.a).floatValue()) - Math.abs(((Float)o2.a).floatValue()));
            }
        });
        TP<Float, List<MonsterType>> chosen = result.get(0);
        return new Level((Float)chosen.a, (List)chosen.b);
    }

    private static TP<Float, List<MonsterType>> generateMonsterList(LevelTemplate template, TierStats ts, int attempts, boolean printInfo) {
        if (printInfo) {
            System.out.println("generating fights for tier " + ts + "(" + attempts + " attempts)");
        }
        boolean single = template.getInitialSetup().size() + template.getExtrasList().size() == 1;
        int maxMonsters = single ? 12 : 8;
        long t = System.currentTimeMillis();
        ArrayList<MonsterType> best = new ArrayList<MonsterType>();
        float bestDifficulty = 500000.0f;
        float bestDifficultyDiff = 50000.0f;
        BattleTest bt = new BattleTest((BattleTestProvider)ts, template.getInitialSetup());
        block0: for (int i = 0; i < attempts; ++i) {
            List<MonsterType> types = template.getInitialSetup();
            BattleTestUtils.clearLimits(types);
            while (types.size() <= maxMonsters) {
                bt.setup(ts, types);
                BattleResult br = bt.runBattle();
                if (!br.playerVictory) continue block0;
                float healthLost = br.damageTaken;
                float healthLossDiff = healthLost - 0.45f;
                if (healthLost >= 0.14999999f && Math.abs(healthLossDiff) < Math.abs(bestDifficultyDiff) && BattleTestUtils.monstersValid(types)) {
                    bestDifficultyDiff = healthLossDiff;
                    bestDifficulty = healthLost;
                    best.clear();
                    best.addAll(types);
                }
                if (healthLost > 0.45f) continue block0;
                MonsterType newMon = template.getExtra();
                types.add(newMon);
                if (!BattleTestUtils.addMonsterExceedLimits(newMon)) continue;
                continue block0;
            }
        }
        if (best.isEmpty()) {
            if (printInfo) {
                System.err.println("Failed to generate level for tier " + ts + ", template: " + template);
            }
            return null;
        }
        long taken = System.currentTimeMillis() - t;
        float per = (float)taken / (float)attempts;
        if (printInfo) {
            System.out.println("target: 0.45");
            System.out.println(bestDifficulty + ":" + best);
            System.out.println("avg ms:" + per + ", total:" + taken);
        }
        return new TP<Float, List<MonsterType>>(Float.valueOf(bestDifficultyDiff), best);
    }

    public static void init() {
        barrel = MonsterTypeLib.byName("barrel");
        chief = MonsterTypeLib.byName("warchief");
        bandit = MonsterTypeLib.byName("bandit");
        slimer = MonsterTypeLib.byName("slimer");
        slate = MonsterTypeLib.byName("slate");
        log = MonsterTypeLib.byName("log");
        goblin = MonsterTypeLib.byName("goblin");
    }

    private static void clearLimits(List<MonsterType> types) {
        map.clear();
        for (int i = 0; i < types.size(); ++i) {
            BattleTestUtils.addMonsterExceedLimits(types.get(i));
        }
    }

    private static boolean addMonsterExceedLimits(MonsterType type) {
        Integer v = map.get(type);
        if (v == null) {
            v = 0;
        }
        Integer n = v;
        v = v + 1;
        map.put(type, v);
        return v > type.getMaxInFight();
    }

    private static boolean monstersValid(List<MonsterType> monsters) {
        if (monsters.size() == 0) {
            return false;
        }
        if (monsters.get(0) == barrel || monsters.get(monsters.size() - 1) == barrel) {
            return false;
        }
        if (monsters.contains(chief) && monsters.size() <= 2) {
            return false;
        }
        if (monsters.contains(bandit)) {
            if (monsters.contains(slate)) {
                return false;
            }
            if (monsters.contains(slimer)) {
                return false;
            }
        }
        if (monsters.contains(log) && monsters.contains(goblin)) {
            return false;
        }
        boolean allRanged = true;
        for (int i = 0; i < monsters.size(); ++i) {
            MonsterType mt = monsters.get(i);
            if (mt.calcBackRow(0)) continue;
            allRanged = false;
            break;
        }
        return !allRanged;
    }

    public static NDimension fromTypeList(List<MonsterType> types) {
        int extraDimensions = 2;
        float[] data = new float[extraDimensions + allMonsters.size()];
        data[0] = (float)types.size() * 0.1f;
        data[1] = (float)Tann.countDistinct(types) * 0.02f;
        for (int i = 0; i < types.size(); ++i) {
            MonsterType type = types.get(i);
            if (type.isGenerated() || type.getName(false).contains(".")) continue;
            int index = allMonsters.indexOf(type);
            if (index == -1) {
                TannLog.log("Weird dimension error: " + type);
                continue;
            }
            data[index + extraDimensions] = 1.0f;
        }
        return new NDimension(data);
    }

    static {
        map = new HashMap<MonsterType, Integer>();
        allMonsters = MonsterTypeLib.getMasterCopy();
    }
}

