/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest.template;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.battleTest.testProvider.TierStats;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LevelTemplate {
    private final List<MonsterType> fixed;
    private final List<MonsterType> potentialExtras;
    private final int numExtras;
    private final List<MonsterType> actualExtras = new ArrayList<MonsterType>();
    private boolean boss;

    public LevelTemplate(List<MonsterType> fixed, List<MonsterType> potentialExtras) {
        this.fixed = fixed;
        this.potentialExtras = potentialExtras;
        this.numExtras = potentialExtras.size();
        this.resetExtras();
    }

    public LevelTemplate(Zone zone, Difficulty difficulty, int playerTier, float rarityRandom) {
        this.fixed = new ArrayList<MonsterType>();
        if (playerTier == 0 && difficulty == Difficulty.Easy) {
            this.potentialExtras = Arrays.asList(MonsterTypeLib.byName("wolf"));
            this.numExtras = 1;
            this.resetExtras();
            return;
        }
        List<MonsterType> pExtras = MonsterTypeLib.getMonsters(zone, playerTier, rarityRandom);
        if (pExtras.size() <= 3) {
            throw new RuntimeException("Too few monsters for zone: " + playerTier + ":" + difficulty + ":" + (Object)((Object)zone) + "(" + pExtras + ")");
        }
        this.potentialExtras = Collections.unmodifiableList(pExtras);
        int maxExtras = difficulty.getMaxMonsterTypes() + (Math.random() > 0.5 ? 0 : -1);
        int tmpNumExtras = Math.min(maxExtras, pExtras.size());
        if (Math.random() > 0.85) {
            tmpNumExtras = 1;
        }
        this.numExtras = tmpNumExtras;
        this.resetExtras();
    }

    public LevelTemplate(Zone zone, TierStats ts) {
        this(zone, ts, 0.0f);
    }

    public LevelTemplate(Zone zone, TierStats ts, float rarityRandom) {
        this(zone, ts.difficulty, ts.playerTier, rarityRandom);
    }

    public List<MonsterType> getInitialSetup() {
        ArrayList<MonsterType> start = new ArrayList<MonsterType>(this.fixed);
        for (int mIndex = 0; mIndex < this.actualExtras.size(); ++mIndex) {
            MonsterType mt = this.actualExtras.get(mIndex);
            for (int i = 0; i < mt.getMinInFight(); ++i) {
                start.add(mt);
            }
        }
        if (start.size() == 0) {
            start.add(this.getExtra());
        }
        return start;
    }

    public MonsterType getExtra() {
        if (this.actualExtras.size() == 0) {
            return null;
        }
        return Tann.random(this.actualExtras);
    }

    public String toString() {
        return "fixed: " + this.fixed + " -- variable: " + this.actualExtras;
    }

    public List<MonsterType> getExtrasList() {
        return this.actualExtras;
    }

    public void resetExtras() {
        this.actualExtras.clear();
        this.actualExtras.addAll(this.potentialExtras);
        Collections.shuffle(this.actualExtras);
        while (this.actualExtras.size() > this.numExtras) {
            this.actualExtras.remove(0);
        }
        if (!this.boss && OptionLib.GENERATED_MONSTERS.c()) {
            int amtToGen = Tann.randomRound((float)this.actualExtras.size() * OptionLib.genChance());
            for (int i = 0; i < amtToGen; ++i) {
                this.actualExtras.set(i, PipeMonster.makeGen());
            }
        }
    }

    public boolean isLocked() {
        for (MonsterType mt : this.fixed) {
            if (!UnUtil.isLocked(mt)) continue;
            return true;
        }
        return false;
    }

    public Actor getFirstMonsterDisplay() {
        Pixl p = new Pixl(2, 3).border(Colours.red);
        if (this.fixed.isEmpty()) {
            return p.text("?:?").pix();
        }
        Actor dp = this.fixed.get(0).makeEnt().getDiePanel().withoutDice().getFullActor();
        p.actor(dp, (float)Main.width * 0.8f);
        return p.pix();
    }

    public String getMainString() {
        if (this.fixed.isEmpty()) {
            return "nofix";
        }
        return this.fixed.get(0).getName();
    }

    public void markAsBoss() {
        this.boss = true;
    }
}

