/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe;

import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipeUtils {
    private static Map<Integer, List<Pipe>> genPipesCache = new HashMap<Integer, List<Pipe>>();
    private static Map<Integer, Float> innateRarityMap = new HashMap<Integer, Float>();

    public static void init() {
        genPipesCache = new HashMap<Integer, List<Pipe>>();
        innateRarityMap = new HashMap<Integer, Float>();
    }

    public static <T> List<Pipe<T>> getGenPipes(List<Pipe<T>> pipes, boolean wild) {
        int key = pipes.hashCode() + (wild ? 1 : 0);
        if (genPipesCache.get(key) == null) {
            ArrayList<Pipe<T>> result = new ArrayList<Pipe<T>>();
            for (int i = 0; i < pipes.size(); ++i) {
                Pipe<T> p = pipes.get(i);
                if (!p.canGenerate(wild)) continue;
                result.add(p);
            }
            genPipesCache.put(key, result);
        }
        return genPipesCache.get(key);
    }

    public static <T> Pipe<T> randomPipeForGen(List<Pipe<T>> gennablePipes, boolean wild) {
        float total = PipeUtils.getInnateRarityTotal(gennablePipes, wild);
        float rnd = Tann.random(total);
        for (int i = 0; i < gennablePipes.size(); ++i) {
            Pipe<T> p = gennablePipes.get(i);
            if (!((rnd -= p.getRarity(wild)) < 0.0f)) continue;
            return p;
        }
        TannLog.error("Error getting rarity pipe: " + wild);
        return gennablePipes.get(0);
    }

    private static <T> float getInnateRarityTotal(List<Pipe<T>> gennablePipes, boolean wild) {
        int key = gennablePipes.hashCode() + (wild ? 1 : 0);
        if (innateRarityMap.get(key) == null) {
            float result = 0.0f;
            for (Pipe<T> gennablePipe : gennablePipes) {
                result += gennablePipe.getRarity(wild);
            }
            innateRarityMap.put(key, Float.valueOf(result));
        }
        return innateRarityMap.get(key).floatValue();
    }
}

