/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.bill.ETBill;
import com.tann.dice.gameplay.content.ent.type.bill.HTBill;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.SingleAttempt;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.generation.SpellGeneration;
import com.tann.dice.gameplay.effect.targetable.ability.generation.TacticGeneration;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellLib;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.modifier.generation.GenUtils;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.personal.Generated;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnTactic;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.WhiskerRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class PipeHeroGenerated
extends PipeRegexNamed<HeroType> {
    public static final int MAX_GENERATE_TIER = 999;
    private static final int MAX_SEED = (int)Math.pow(16.0, 3.0);
    private static final SingleAttempt REG_GEN = new SingleAttempt(){

        @Override
        public EntSide getRandomSide(Random r, HTBill htBill, List<EntSide> options, float targetStrength, float STRENGTH_CUTOFF, HeroType example, int sideIndex) {
            EntSide newSide = options.get(r.nextInt(options.size())).copy();
            PipeHeroGenerated.affectValue(newSide, example, targetStrength, r);
            return newSide;
        }
    };
    public static String RS = "blip";
    public static String BS = "blep";

    public PipeHeroGenerated() {
        super(HEROCOL, UP_TO_THREE_DIGITS_TIER, PipeHeroGenerated.prnS("\\."), UP_TO_FIFTEEN_HEX);
    }

    @Override
    protected HeroType internalMake(String[] groups) {
        String colS = groups[0];
        String tierS = groups[1];
        String seedS = groups[2];
        HeroCol col = HeroCol.byName(colS);
        if (col == null) {
            return null;
        }
        if (!Tann.isInt(tierS)) {
            return null;
        }
        int tier = Integer.parseInt(tierS);
        if (tier < 0 || tier > 999) {
            return null;
        }
        long seed = GenUtils.hex(seedS);
        if (seed < 0L) {
            return null;
        }
        List<EntSide> options = HeroTypeUtils.getSidesWithColour(col, true, false);
        return PipeHeroGenerated.multiAttempt(col, tier, seed, options, col.shortName() + tierS + "." + seedS, 1.0f, REG_GEN, PipeHeroGenerated.texture(col, tier));
    }

    public static HeroType multiAttempt(HeroCol col, int tier, long seed, List<EntSide> sides, String name, float cutoff, SingleAttempt sa, TextureAtlas.AtlasRegion texture) {
        return PipeHeroGenerated.generate(col, tier, seed, sides, name, cutoff, sa, texture);
    }

    static void affectValue(EntSide newSide, HeroType example, float targetStrength, Random r) {
        float MAX_MULTIPLIER = 2.0f;
        Eff e = newSide.getBaseEffect();
        if (!e.hasValue()) {
            return;
        }
        e.setValue(1);
        for (int i = 0; i < 3; ++i) {
            float val = newSide.getApproxTotalEffectTier(example);
            float ratio = val / targetStrength;
            int newValue = (int)Math.round(Math.pow(r.nextFloat(), 2.0) / (double)ratio * 2.0 * (double)e.getValue());
            if (e.hasKeyword(Keyword.pain) && newValue > example.hp + 2) {
                newValue /= 2;
            }
            e.setValue(Math.max(1, Math.min(999, newValue)));
            if (!((float)newValue * ratio < 0.28f) || e.getType() == EffType.Reroll) continue;
            e.setValue(1);
        }
    }

    public static boolean shouldAddGenerate() {
        return OptionLib.GENERATED_HEROES.c() && Tann.chance(OptionLib.genChance());
    }

    public static HeroType generate(HeroCol col, int tier) {
        return PipeHeroGenerated.generate(col, tier, (int)(Math.random() * (double)MAX_SEED));
    }

    public static String getGeneratedString(long seed) {
        return GenUtils.hex(seed);
    }

    public static HeroType generate(HeroCol col, int tier, long seed) {
        if (tier < 0 || !col.isBasic()) {
            return PipeHero.getMissingno();
        }
        try {
            List<EntSide> options = HeroTypeUtils.getSidesWithColour(col, true, false);
            String left = col.shortName() + tier;
            String right = PipeHeroGenerated.getGeneratedString(seed);
            String name = left + "." + right;
            HeroType result = PipeHeroGenerated.multiAttempt(col, tier, seed, options, name, 1.0f, REG_GEN, PipeHeroGenerated.texture(col, tier));
            if (result != null) {
                return result;
            }
            TannLog.error("Failed to generate: " + col + tier + ":" + seed);
        }
        catch (Exception e) {
            e.printStackTrace();
            TannLog.error(e.getClass().getSimpleName() + "pfnw");
        }
        return PipeHero.getMissingno();
    }

    private static TextureAtlas.AtlasRegion texture(HeroCol col, int tier) {
        int graphicalTier = Math.max(1, Math.min(3, tier));
        String s = "portrait/hero/special/generated/" + col.shortName() + graphicalTier;
        for (int i = 0; i < ImageUtils.genImages.size(); ++i) {
            TextureAtlas.AtlasRegion ar = ImageUtils.genImages.get(i);
            if (!ar.name.startsWith(s)) continue;
            return ar;
        }
        return null;
    }

    private static HeroType generate(HeroCol col, int tier, long seed, List<EntSide> options, String name, float STRENGTH_CUTOFF, SingleAttempt singleAttempt, TextureAtlas.AtlasRegion texture) {
        if (tier > 999) {
            return PipeHero.getMissingno();
        }
        WhiskerRandom r = new WhiskerRandom(seed);
        HTBill builder = new HTBill(col, tier);
        builder.name(name);
        builder.hp((int)((r.nextFloat() * 0.6f + 0.75f) * HeroTypeUtils.getHpFor(tier)));
        builder.sides(ESB.blank, ESB.blank, ESB.blank, ESB.blank, ESB.blank, ESB.blank);
        builder.trait((Personal)new Generated(), false);
        HeroType example = builder.bEntType();
        float targetStrength = HeroTypeUtils.getEffectTierFor(tier);
        ETBill htBill = null;
        int ATTEMPTS = 20;
        float maxPowerDelta = 0.3f;
        float alwaysSub = 0.015000001f;
        Trait t = null;
        boolean hasTactic = false;
        for (int i = 0; i < 20 && htBill == null; ++i) {
            float strengthCut = STRENGTH_CUTOFF - (float)i / 20.0f * 0.3f - 0.015000001f;
            if (t != null) {
                builder.removeTrait(t);
                t = null;
            }
            hasTactic = false;
            if (example.heroCol == HeroCol.green) {
                if ((double)r.nextFloat() < 0.8 && (t = PipeHeroGenerated.addRandomGreenTrait(example.level, r)) != null) {
                    builder.trait(t);
                }
                if (t == null) {
                    t = new Trait(new LearnTactic(new Tactic("placeholder", null, (Eff)null)));
                    hasTactic = true;
                    builder.trait(t);
                }
            }
            htBill = PipeHeroGenerated.singleAttempt(r, builder, options, targetStrength, strengthCut, example, singleAttempt);
        }
        if (htBill == null) {
            return PipeHero.getMissingno();
        }
        if (hasTactic) {
            htBill.removeTrait(t);
            for (int p = 0; p < 5; ++p) {
                Tactic again = TacticGeneration.makeTacticSafeMaybeNull(name, example.level, r, builder.getSides());
                if (again == null) continue;
                htBill.trait(new LearnTactic(again));
                break;
            }
        }
        final HeroType result = builder.bEntType();
        List<EntSide> sides = Arrays.asList(result.sides);
        Collections.sort(sides, new Comparator<EntSide>(){

            @Override
            public int compare(EntSide o1, EntSide o2) {
                return (int)Math.signum(o2.getApproxTotalEffectTier(result) - o1.getApproxTotalEffectTier(result));
            }
        });
        EntSide[] arrSides = sides.toArray(new EntSide[0]);
        PipeHeroGenerated.symmetricate(arrSides);
        builder.sides(arrSides);
        result = builder.bEntType();
        if (HeroTypeUtils.isSpelly(result.heroCol)) {
            Spell s = null;
            if (tier >= 0 && tier <= 2 && r.nextInt(2) == 0) {
                s = PipeHeroGenerated.getRandomDesignedHeroSpell(result.heroCol, tier, r);
            }
            if (s == null) {
                s = SpellGeneration.generate(tier, seed, col);
            }
            if (s == null) {
                s = SpellLib.MISSINGNO;
            }
            builder.spell(s);
        }
        if (texture != null) {
            builder.arOverride(texture);
        }
        return ((HTBill)builder.resetOffsets()).bEntType();
    }

    private static Trait addRandomGreenTrait(int traitTier, Random r) {
        if (traitTier <= 0 || traitTier > 3) {
            return null;
        }
        List<HeroType> options = HeroTypeUtils.getFilteredTypes(HeroCol.green, Math.max(1, Math.min(3, traitTier)), true);
        HeroType tmp = Tann.randomElement(options, r);
        if (tmp == null) {
            return null;
        }
        if (tmp.getName().equalsIgnoreCase("mimic")) {
            return null;
        }
        if (Collision.collides(tmp.getCollisionBits(), Collision.MODIFIER)) {
            return null;
        }
        ArrayList traits = new ArrayList(tmp.traits);
        for (int i = traits.size() - 1; i >= 0; --i) {
            if (!((Trait)traits.get((int)i)).personal.metaOnly()) continue;
            traits.remove(i);
        }
        if (traits.size() == 1) {
            return (Trait)traits.get(0);
        }
        return null;
    }

    private static HTBill singleAttempt(Random r, HTBill builder, List<EntSide> options, float targetStrength, float STRENGTH_CUTOFF, HeroType example, SingleAttempt singleAttempt) {
        builder.sides(ESB.blank, ESB.blank, ESB.blank, ESB.blank, ESB.blank, ESB.blank);
        float min = targetStrength * STRENGTH_CUTOFF;
        float max = targetStrength * (2.0f - STRENGTH_CUTOFF);
        int miniAttempts = 10;
        for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
            for (int attemptIndex = 0; attemptIndex < 10; ++attemptIndex) {
                EntSide newSide = singleAttempt.getRandomSide(r, builder, options, targetStrength, STRENGTH_CUTOFF, example, sideIndex);
                builder.setSide(sideIndex, newSide);
                HeroType built = builder.bEntType();
                float pw = built.getTotalEffectTier();
                if (Float.isNaN(pw)) {
                    TannLog.error("nan " + built.heroCol);
                }
                if (attemptIndex == 9) {
                    if (pw > max) {
                        return null;
                    }
                    if (pw < min && sideIndex == 5) {
                        return null;
                    }
                }
                if (pw > max || !(pw > min) || !PipeHeroGenerated.finalChecks(built)) continue;
                return builder;
            }
        }
        return null;
    }

    public static boolean finalChecks(HeroType ht) {
        return PipeHeroGenerated.colourCheck(ht);
    }

    private static boolean colourCheck(HeroType ht) {
        switch (ht.heroCol) {
            case grey: {
                return !(!PipeHeroGenerated.has(ht, EffType.Shield) && !PipeHeroGenerated.has(ht, EffType.Buff) || !PipeHeroGenerated.has(ht, EffType.Damage) && !PipeHeroGenerated.has(ht, EffType.Mana) && !PipeHeroGenerated.has(ht, Keyword.manaGain) && !PipeHeroGenerated.has(ht, Keyword.repel) && !PipeHeroGenerated.has(ht, EffType.Recharge));
            }
            case yellow: 
            case orange: {
                return PipeHeroGenerated.has(ht, EffType.Damage);
            }
            case red: {
                return !(!PipeHeroGenerated.has(ht, EffType.Heal) && !PipeHeroGenerated.has(ht, EffType.HealAndShield) && !PipeHeroGenerated.has(ht, Keyword.selfHeal) && !PipeHeroGenerated.has(ht, EffType.Resurrect) && !PipeHeroGenerated.has(ht, EffType.Buff) || !PipeHeroGenerated.has(ht, EffType.Mana) && !PipeHeroGenerated.has(ht, Keyword.manaGain));
            }
            case blue: {
                return PipeHeroGenerated.has(ht, EffType.Mana) || PipeHeroGenerated.has(ht, Keyword.manaGain);
            }
        }
        return true;
    }

    public static boolean has(HeroType ht, EffType et) {
        EntSide[] sides = ht.getNiceSides();
        for (int i = 0; i < sides.length; ++i) {
            Eff e = sides[i].getBaseEffect();
            if (e.getType() != et) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrSimilarKeyword(HeroType ht, EffType et) {
        EntSide[] sides = ht.getNiceSides();
        for (int i = 0; i < sides.length; ++i) {
            Eff e = sides[i].getBaseEffect();
            if (e.getType() == et) {
                return true;
            }
            if (!KUtils.hasEquivalentKeyword(et, e)) continue;
            return true;
        }
        return false;
    }

    private static boolean has(HeroType ht, Keyword k) {
        EntSide[] sides = ht.getNiceSides();
        for (int i = 0; i < sides.length; ++i) {
            Eff e = sides[i].getBaseEffect();
            if (!e.hasKeyword(k)) continue;
            return true;
        }
        return false;
    }

    private static void symmetricate(EntSide[] arrSides) {
        int numBlanks = 0;
        for (EntSide es : arrSides) {
            if (es.getBaseEffect().getType() != EffType.Blank) continue;
            ++numBlanks;
        }
        if (numBlanks == 3) {
            Tann.swap(arrSides, 2, 4);
        }
        PipeHeroGenerated.swapCheck(arrSides, 1, 2, 3);
        PipeHeroGenerated.swapCheck(arrSides, 1, 3, 2);
        PipeHeroGenerated.swapCheck(arrSides, 0, 2, 3);
        PipeHeroGenerated.swapCheck(arrSides, 4, 2, 3, 3, 5);
    }

    private static void swapCheck(EntSide[] arrSides, int from, int to, int same) {
        if (arrSides[from].same(arrSides[same]) && !arrSides[from].same(arrSides[to])) {
            Tann.swap(arrSides, from, to);
        }
    }

    private static void swapCheck(EntSide[] arrSides, int from, int to, int same1, int same2, int diff1) {
        if (arrSides[from].same(arrSides[same1]) && arrSides[from].same(arrSides[same2]) && !arrSides[from].same(arrSides[to]) && !arrSides[from].same(arrSides[diff1])) {
            Tann.swap(arrSides, from, to);
        }
    }

    private static Spell getRandomDesignedHeroSpell(HeroCol heroCol, int tier, Random r) {
        List<HeroType> options = HeroTypeUtils.getFilteredTypes(heroCol, Math.min(3, tier), true);
        HeroType ht = Tann.randomElement(options, r);
        if (ht == null) {
            return null;
        }
        if (ht.traits.size() == 0) {
            System.out.println("huh" + ht.getName(false));
            return null;
        }
        for (Trait trait : ht.traits) {
            Personal pt = trait.personal;
            Ability a = pt.getAbility();
            if (!(a instanceof Spell)) continue;
            return (Spell)a;
        }
        return null;
    }

    @Override
    public HeroType example() {
        return PipeHeroGenerated.generate(Tann.random(HeroCol.basics()), Tann.randomInt((int)Tann.random(10.0f)));
    }
}

