/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.monster;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.trigger.personal.item.AsIfHasItem;

public class PipeMonsterItem
extends PipeRegexNamed<MonsterType> {
    private static final PRNPart MID = new PRNMid("i");

    public PipeMonsterItem() {
        super(MONSTER, MID, ITEM);
    }

    @Override
    public MonsterType example() {
        int i = 0;
        if (i < 100) {
            return this.make(MonsterTypeLib.randomWithRarity(), ItemLib.random());
        }
        return this.make(MonsterTypeLib.byName("slate"), ItemLib.byName("leather vest"));
    }

    @Override
    protected MonsterType internalMake(String[] groups) {
        String mName = groups[0];
        String tMName = groups[1];
        if (PipeMonsterItem.bad(mName, tMName)) {
            return null;
        }
        return this.make(MonsterTypeLib.byName(mName), ItemLib.byName(tMName));
    }

    private MonsterType make(MonsterType src, Item traitSrc) {
        if (src == null || traitSrc == null || src.isMissingno() || traitSrc.isMissingno()) {
            return null;
        }
        AsIfHasItem aiha = new AsIfHasItem(traitSrc);
        MTBill mtb = EntTypeUtils.copy(src);
        mtb.name(src.getName() + MID + traitSrc.getName());
        mtb.trait(new Trait(aiha));
        return mtb.bEntType();
    }
}

