/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemKeyword;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.FlatBonus;
import com.tann.dice.gameplay.trigger.personal.hp.MaxHP;
import java.util.List;

public class AutoItemTier {
    public static Float guessTier(Item i) {
        List<Personal> ps = i.getPersonalTriggers();
        float total = 0.0f;
        for (Personal p : ps) {
            Float f = AutoItemTier.guessTier(p);
            if (f == null) {
                return null;
            }
            total += f.floatValue();
        }
        return Float.valueOf(total);
    }

    private static Float guessTier(Personal p) {
        if (p.metaOnly()) {
            return Float.valueOf(0.0f);
        }
        if (p instanceof AffectSides) {
            return AutoItemTier.extractFromAffect((AffectSides)p);
        }
        if (p instanceof MaxHP) {
            return AutoItemTier.extractFromMax((MaxHP)p);
        }
        return null;
    }

    private static Float extractFromMax(MaxHP p) {
        return Float.valueOf((float)p.maxHpModifier * 1.2f);
    }

    private static Float extractFromAffect(AffectSides p) {
        float total = 0.0f;
        float happiness = 0.0f;
        if (p.getConditions().isEmpty()) {
            happiness = AutoItemTier.getFeltProportionOfWholeDiceReplaced(SpecificSidesType.All);
        } else {
            for (AffectSideCondition condition : p.getConditions()) {
                if (condition instanceof SpecificSidesCondition) {
                    SpecificSidesCondition ssc = (SpecificSidesCondition)condition;
                    happiness = AutoItemTier.getFeltProportionOfWholeDiceReplaced(ssc.specificSidesType);
                    continue;
                }
                return null;
            }
        }
        for (AffectSideEffect effect : p.getEffects()) {
            if (effect instanceof FlatBonus) {
                FlatBonus fb = (FlatBonus)effect;
                if (fb.isIndexed()) {
                    return null;
                }
                int b = fb.getSingleBonus();
                total += ModTierUtils.heroBonusAllSides(b) * 3.0f * happiness;
                continue;
            }
            if (effect instanceof AddKeyword) {
                AddKeyword ak = (AddKeyword)effect;
                for (Keyword referencedKeyword : ak.getReferencedKeywords()) {
                    if (PipeItemKeyword.isBanned(referencedKeyword)) {
                        return null;
                    }
                    total += KUtils.getModTierAllHero(referencedKeyword) * happiness;
                }
                continue;
            }
            return null;
        }
        if (total == 0.0f) {
            return null;
        }
        return Float.valueOf(total);
    }

    public static float guessPowerReplace(int assumedTier, EntSide es, SpecificSidesType sst) {
        float pw = es.getApproxTotalEffectTier(HeroTypeUtils.defaultHero(assumedTier));
        float result = 0.0f;
        result += pw * (float)sst.sideIndices.length;
        float tierPower = HeroTypeUtils.getEffectTierFor(assumedTier);
        return result -= AutoItemTier.getPainCausedFromReplacing(sst) * tierPower;
    }

    private static float getPainCausedFromReplacing(SpecificSidesType sst) {
        float total = 0.0f;
        for (int side : sst.sideIndices) {
            float val;
            switch (side) {
                case 2: {
                    val = 1.0f;
                    break;
                }
                case 4: {
                    val = 0.8f;
                    break;
                }
                case 0: 
                case 1: {
                    val = 0.5f;
                    break;
                }
                case 3: {
                    val = 0.3f;
                    break;
                }
                case 5: {
                    val = 0.03f;
                    break;
                }
                default: {
                    throw new RuntimeException("uhoh: " + (Object)((Object)sst));
                }
            }
            total += val;
        }
        return total;
    }

    private static float getFeltProportionOfWholeDiceReplaced(SpecificSidesType sst) {
        float total = 0.0f;
        for (int side : sst.sideIndices) {
            float singleSidePowerRatio;
            switch (side) {
                case 2: {
                    singleSidePowerRatio = 0.3f;
                    break;
                }
                case 4: {
                    singleSidePowerRatio = 0.25f;
                    break;
                }
                case 0: 
                case 1: {
                    singleSidePowerRatio = 0.17f;
                    break;
                }
                case 3: {
                    singleSidePowerRatio = 0.07f;
                    break;
                }
                case 5: {
                    singleSidePowerRatio = 0.04f;
                    break;
                }
                default: {
                    throw new RuntimeException("uhoh: " + (Object)((Object)sst));
                }
            }
            total += singleSidePowerRatio;
        }
        return (float)Math.sqrt(total);
    }
}

