/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonsterGenerated;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.eff.GlobalSummonMonsterStartTurn;
import com.tann.dice.gameplay.trigger.global.level.GlobalAddMonster;
import com.tann.dice.util.Tann;

public class PipeModAddMonsterMeta
extends PipeRegexNamed<Modifier> {
    private static String[] PREFS = new String[]{"add", "summon", "3rd", "trio"};
    public static boolean ALLOW_PLURAL_NAME = false;

    public PipeModAddMonsterMeta() {
        super(PipeModAddMonsterMeta.prnSCapturedOneOf(PREFS), PipeModAddMonsterMeta.prnS("\\."), MONSTER);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String add = groups[0];
        String monster = groups[1];
        if (PipeModAddMonsterMeta.bad(add, monster)) {
            return null;
        }
        MonsterType mt = MonsterTypeLib.byName(monster);
        if (ALLOW_PLURAL_NAME && mt.isMissingno() && (mt = MonsterTypeLib.byPluralName(monster)) == null) {
            return null;
        }
        if (mt.isMissingno()) {
            return null;
        }
        return this.make(add, mt);
    }

    private Modifier make(String add, MonsterType mon) {
        int pi = Tann.indexOfEq(PREFS, add.toLowerCase());
        if (pi == -1) {
            return null;
        }
        Modifier m = this.actuallyMake(pi, mon);
        return m;
    }

    private Modifier actuallyMake(int pi, MonsterType mon) {
        if (mon.isMissingno()) {
            return null;
        }
        switch (pi) {
            case 0: {
                return GlobalAddMonster.makeGenerated(mon, false);
            }
            case 1: {
                return GlobalSummonMonsterStartTurn.makeGenerated(mon, true);
            }
            case 2: {
                return GlobalSummonMonsterStartTurn.makeGenerated(mon, false);
            }
            case 3: {
                return GlobalAddMonster.makeGenerated(mon, true);
            }
        }
        throw new RuntimeException("Unimp monstermeta");
    }

    @Override
    public Modifier example() {
        return this.make(Tann.random(PREFS), MonsterTypeLib.randomWithRarity());
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    public float getRarity(boolean wild) {
        return wild ? 1.0f : 2.0f;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        float c = (float)Math.random();
        String pref = c < 0.8f ? PREFS[0] : (c < 0.9f ? PREFS[1] : PREFS[2]);
        MonsterType type = this.getTypeForGen(wild);
        return this.make(pref, type);
    }

    private MonsterType getTypeForGen(boolean wild) {
        int attempts = 200;
        for (int i = 0; i < 200; ++i) {
            MonsterType mt = wild ? PipeMonsterGenerated.makeMonstExt() : MonsterTypeLib.randomWithRarity();
            if (mt.isUnique()) continue;
            return mt;
        }
        return MonsterTypeLib.byName("missingno");
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

