/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.RandomCheck;
import java.util.ArrayList;

public class PipeModPart
extends PipeRegexNamed<Modifier> {
    private static final PRNPart sep = new PRNMid("part");

    public PipeModPart() {
        super(MOD, sep, PipeRegexNamed.DIGIT);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String mod1 = groups[0];
        String partNum = groups[1];
        return this.make(ModifierLib.byName(mod1), Integer.parseInt(partNum));
    }

    private Modifier make(Modifier a, int index) {
        if (a == null || a.isMissingno()) {
            return null;
        }
        ArrayList<Global> globals = new ArrayList<Global>(a.getGlobals());
        for (int i = globals.size() - 1; i >= 0; --i) {
            if (!((Global)globals.get(i)).metaOnly()) continue;
            globals.remove(i);
        }
        if (globals.size() < 2 || globals.size() <= index) {
            return null;
        }
        Global only = (Global)globals.get(index);
        String name = a.getName() + sep + index;
        return new Modifier(name, only);
    }

    @Override
    public Modifier example() {
        Modifier m = RandomCheck.checkedRandom(ModifierLib.makeSupplier(), new Checker<Modifier>(){

            @Override
            public boolean check(Modifier m) {
                return m.getSingleGlobalOrNull() == null;
            }
        }, ModifierLib.byName("crust"));
        return this.make(m, (int)(Math.random() * 2.0));
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

