/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.trigger.global.item.GlobalStartWithItem;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class PipeModPermaItem
extends PipeRegexNamed<Modifier> {
    static final String PREF = "i";

    public PipeModPermaItem() {
        super(new PRNPref(PREF), ITEM);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        Item it = ItemLib.byName(groups[0]);
        return PipeModPermaItem.make(it);
    }

    public static Modifier make(Item it) {
        if (it.isMissingno()) {
            return null;
        }
        float modTier = TierUtils.itemModTier(it.getTier());
        return new Modifier(modTier, GlobalStartWithItem.nameFor(it.getName(false)), new GlobalStartWithItem(it));
    }

    @Override
    public Modifier example() {
        if (Tann.chance(0.2f)) {
            return PipeModPermaItem.make(ItemLib.random());
        }
        return PipeModPermaItem.make(Tann.pick(PipeModPermaItem.getAllItemsWithQualityRange(-10, -1)));
    }

    private static List<Item> getAllItemsWithQualityRange(int min, int max) {
        ArrayList<Item> results = new ArrayList<Item>();
        boolean allowLocked = false;
        for (Item e : ItemLib.getMasterCopy()) {
            if (UnUtil.isLocked(e) || e.getTier() < min || e.getTier() > max) continue;
            results.add(e);
        }
        return results;
    }

    @Override
    public float getRarity(boolean wild) {
        return wild ? 1.0f : 1.0f;
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        if (wild) {
            return PipeModPermaItem.make(PipeItem.makeGen());
        }
        return this.example();
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

