/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex;

import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.util.Tann;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PipeRegex<T>
extends Pipe<T> {
    final Pattern pattern;
    final int numGroups;

    protected PipeRegex(String patternString) {
        this.pattern = Pattern.compile(patternString, 2);
        this.numGroups = Tann.countCharsInString('(', patternString) - Tann.countStringsInString("\\(", patternString);
    }

    @Override
    protected final boolean nameValid(String name) {
        return this.pattern.matcher(name).matches();
    }

    private String[] groups(String input) {
        Matcher m = this.pattern.matcher(input);
        m.find();
        if (m.groupCount() != this.numGroups) {
            return null;
        }
        String[] result = new String[m.groupCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = m.group(i + 1);
        }
        return result;
    }

    @Override
    protected final T make(String name) {
        String[] groups = this.groups(name);
        if (groups == null) {
            return null;
        }
        if (PipeRegex.bad(groups)) {
            return null;
        }
        return this.internalMake(this.groups(name));
    }

    protected abstract T internalMake(String[] var1);

    @Override
    public String document() {
        return this.pattern.toString();
    }
}

