/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMeta;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSource;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture.textureAlg.TextureAlgorithm;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class PipeMetaTexture<T>
extends PipeMeta<T> {
    private final TextureAlgorithm textureAlgorithm;

    public PipeMetaTexture(DataSource sourceAlgorithm, TextureAlgorithm textureAlgorithm) {
        super(sourceAlgorithm, sourceAlgorithm.srcPart, textureAlgorithm.sep, textureAlgorithm.prnPart);
        this.textureAlgorithm = textureAlgorithm;
    }

    @Override
    protected T internalMake(String[] groups) {
        String obj = groups[0];
        String[] extra = new String[groups.length - 1];
        System.arraycopy(groups, 1, extra, 0, groups.length - 1);
        Object t = this.makeT(obj);
        if (t == null) {
            return null;
        }
        TextureAtlas.AtlasRegion ar = this.getImage(t);
        if (!OptionLib.DISABLE_RUNTIME_TEXTURES.c()) {
            String keytag = this.textureAlgorithm.getClass().getSimpleName() + ":" + Tann.arrayToString(groups, "|");
            ar = this.textureAlgorithm.fromString(this.getImage(t), extra, keytag);
            if (ar == null) {
                return null;
            }
        }
        if (ar == null) {
            return t;
        }
        return this.combine(t, ar, this.getName(t) + this.textureAlgorithm.sep + this.textureAlgorithm.getSuffix(extra));
    }

    private TextureAtlas.AtlasRegion getImage(T t) {
        return this.sourceAlgorithm.getImage(t);
    }

    @Override
    public T example() {
        Object t = this.exampleBase();
        String[] extra = this.textureAlgorithm.getExampleTex();
        String[] all = new String[extra.length + 1];
        System.arraycopy(extra, 0, all, 1, extra.length);
        all[0] = t.toString();
        return this.internalMake(all);
    }

    public static <T> List<PipeMetaTexture<T>> makeAll(DataSource<T> sa) {
        ArrayList<PipeMetaTexture<T>> result = new ArrayList<PipeMetaTexture<T>>();
        for (TextureAlgorithm value : TextureAlgorithm.makeAll()) {
            result.add(new PipeMetaTexture<T>(sa, value));
        }
        return result;
    }

    @Override
    public boolean isSlow() {
        return true;
    }

    @Override
    public boolean isTexturey() {
        return true;
    }

    @Override
    public boolean skipAPI() {
        return this.textureAlgorithm.skipAPI();
    }
}

