/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture.textureAlg;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.texture.textureAlg.TextureAlgorithm;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNLinked;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.AbilityUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Tann;
import com.tann.dice.util.image.ImageFilter;

public class TextureAlgorithmTxEcDraw
extends TextureAlgorithm {
    TextureAlgorithmTxEcDraw() {
        super(new PRNMid("draw"), new PRNLinked(PipeRegexNamed.ENTITY_OR_ITEM, PipeRegexNamed.COLON, PipeRegexNamed.UP_TO_TWO_DIGITS, PipeRegexNamed.COLON, PipeRegexNamed.UP_TO_TWO_DIGITS), "silver pendant:4:8");
    }

    @Override
    public TextureAtlas.AtlasRegion fromString(TextureAtlas.AtlasRegion origin, String[] data, String keytag) {
        String decalString = data[0];
        String xString = data[1];
        String yString = data[2];
        if (!Tann.isInt(xString) || !Tann.isInt(yString)) {
            return null;
        }
        TextureRegion decal = TextureAlgorithmTxEcDraw.loadDecal(decalString);
        if (decal == null) {
            return null;
        }
        int x = Integer.parseInt(xString);
        int y = Integer.parseInt(yString);
        Texture t = ImageFilter.stamp(origin, decal, x, y, keytag);
        return new TextureAtlas.AtlasRegion(t, 0, 0, t.getWidth(), t.getHeight());
    }

    public static TextureRegion loadDecal(String decalName) {
        for (TextureAtlas.AtlasRegion decal : Images.decals) {
            if (!decal.name.toLowerCase().endsWith(decalName.toLowerCase())) continue;
            return decal;
        }
        Item i = ItemLib.byName(decalName);
        if (!i.isMissingno()) {
            return i.getImage();
        }
        Ability s = AbilityUtils.byName(decalName);
        if (s != null) {
            return s.getImage();
        }
        EntType e = EntTypeUtils.byName(decalName);
        if (e != null && !e.isMissingno()) {
            return e.portrait;
        }
        return null;
    }

    @Override
    public String getSuffix(String[] extra) {
        return extra[0] + ":" + extra[1] + ":" + extra[2];
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

