/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobSmall;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.VisualEffectType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.GSCConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.TargetingRestriction;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.entState.StateEvent;
import com.tann.dice.gameplay.fightLog.event.snapshot.SnapshotEvent;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.linked.GlobalNumberLimit;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.StateConditionType;
import com.tann.dice.screens.shaderFx.DeathType;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Eff
implements Cloneable {
    public static final int DEBUG_EFF_VALUE = -999;
    private final EffType type;
    private final TargetingType targetingType;
    private final String overrideDescription;
    private final VisualEffectType visualEffect;
    private final List<ConditionalRequirement> restrictions;
    private final String summonType;
    private final boolean friendly;
    private final boolean basic;
    private final boolean hasValue;
    private final StateEvent event;
    private final SnapshotEvent snapshotEvent;
    private List<Keyword> keywords;
    private Buff buff;
    private Eff orFriendly;
    private Eff orEnemy;
    private final Eff[] bonusUntargetedEffects;
    private int value;
    static final String EXTRA_EFF_SEP = ", then ";
    static final List<Keyword> empty = Collections.unmodifiableList(new ArrayList());
    private List<Keyword> bonusKeywords = new ArrayList<Keyword>();

    public Eff(EffType type, TargetingType targetingType, VisualEffectType visualEffect, List<ConditionalRequirement> restrictions, int value, Buff buff, String summonType, boolean friendly, boolean hasValue, List<Keyword> keywords, Eff orFriendly, Eff orEnemy, Eff[] bonusUntargetedEffects, boolean basic, StateEvent event, SnapshotEvent snapshotEvent, String overrideDescription) {
        this.type = type;
        this.targetingType = targetingType;
        this.visualEffect = visualEffect;
        this.restrictions = restrictions;
        this.value = GlobalNumberLimit.box(value);
        this.buff = buff;
        this.summonType = summonType;
        this.friendly = friendly;
        this.keywords = keywords;
        this.orFriendly = orFriendly;
        this.orEnemy = orEnemy;
        this.bonusUntargetedEffects = bonusUntargetedEffects;
        this.hasValue = hasValue || type == EffType.Or && this.getOr(true).hasValue();
        this.basic = basic;
        this.event = event;
        this.snapshotEvent = snapshotEvent;
        this.overrideDescription = overrideDescription;
        this.init();
    }

    private void init() {
        if (this.getType() == EffType.Or) {
            this.setValue(Math.max(this.getOr(false).getValue(), this.getOr(true).getValue()));
        }
    }

    public static String describe(Eff[] effs) {
        String result = "";
        for (Eff e : effs) {
            String desc = e.describe(false);
            if (desc.isEmpty()) continue;
            if (result.length() > 0) {
                result = result + EXTRA_EFF_SEP;
            }
            result = result + e.describe(false).toLowerCase();
        }
        return Eff.addKeywordsToString(result, effs[0]);
    }

    public String toString() {
        return this.describe();
    }

    private String getRestrictionsString() {
        if (this.getRestrictions().size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int times = 0;
        for (ConditionalRequirement restriction : this.getRestrictions(false)) {
            String restr;
            if (times > 0) {
                result.append(" and");
            }
            if ((restr = restriction.describe(this)) == null) continue;
            result.append(" ").append(restr);
            ++times;
        }
        return result.toString();
    }

    public Eff copy() {
        Eff e = null;
        try {
            e = (Eff)this.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        if (this.getBuff() != null) {
            e.setBuff(this.getBuff().copy());
        }
        if (this.getType() == EffType.Or) {
            e.orEnemy = e.orEnemy.copy();
            e.orFriendly = e.orFriendly.copy();
        }
        e.keywords = new ArrayList<Keyword>(this.keywords);
        e.bonusKeywords = new ArrayList<Keyword>(this.bonusKeywords);
        return e;
    }

    public String describe() {
        return this.describe(true);
    }

    public String describe(boolean includeKeywords) {
        if (this.getOverrideDescription() != null) {
            return this.getOverrideDescription();
        }
        if (this.skipDescription()) {
            return "";
        }
        String result = this.getType().describe(this);
        result = result + this.getRestrictionsString();
        if (this.bonusUntargetedEffects != null) {
            result = result + EXTRA_EFF_SEP;
            for (Eff bonusUntargetedEffect : this.bonusUntargetedEffects) {
                result = result + bonusUntargetedEffect.describe(false).toLowerCase();
            }
        }
        if (includeKeywords) {
            result = Eff.addKeywordsToString(result, this);
        }
        return result;
    }

    public static String addKeywordsToString(String current, Eff eff) {
        String keywords = eff.makeKeywordsString();
        if (keywords != null) {
            if (!keywords.isEmpty() && !current.isEmpty()) {
                current = current + " ";
            }
            current = current + keywords;
        }
        return current;
    }

    public static String hyphenInsteadOfNewline(String current) {
        return current.replaceAll("\\[n\\]", " - ");
    }

    private boolean skipDescription() {
        return this.getType() == EffType.Event || this.getType() == EffType.SnapshotEvent;
    }

    private String makeKeywordsString() {
        List<Keyword> keywords = this.getKeywordsForDisplay(false);
        if (keywords.size() == 0) {
            return null;
        }
        return KUtils.describeKeywords(keywords);
    }

    public VisualEffectType getVisual() {
        return this.visualEffect;
    }

    public int getValue() {
        return this.value;
    }

    public String getNoTargetsString() {
        if (this.isUnusableBecauseNerfed()) {
            return "Does nothing due to curses!";
        }
        return "No valid targets";
    }

    public Buff getBuffAndCopy() {
        return this.getBuff().copy();
    }

    public void playSound() {
        String[] s = this.getSound();
        if (s != null) {
            Sounds.playSound(s);
        }
    }

    public String[] getSound() {
        for (Keyword k : this.keywords) {
            switch (k) {
                case boost: 
                case permaBoost: {
                    return Sounds.boost;
                }
                case smith: {
                    return Sounds.smith;
                }
                case weaken: {
                    return Sounds.deboost;
                }
                case repel: {
                    return Sounds.clangs;
                }
            }
        }
        switch (this.getType()) {
            case Recharge: {
                return Sounds.boost;
            }
            case HealAndShield: {
                return Sounds.heals;
            }
            case Shield: {
                if (this.getTargetingType() == TargetingType.Group) {
                    return Sounds.song;
                }
                return Sounds.blocks;
            }
            case Resurrect: {
                return Sounds.resurrect;
            }
            case Buff: {
                return this.getBuff().trigger.getSound();
            }
            case RedirectIncoming: {
                return Sounds.whistle;
            }
            case Mana: {
                return Sounds.magic;
            }
            case Reroll: {
                return Sounds.onRoll;
            }
            case Kill: {
                return Sounds.summonImp;
            }
            case MultiplyShields: {
                return Sounds.clink;
            }
            case JustTarget: {
                return Sounds.arrowWobble;
            }
        }
        return null;
    }

    public boolean isFriendly() {
        return this.friendly ^ this.hasKeyword(Keyword.possessed);
    }

    public boolean needsTarget() {
        return this.getTargetingType().requiresTarget;
    }

    public void setValue(int value) {
        if (!this.hasValue) {
            return;
        }
        this.value = GlobalNumberLimit.box(value);
    }

    public List<Ent> getSummons() {
        if (this.getType() != EffType.Summon) {
            return new ArrayList<Ent>();
        }
        ArrayList<Ent> summons = new ArrayList<Ent>();
        for (int i = 0; i < this.getValue(); ++i) {
            Monster m = MonsterTypeLib.byName(this.getSummonType()).makeEnt();
            summons.add(m);
        }
        return summons;
    }

    public List<ConditionalRequirement> getRestrictions() {
        return this.getRestrictions(true);
    }

    public List<ConditionalRequirement> getRestrictions(boolean includeKeywords) {
        ArrayList<ConditionalRequirement> result = new ArrayList<ConditionalRequirement>(this.restrictions);
        if (includeKeywords) {
            for (Keyword k : this.getKeywordForGameplay()) {
                ConditionalRequirement cr = k.getTargetingConditionalRequirement();
                if (cr == null) continue;
                result.add(cr);
            }
        }
        return result;
    }

    public boolean hasKeyword(Keyword keyword) {
        return this.keywords.contains((Object)keyword);
    }

    public boolean hasRestriction(TargetingRestriction restriction) {
        return this.getRestrictions().contains(restriction);
    }

    public boolean hasRestriction(StateConditionType restriction) {
        for (ConditionalRequirement cr : this.getRestrictions()) {
            GSCConditionalRequirement gcr;
            if (!(cr instanceof GSCConditionalRequirement) || (gcr = (GSCConditionalRequirement)cr).getGsc().getStateConditionType() != restriction) continue;
            return true;
        }
        return false;
    }

    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public List<Keyword> getKeywordForGameplay() {
        return this.keywords;
    }

    public List<Keyword> getReferencedKeywords() {
        if (this.type == EffType.Buff) {
            ArrayList<Keyword> result = new ArrayList<Keyword>();
            result.addAll(this.keywords);
            result.addAll(this.buff.trigger.getReferencedKeywords());
            return result;
        }
        return this.keywords;
    }

    public List<Keyword> getKeywordsForDisplay(boolean explain) {
        ArrayList<Keyword> all = new ArrayList<Keyword>(this.getKeywords());
        if (explain && this.getType() == EffType.Buff) {
            all.addAll(this.getBuff().trigger.getReferencedKeywords());
        }
        return all;
    }

    public Eff getOr(boolean friendly) {
        return friendly ? this.orFriendly : this.orEnemy;
    }

    public boolean hasType(EffType targetType, boolean basicOnly, Ent target) {
        if (basicOnly && !this.isBasic()) {
            return false;
        }
        if (this.getType() == targetType) {
            return true;
        }
        if (this.getType() == EffType.HealAndShield && (targetType == EffType.Heal || targetType == EffType.Shield)) {
            return true;
        }
        if (this.getType() == EffType.Or) {
            if (target != null) {
                return this.getOr(target.isPlayer()).hasType(targetType, basicOnly);
            }
            return this.getOr(true).hasType(targetType, basicOnly) || this.getOr(false).hasType(targetType, basicOnly);
        }
        return false;
    }

    public boolean hasType(EffType targetType, boolean basicOnly) {
        return this.hasType(targetType, basicOnly, null);
    }

    public void addKeyword(Keyword newKeyword) {
        if (!KUtils.allowAddingKeyword(newKeyword, this)) {
            return;
        }
        int priority = newKeyword.getSortPriority();
        boolean added = false;
        for (int i = 0; i < this.keywords.size(); ++i) {
            int sp = this.keywords.get(i).getSortPriority();
            if (priority >= sp) continue;
            this.keywords.add(i, newKeyword);
            added = true;
            break;
        }
        if (!added) {
            this.keywords.add(newKeyword);
        }
        this.bonusKeywords.add(newKeyword);
        if (this.getType() == EffType.Or) {
            this.orEnemy.addKeyword(newKeyword);
            this.orFriendly.addKeyword(newKeyword);
        }
    }

    public List<Keyword> getBonusKeywords() {
        return this.bonusKeywords;
    }

    public DeathType getDeathType() {
        return this.visualEffect.deathType;
    }

    public boolean allowBadTargets() {
        if (this.hasKeyword(Keyword.growth)) {
            return true;
        }
        if (this.hasKeyword(Keyword.selfShield)) {
            return true;
        }
        if (this.getType() == EffType.Or) {
            return this.getOr(false).allowBadTargets() || this.getOr(true).allowBadTargets();
        }
        return this.getType().doesAllowBadTargets();
    }

    public boolean isUnusableBecauseNerfed() {
        return this.hasValue && this.getValue() <= 0 && !this.canStillUseWithValueZero();
    }

    public boolean canStillUseWithValueZero() {
        return false;
    }

    public void removeKeyword(Keyword keyword) {
        this.keywords.remove((Object)keyword);
        this.bonusKeywords.remove((Object)keyword);
    }

    public StateEvent getEvent() {
        return this.event;
    }

    public SnapshotEvent getSnapshotEvent() {
        return this.snapshotEvent;
    }

    public void addKeywords(List<Keyword> keywordList) {
        for (Keyword k : keywordList) {
            this.addKeyword(k);
        }
    }

    public void clearKeywords() {
        this.keywords.clear();
    }

    public Actor getBasicImage() {
        return this.getBasicImage(this.getValue() + "");
    }

    public Actor getBasicImage(String inner) {
        Actor a = this.getSimpleBasicImage(inner);
        Color col = this.isFriendly() ? Colours.green : Colours.red;
        switch (this.targetingType) {
            case Group: {
                return new Pixl(2, 2).border(col).actor(a).pix();
            }
            case Top: {
                return new Pixl().image(Images.arrowUp, col).gap(2).actor(a).pix();
            }
            case TopAndBot: {
                return new Pixl(1).actor(a).image(Images.arrowUp, col).image(Images.arrowDown, col).pix();
            }
        }
        return a;
    }

    private Actor getSimpleBasicImage(String text) {
        Color textCol;
        Color borderCol = null;
        switch (this.getTargetingType()) {
            case Self: {
                textCol = this.getType() == EffType.Damage ? Colours.dark : Colours.light;
                break;
            }
            default: {
                textCol = Colours.light;
            }
        }
        String displayText = TextWriter.getTag(textCol) + text;
        switch (this.getType()) {
            case Damage: {
                switch (this.getTargetingType()) {
                    case Self: {
                        textCol = Colours.dark;
                        break;
                    }
                    case Group: {
                        textCol = Colours.yellow;
                    }
                }
                Actor a = Tann.imageWithText(Images.eq_iconDamage, displayText, borderCol);
                if (this.hasKeyword(Keyword.petrify)) {
                    a = new Pixl().image(EntSidesBlobSmall.petrify.val(1).getTexture()).text(displayText).pix();
                }
                return a;
            }
            case Shield: {
                return Tann.imageWithText(Images.eq_iconShield, displayText, borderCol);
            }
            case Heal: {
                return Tann.imageWithText(Images.eq_iconHeal, displayText, borderCol);
            }
            case Mana: {
                return Tann.imageWithText(Images.eq_iconMana, displayText, borderCol);
            }
            case HealAndShield: {
                return Tann.imageWithText(Images.eq_iconHealShield, displayText, borderCol);
            }
            case Kill: {
                return new ImageActor(Images.eq_skullWhite, Colours.light);
            }
            case Summon: {
                if (this.getValue() == 1) {
                    return new Pixl(2).text("+").image((TextureRegion)MonsterTypeLib.byName((String)this.getSummonType()).portrait, true).pix();
                }
                return new Pixl(2).text("+").actor(Tann.actorWithText(new ImageActor((TextureRegion)MonsterTypeLib.byName((String)this.getSummonType()).portrait, true), this.getValue() + "", Colours.dark)).pix();
            }
            case Event: {
                return null;
            }
            case Buff: {
                return this.getBuff().trigger.makePanelActor(true);
            }
        }
        return Trigger.unknown();
    }

    public String getOverrideDescription() {
        return this.overrideDescription;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean allowAutoskip() {
        if (this.type == EffType.Damage && this.targetingType == TargetingType.Self) {
            return true;
        }
        if (this.type == EffType.RedirectIncoming && !this.hasKeyword(Keyword.selfShield)) {
            return true;
        }
        for (Keyword k : this.getKeywordForGameplay()) {
            if (k.getMetaKeyword() != null && KUtils.allowAutoskip(k.getMetaKeyword())) {
                return true;
            }
            if (!KUtils.allowAutoskip(k)) continue;
            return true;
        }
        return false;
    }

    public int hashEff() {
        int result = 13;
        result += this.getValue();
        result += this.getTargetingType().hashCode() * 2;
        result += this.getType().hashCode() * 3;
        for (Keyword k : this.getKeywords()) {
            result += k.hashCode() * 5;
        }
        return result += this.describe().hashCode() * 7;
    }

    public EffType getType() {
        return this.type;
    }

    public TargetingType getTargetingType() {
        return this.targetingType;
    }

    public String getSummonType() {
        return this.summonType;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public Buff getBuff() {
        return this.buff;
    }

    public void setBuff(Buff buff) {
        this.buff = buff;
    }

    public boolean canKill() {
        return this.type == EffType.Damage || this.type == EffType.Kill || this.hasKeyword(Keyword.damage);
    }

    public boolean isSpecialAddKeyword() {
        return this.type == EffType.Buff && this.buff.trigger instanceof AffectSides && ((AffectSides)this.buff.trigger).getEffects().get(0) instanceof AddKeyword;
    }

    public long getCollisionBits(Boolean player) {
        long result = 0L;
        if (player == null) {
            player = true;
        }
        if (!this.isFriendly()) {
            player = player == false;
        }
        for (int i = 0; i < this.keywords.size(); ++i) {
            result |= this.keywords.get(i).getCollisionBits();
        }
        switch (this.getType()) {
            case Buff: {
                return (result |= this.buff.trigger.getCollisionBits(player)) - (result & Collision.GENERIC_ALL_SIDES_HERO);
            }
            case Damage: {
                if (this.targetingType != TargetingType.Self) break;
                return result;
            }
        }
        return result | this.getType().getCollisionBits(player);
    }

    public Eff[] getBonusUntargetedEffects() {
        return this.bonusUntargetedEffects;
    }

    public boolean canBeUsedUntargeted(Snapshot present) {
        switch (this.type) {
            case Resurrect: {
                List<EntState> es = present.getStates(true, true);
                for (int i = 0; i < es.size(); ++i) {
                    if (!es.get(i).canResurrect()) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public boolean isMultiplable() {
        switch (this.type) {
            case HealAndShield: 
            case Shield: 
            case Resurrect: 
            case Mana: 
            case Reroll: 
            case Damage: 
            case Heal: 
            case Summon: {
                return true;
            }
        }
        return false;
    }

    public boolean sameAs(Eff eff) {
        return this.hashEff() == eff.hashEff();
    }
}

