/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff;

import com.badlogic.gdx.math.Interpolation;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.VisualEffectType;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.personal.Undying;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.StateConditionType;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import java.util.Arrays;
import java.util.Random;

public enum EffType {
    Damage(false),
    Shield(true),
    Heal(false),
    HealAndShield(true),
    Mana(true),
    Blank,
    Buff(true),
    Kill,
    Reroll,
    RedirectIncoming,
    Summon,
    Recharge,
    Resurrect,
    Or,
    MultiplyShields,
    SetToHp,
    Event,
    SnapshotEvent,
    JustTarget;

    private boolean allowBadTargets = false;

    private EffType() {
    }

    private EffType(boolean allowBadTargets) {
        this.allowBadTargets = allowBadTargets;
    }

    public boolean doesAllowBadTargets() {
        return this.allowBadTargets;
    }

    public String describe(Eff source) {
        switch (this) {
            case Blank: {
                return "blank";
            }
            case Damage: {
                String part = source.getValue() + " damage";
                if (source.isFriendly()) {
                    switch (source.getTargetingType()) {
                        case Single: {
                            return part + " to " + Words.entName(source, (Boolean)false);
                        }
                        case Group: {
                            return part + " to all " + Words.entName(source, (Boolean)true);
                        }
                        case Self: {
                            return source.getValue() + " self damage";
                        }
                    }
                    return "weird unknown friend damage description: " + (Object)((Object)source.getTargetingType());
                }
                switch (source.getTargetingType()) {
                    case Single: {
                        return part;
                    }
                    case Group: {
                        String middle = "";
                        if (source.hasRestriction(StateConditionType.Damaged)) {
                            middle = middle + "damaged ";
                        }
                        if (source.hasRestriction(StateConditionType.Dying)) {
                            middle = middle + "dying ";
                        }
                        return part + " to all " + middle + Words.entName(source, (Boolean)true);
                    }
                    case ALL: {
                        return part + " to all heroes and monsters";
                    }
                    case Top: {
                        return part + " to the top-most " + Words.entName(source, null);
                    }
                    case Bot: {
                        return part + " to the bottom-most " + Words.entName(source, null);
                    }
                    case Mid: {
                        return part + " to the middle " + Words.entName(source, null);
                    }
                    case TopAndBot: {
                        return part + " to the top and bottom " + Words.entName(source, (Boolean)true);
                    }
                }
                return "ahh help damage targetingType" + (Object)((Object)source.getTargetingType());
            }
            case Shield: {
                String part = "Shield " + source.getValue();
                if (!source.isFriendly()) {
                    switch (source.getTargetingType()) {
                        case Single: {
                            return part + " to " + Words.entName(source, (Boolean)false);
                        }
                        case Group: {
                            return part + " to all " + Words.entName(source, (Boolean)true);
                        }
                    }
                    return "weird unknown friend shield description: " + (Object)((Object)source.getTargetingType());
                }
                switch (source.getTargetingType()) {
                    case Single: {
                        return part;
                    }
                    case Self: {
                        return "Self-" + part.toLowerCase();
                    }
                    case Group: {
                        String middle = "";
                        String end = "";
                        if (source.hasRestriction(StateConditionType.Damaged)) {
                            middle = middle + "damaged ";
                        }
                        if (source.hasRestriction(StateConditionType.FullHP)) {
                            middle = middle + "undamaged ";
                        }
                        if (source.hasRestriction(StateConditionType.Dying)) {
                            middle = middle + "dying ";
                        }
                        if (source.hasRestriction(StateConditionType.HasShields)) {
                            end = " with shields";
                        }
                        return part + " to all " + middle + Words.entName(source, (Boolean)true) + end;
                    }
                    case SpellSource: {
                        return part + " to the source of the spell";
                    }
                }
                return part + " to " + (Object)((Object)source.getTargetingType());
            }
            case Heal: {
                String part = "Heal " + source.getValue();
                switch (source.getTargetingType()) {
                    case Self: {
                        return "Self-" + part.toLowerCase();
                    }
                    case Single: {
                        return part;
                    }
                    case TopAndBot: {
                        return part + " to the top and bottom " + Words.entName(source, (Boolean)true);
                    }
                    case Group: {
                        String middle = "";
                        String end = "";
                        if (source.hasRestriction(StateConditionType.Damaged)) {
                            middle = middle + "damaged ";
                        }
                        if (source.hasRestriction(StateConditionType.Dying)) {
                            middle = middle + "dying ";
                        }
                        if (source.hasRestriction(StateConditionType.HasShields)) {
                            end = " with shields";
                        }
                        return part + " to all " + middle + Words.entName(source, (Boolean)true) + end;
                    }
                    case Top: {
                        return part + " to the top " + Words.entName(true, true, null);
                    }
                    case Untargeted: {
                        return part;
                    }
                }
                return " Need healing description: " + (Object)((Object)source.getTargetingType());
            }
            case HealAndShield: {
                return Heal.describe(source).replaceAll("Heal", "Heal and shield");
            }
            case Buff: {
                String buffString = source.getBuffAndCopy().toNiceString(source);
                switch (source.getTargetingType()) {
                    case Self: {
                        return buffString;
                    }
                }
                return buffString;
            }
            case Kill: {
                String base = "Kill";
                switch (source.getTargetingType()) {
                    case Top: {
                        return base + " the top-most " + Words.entName(source, null);
                    }
                    case Single: {
                        String result = base + " " + Words.entName(source, (Boolean)false);
                        if (source.hasRestriction(StateConditionType.HalfOrLessHP)) {
                            result = result + " with half or less hp";
                        }
                        return result;
                    }
                    case Group: {
                        return base + " all " + Words.entName(source, (Boolean)true);
                    }
                    case Self: {
                        if (source.getVisual() == VisualEffectType.Flee) {
                            return "I flee";
                        }
                        return "I die";
                    }
                }
                return base + " unknown for " + (Object)((Object)source.getTargetingType());
            }
            case Reroll: {
                return "Gain " + source.getValue() + " " + Words.plural("reroll", source.getValue());
            }
            case RedirectIncoming: {
                return "Redirect all damage and enemy effects from " + Words.entName(source, (Boolean)false) + " to me";
            }
            case Recharge: {
                switch (source.getTargetingType()) {
                    case Single: {
                        return "Target hero can use their dice again";
                    }
                }
                throw new RuntimeException("uhoh");
            }
            case Summon: {
                String amt;
                if (source.getValue() == 1) {
                    amt = "a";
                    if (Words.startsWithVowel(source.getSummonType())) {
                        amt = "an";
                    }
                } else {
                    amt = "" + source.getValue();
                }
                return "Summon " + amt + " " + Words.plural(source.getSummonType().toLowerCase(), source.getValue());
            }
            case Resurrect: {
                return "Revive the" + (source.getValue() == 1 ? "" : " " + source.getValue()) + " top-most defeated " + Words.entName(source, source.getValue() == 1 ? null : Boolean.valueOf(true));
            }
            case JustTarget: {
                TargetingType tt = source.getTargetingType();
                String targetString = tt == TargetingType.Group ? "All" : "Target";
                String thingTargeted = Words.entName(source, tt == TargetingType.Group ? Boolean.valueOf(true) : null);
                if (tt == TargetingType.Self) {
                    thingTargeted = "self";
                } else if (tt == TargetingType.ALL) {
                    thingTargeted = "[b]all[b]";
                }
                return targetString + " " + thingTargeted + (source.hasValue() ? " " + source.getValue() : "");
            }
            case Mana: {
                return "+[nbp][nbp]" + Words.manaString(source.getValue());
            }
            case SetToHp: {
                switch (source.getTargetingType()) {
                    case Single: {
                        return "Set a hero to " + source.getValue() + " hp";
                    }
                    case Group: {
                        return "Set all heroes to " + source.getValue() + " hp";
                    }
                }
                return "Set " + source.getValue() + " hp";
            }
            case MultiplyShields: {
                return Words.capitaliseFirst(Words.multiple(source.getValue())) + " all friendly shields";
            }
            case Or: {
                return (source.getOr(false).describe(false) + " or " + source.getOr(true).describe(false).toLowerCase()).replaceAll("\\[n\\]", " ");
            }
        }
        return "no base for " + (Object)((Object)this);
    }

    public float getEffectTier(int tier, float pips, boolean player, Eff eff) {
        switch (this) {
            case JustTarget: {
                return 0.0f;
            }
            case Damage: {
                return pips * (float)(eff != null && eff.isFriendly() ? -1 : 1);
            }
            case Shield: {
                if (!player) {
                    switch (eff.getTargetingType()) {
                        case Self: {
                            return pips * 0.3f;
                        }
                        case Single: {
                            return pips * 1.1f;
                        }
                    }
                    return -500.0f;
                }
                return Tann.effectTierOnlySinTote(pips, 5.0f + (float)(tier - 1) * 2.0f, 0.7f, 2.3f + (float)(tier - 1) * 0.7f, 0.9f);
            }
            case Heal: {
                if (eff != null && eff.hasKeyword(Keyword.vitality)) {
                    return pips * 0.84f;
                }
                if (player) {
                    return Tann.effectTierOnlySinTote(pips, 4.0f + (float)(Math.max(0, tier - 1) * 3), 0.5f, 1.4f + (float)Math.max(0, tier - 1) * 0.85f, 0.9f);
                }
                return pips * 0.9f;
            }
            case HealAndShield: {
                return (Heal.getEffectTier(tier, pips, player, eff) + Shield.getEffectTier(tier, pips, player, eff)) * 0.9f;
            }
            case Mana: {
                return (float)((double)pips * Math.pow(1.18f, (float)tier * 0.81f + 0.19f));
            }
            case Kill: {
                return pips * Interpolation.pow2Out.apply(0.5f, 1.1f, Math.min(1.0f, (pips - 1.0f) / (HeroTypeUtils.getEffectTierFor(tier) * 6.0f)));
            }
            case Blank: {
                return 0.0f;
            }
            case Reroll: {
                return 0.0f;
            }
            case Summon: {
                MonsterType mt = MonsterTypeLib.byName(eff.getSummonType());
                return pips * mt.getSummonValue();
            }
            case Recharge: {
                return HeroTypeUtils.getEffectTierFor(tier) * 1.05f + 0.55f;
            }
            case Resurrect: {
                float pipFactor = Tann.effectTierOnlySinTote(pips, 4.0f, 1.0f, 2.2f, 1.1f);
                return pipFactor * (1.0f + HeroTypeUtils.getEffectTierFor(tier)) * 0.425f;
            }
            case Buff: {
                if (eff == null) break;
                Buff buff = eff.getBuff();
                if (buff.trigger instanceof Undying) {
                    return (float)(0.6 + Math.pow(1.6, tier - 1));
                }
                return buff.getEffectTier((int)pips, tier);
            }
        }
        return Float.NaN;
    }

    public String toString() {
        return this.name();
    }

    public float getCantripMultiplier() {
        switch (this) {
            case Damage: {
                return 0.6f;
            }
            case Shield: {
                return 0.6f;
            }
            case Heal: {
                return 0.3f;
            }
            case Mana: {
                return 1.0f;
            }
            case Buff: {
                return 0.5f;
            }
        }
        return Float.NaN;
    }

    public long getCollisionBits(Boolean player) {
        if (player == null) {
            player = true;
        }
        switch (this) {
            case Blank: {
                return Collision.BLANK_SIDE;
            }
            case Damage: {
                return Collision.PHYSICAL_DAMAGE;
            }
            case Shield: {
                if (player != null && !player.booleanValue()) {
                    return Collision.ENEMY_SHIELD;
                }
                return Collision.SHIELD;
            }
            case Heal: {
                return Collision.HEAL;
            }
            case Mana: {
                return Collision.SPELL;
            }
            case HealAndShield: {
                return Heal.getCollisionBits(player) | Shield.getCollisionBits(player);
            }
        }
        return 0L;
    }

    public static EffType niceRandom(Random r) {
        return Tann.random(Arrays.asList(Damage, Shield, Heal, HealAndShield, Kill), r);
    }
}

