/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.fightLog;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobBig;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobHuge;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobSmall;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.ConditionalBonus;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.statics.bullet.DieShader;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class EntSideState {
    public static int cnt;
    private final EntState entState;
    private final EntSide original;
    private TextureRegion calculatedTexture;
    private Eff calculatedEffect;
    private List<TP<Keyword, Integer>> bonuses = new ArrayList<TP<Keyword, Integer>>();
    List<Keyword> cachedKeywords = null;
    Color bestColBonus;

    public EntSideState(EntState entState, EntSide original) {
        this(entState, original, -1);
    }

    public EntSideState(EntState entState, EntSide original, int calcUpTo) {
        this.original = original;
        this.entState = entState;
        this.calculatedEffect = original.getBaseEffect().copy();
        this.calculatedTexture = original.getTexture();
        this.useTriggers(calcUpTo);
        if (OptionLib.SHOW_GRB.c()) {
            ++cnt;
        }
    }

    public void changeTo(EntSide other) {
        this.changeTo(other.getBaseEffect().copy(), other.getTexture());
    }

    public void changeTo(EntSideState sideState) {
        sideState.removeStaticKeywordBonuses();
        this.changeTo(sideState.getCalculatedEffect().copy(), sideState.getCalculatedTexture());
    }

    public void changeTo(Eff eff, TextureRegion tex) {
        if (tex.getRegionWidth() != this.calculatedTexture.getRegionWidth()) {
            TannLog.error("Size error");
            if (TestRunner.isTesting()) {
                throw new RuntimeException("pejkrfikg");
            }
            this.enbug();
            return;
        }
        this.calculatedEffect = eff.copy();
        this.calculatedTexture = tex;
    }

    private void useTriggers(int upToIndex) {
        try {
            this.usePreTriggers(upToIndex);
            for (Personal t : this.entState.getActiveTriggers()) {
                t.affectSideFinal(this, this.entState);
            }
        }
        catch (Exception e) {
            if (TestRunner.isTesting()) {
                throw e;
            }
            TannLog.error(e, "affecting side");
            this.enbug();
        }
    }

    private void usePreTriggers(int upToIndex) {
        List<Personal> activeTriggers = this.entState.getActiveTriggers();
        for (int triggerIndex = 0; triggerIndex < activeTriggers.size(); ++triggerIndex) {
            Personal t = activeTriggers.get(triggerIndex);
            if (triggerIndex == upToIndex || this.calculatedEffect.hasKeyword(Keyword.stasis)) {
                return;
            }
            int preVal = this.calculatedEffect.getValue();
            t.affectSide(this, this.entState, triggerIndex);
            int valDelta = this.calculatedEffect.getValue() - preVal;
            Keyword k = t.getStronglyAssociatedKeyword();
            if (k == null || valDelta == 0) continue;
            boolean found = false;
            for (int i = 0; i < this.bonuses.size(); ++i) {
                if (this.bonuses.get((int)i).a != k) continue;
                TP<Keyword, Integer> tP = this.bonuses.get(i);
                Integer.valueOf((Integer)tP.b + valDelta);
                tP.b = tP.b;
                found = true;
            }
            if (found) continue;
            this.bonuses.add(new TP<Keyword, Integer>(k, valDelta));
        }
        Eff calc = this.getCalculatedEffect();
        Snapshot s = this.entState.getSnapshot();
        if (s == null) {
            return;
        }
        if (upToIndex == -1) {
            this.recurseMetaKeywords(s);
            this.precalculatedKeywords(s);
        }
    }

    private void precalculatedKeywords(Snapshot s) {
        for (Keyword k : this.getCalculatedEffect().getKeywordForGameplay()) {
            ConditionalBonus cb;
            int bonus;
            switch (k) {
                case doubDiff: 
                case revDiff: {
                    int delta;
                    boolean doub;
                    boolean bl = doub = Keyword.doubDiff == k;
                    if (!this.original.getBaseEffect().hasValue() || !this.calculatedEffect.hasValue() || (delta = this.calculatedEffect.getValue() - this.original.getBaseEffect().getValue()) == 0) break;
                    this.addBonus(delta * (doub ? 1 : -2), k);
                    break;
                }
                case lucky: {
                    Random r;
                    float roll;
                    int bonus2;
                    if (s.turn == 0 || (bonus2 = (int)(-(roll = (r = Tann.makeStdRandom(s.getShifterSeed(this.getIndex(), this.entState))).nextFloat()) * (float)(this.getCalculatedEffect().getValue() + 1))) == 0) break;
                    this.addBonus(bonus2, k);
                    break;
                }
                case critical: {
                    if (s.turn == 0) break;
                    Random r = Tann.makeStdRandom(s.getShifterSeed(this.getIndex(), this.entState));
                    int n = bonus = r.nextBoolean() ? 0 : 1;
                    if (bonus == 0) break;
                    this.addBonus(bonus, k);
                    break;
                }
            }
            if ((cb = k.getConditionalBonus()) == null || !cb.requirement.preCalculate() || (bonus = cb.affectValue(this.getCalculatedEffect(), this.entState, null, this.calculatedEffect.getValue())) == 0) continue;
            this.addBonus(bonus, k);
        }
    }

    private void recurseMetaKeywords(Snapshot s) {
        if (!KUtils.hasMetaKeyword(this.getCalculatedEffect())) {
            return;
        }
        ArrayList<Keyword> alreadyProcessed = new ArrayList<Keyword>();
        for (int i = 0; i < 5; ++i) {
            ArrayList<Keyword> cpy2 = new ArrayList<Keyword>(this.getCalculatedEffect().getKeywords());
            cpy2.removeAll(alreadyProcessed);
            if (cpy2.isEmpty()) break;
            alreadyProcessed.addAll(this.getCalculatedEffect().getKeywords());
            this.processMetaKeywords(cpy2, s);
        }
    }

    private void processMetaKeywords(List<Keyword> kws, Snapshot s) {
        block13: for (int ki = 0; ki < kws.size(); ++ki) {
            Keyword k = kws.get(ki);
            switch (k) {
                case copycat: 
                case echo: 
                case resonate: {
                    EntSideState recentState = s.getMostRecentlyUsedDieCommandEffect();
                    if (recentState == null) continue block13;
                    Eff recent = recentState.getCalculatedEffect();
                    switch (k) {
                        case copycat: {
                            this.getCalculatedEffect().addKeywords(recent.getKeywords());
                            continue block13;
                        }
                        case echo: {
                            this.getCalculatedEffect().setValue(recent.hasValue() ? recent.getValue() : 0);
                            continue block13;
                        }
                        case resonate: {
                            int value = this.getCalculatedEffect().getValue();
                            ReplaceWith.replaceSide(this, recentState);
                            this.getCalculatedEffect().setValue(value);
                            this.getCalculatedEffect().addKeyword(Keyword.resonate);
                            continue block13;
                        }
                    }
                    TannLog.error("errorkw: " + (Object)((Object)k));
                    continue block13;
                }
                case dejavu: {
                    List<EntSideState> sss = s.getSideStatesFromTurnsAgoAndEnt(1, this.entState.getEnt());
                    for (int i = 0; i < sss.size(); ++i) {
                        this.getCalculatedEffect().addKeywords(sss.get(i).getCalculatedEffect().getKeywords());
                    }
                    continue block13;
                }
                case spy: {
                    EntSideState firstAttack = s.getFirstEnemyAttackState();
                    if (firstAttack == null) continue block13;
                    this.getCalculatedEffect().addKeywords(firstAttack.getCalculatedEffect().getKeywords());
                    continue block13;
                }
                case shifter: {
                    if (s.turn == 0) continue block13;
                    Random r = Tann.makeStdRandom(s.getShifterSeed(this.getIndex(), this.entState));
                    int attempts = 20;
                    for (int i = 0; i < attempts; ++i) {
                        Keyword possible = Tann.random(Keyword.values(), r);
                        if (possible.spellOnly()) continue;
                        int size = this.getCalculatedEffect().getKeywords().size();
                        this.getCalculatedEffect().addKeyword(possible);
                        if (size != this.getCalculatedEffect().getKeywords().size()) continue block13;
                    }
                    continue block13;
                }
                case fumble: {
                    if (s.turn == 0 || !Tann.makeStdRandom(s.getShifterSeed(this.getIndex(), this.entState)).nextBoolean()) continue block13;
                    ReplaceWith.replaceSide(this, ESB.blankFumble);
                    continue block13;
                }
                case fluctuate: {
                    if (s.turn == 0) continue block13;
                    Random r = Tann.makeStdRandom(s.getShifterSeed(this.getIndex(), this.entState));
                    EntSide fs = null;
                    int attempts = 50;
                    boolean bhv = this.getCalculatedEffect().hasValue();
                    for (int i = 0; i < attempts && ((fs = EntSidesLib.random(r, this.entState.getEnt().getSize())).getTexture() == this.getCalculatedTexture() || fs.getBaseEffect().hasValue() != bhv); ++i) {
                    }
                    if (fs.getBaseEffect().hasValue() != bhv) continue block13;
                    int value = this.getCalculatedEffect().getValue();
                    List<Keyword> kws2 = this.getCalculatedEffect().getKeywords();
                    ReplaceWith.replaceSide(this, fs);
                    this.getCalculatedEffect().setValue(value);
                    this.getCalculatedEffect().addKeywords(kws2);
                    continue block13;
                }
            }
        }
    }

    private void addBonus(int bonus, Keyword keyword) {
        this.bonuses.add(new TP<Keyword, Integer>(keyword, bonus));
        Eff e = this.getCalculatedEffect();
        if (e.hasValue()) {
            e.setValue(e.getValue() + bonus);
        }
    }

    public EntSide getOriginal() {
        return this.original;
    }

    public TextureRegion getCalculatedTexture() {
        return this.calculatedTexture;
    }

    public Eff getCalculatedEffect() {
        return this.calculatedEffect;
    }

    public int getIndex() {
        if (this.entState == null) {
            return -1;
        }
        return this.entState.getSideIndex(this.getOriginal());
    }

    public List<Keyword> getBonusKeywords() {
        if (this.cachedKeywords == null) {
            this.cachedKeywords = new ArrayList<Keyword>();
            for (Keyword k : this.getCalculatedEffect().getBonusKeywords()) {
                if (this.cachedKeywords.contains((Object)k)) continue;
                this.cachedKeywords.add(k);
            }
        }
        return this.cachedKeywords;
    }

    public int getBonusColIndex() {
        if (this.bestColBonus == null) {
            this.bestColBonus = Colours.pink;
            int bestBonus = 0;
            for (int i = 0; i < this.bonuses.size(); ++i) {
                TP<Keyword, Integer> b = this.bonuses.get(i);
                if ((Integer)b.b <= bestBonus) continue;
                bestBonus = (Integer)b.b;
                this.bestColBonus = ((Keyword)((Object)b.a)).getColour();
            }
        }
        return DieShader.colIndex(this.bestColBonus);
    }

    public int getTotalBonus() {
        int bonus = 0;
        for (int i = 0; i < this.bonuses.size(); ++i) {
            bonus += ((Integer)this.bonuses.get((int)i).b).intValue();
        }
        return bonus;
    }

    public String getBonusString() {
        if (this.bonuses.size() == 0) {
            return "";
        }
        String result = "";
        for (TP<Keyword, Integer> bon : this.bonuses) {
            String tag = TextWriter.getTag(((Keyword)((Object)bon.a)).getColour());
            if (!result.isEmpty()) {
                result = result + "[h]";
            }
            result = result + tag + Tann.delta((Integer)bon.b) + "[cu]";
        }
        return "(" + result + ")";
    }

    public int getBonusFromGrowth() {
        for (TP<Keyword, Integer> bon : this.bonuses) {
            if (bon.a != Keyword.growth) continue;
            return (Integer)bon.b;
        }
        return 0;
    }

    public String describe() {
        String result = this.getCalculatedEffect().describe(false);
        String bonusString = this.getBonusString();
        if (!bonusString.isEmpty()) {
            result = result + " " + bonusString;
        }
        return Eff.addKeywordsToString(result, this.getCalculatedEffect());
    }

    private void removeStaticKeywordBonuses() {
        Eff e = this.getCalculatedEffect();
        if (!this.getCalculatedEffect().hasValue()) {
            return;
        }
        for (TP<Keyword, Integer> i : this.bonuses) {
            ConditionalBonus cb = ((Keyword)((Object)i.a)).getConditionalBonus();
            if (cb == null || !cb.requirement.preCalculate()) continue;
            e.setValue(e.getValue() - (Integer)i.b);
        }
    }

    public void enbug() {
        switch (this.entState.getEnt().getSize()) {
            case small: {
                this.changeTo(EntSidesBlobSmall.blankBug);
                break;
            }
            case reg: {
                this.changeTo(ESB.blankBug);
                break;
            }
            case big: {
                this.changeTo(EntSidesBlobBig.blankBug);
                break;
            }
            case huge: {
                this.changeTo(EntSidesBlobHuge.blankBug);
            }
        }
    }
}

