/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.fightLog;

import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.command.Command;
import com.tann.dice.gameplay.fightLog.command.DieCommand;
import com.tann.dice.gameplay.fightLog.command.EndTurnCommand;
import com.tann.dice.gameplay.fightLog.command.StartTurnCommand;
import com.tann.dice.gameplay.fightLog.listener.SnapshotChangeListener;
import com.tann.dice.gameplay.fightLog.listener.VictoryLossListener;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.endPhase.runEnd.RunEndPhase;
import com.tann.dice.gameplay.progress.StatSnapshot;
import com.tann.dice.gameplay.progress.stats.StatUpdate;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.RollManager;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FightLog {
    private Set<Temporality> updatedTemporalities = new HashSet<Temporality>();
    private Map<Command, Snapshot> snapshotMap = new HashMap<Command, Snapshot>();
    private Snapshot baseSnapshot = new Snapshot(this);
    private List<Command> pastCommands = new ArrayList<Command>();
    private List<Command> futureCommands = new ArrayList<Command>();
    boolean awaitingTurnOver;
    final DungeonContext dungeonContext;
    List<StatUpdate> statUpdates = new ArrayList<StatUpdate>();
    Command visualCommand;
    Map<Temporality, List<SnapshotChangeListener>> snapshotListeners = new HashMap<Temporality, List<SnapshotChangeListener>>();
    List<VictoryLossListener> victoryLossListeners = new ArrayList<VictoryLossListener>();
    boolean endNotified;
    private List<Command> commandHistory = new ArrayList<Command>();
    private boolean failed;
    private static final int MAX_COMMANDS = 1000;

    public FightLog(DungeonContext dungeonContext) {
        this.dungeonContext = dungeonContext;
    }

    public FightLog(List<Hero> startingHeroes, List<Monster> startingMonsters, List<String> commandData, String sideState, DungeonContext context) {
        this(context);
        this.setup(startingHeroes, startingMonsters);
        ArrayList<String> playerCommands = new ArrayList<String>();
        ArrayList<String> enemyCommands = new ArrayList<String>();
        block6: for (int i = 0; i < commandData.size(); ++i) {
            String commandString = commandData.get(i);
            Command.CommandType type = Command.getType(commandString);
            switch (type) {
                case Start: {
                    continue block6;
                }
                case Hero: {
                    playerCommands.add(commandString);
                    continue block6;
                }
                case Monster: {
                    enemyCommands.add(commandString);
                    continue block6;
                }
                case End: {
                    EndTurnCommand etc = new EndTurnCommand(commandString);
                    if (etc.player) continue block6;
                    this.enemyTurn();
                    this.resetTurn(true);
                    this.addSavedCommands(enemyCommands, false);
                    this.addSavedCommands(playerCommands, true);
                    playerCommands.clear();
                    enemyCommands.clear();
                    continue block6;
                }
            }
        }
        for (Command c : this.pastCommands) {
            c.forceImpacted();
        }
        List<Ent> entities = this.getSnapshot(Temporality.Present).getEntities(null, null);
        if (FightLog.isSpecialSave(sideState)) {
            sideState = sideState.substring(1);
        }
        if (entities.size() == sideState.length()) {
            for (int i = 0; i < entities.size(); ++i) {
                EntDie d = entities.get(i).getDie();
                d.setSide(sideState.charAt(i) - 48);
            }
        } else {
            System.out.println("failed to deserialise sides");
        }
        this.updateAllTemporalities();
    }

    public boolean triggerAllHeroOnLandDueToSave() {
        boolean activated = false;
        ArrayList<EntState> presentStates = new ArrayList<EntState>(this.getSnapshot(Temporality.Present).getStates(true, false));
        Collections.shuffle(presentStates);
        for (EntState e : presentStates) {
            EntDie d = e.getEnt().getDie();
            if (d.getState() == Die.DieState.Locked) continue;
            activated |= ((Hero)e.getEnt()).stoppedGameplayImplications();
        }
        return activated;
    }

    public boolean triggerAllMonsterOnLandDueToSave() {
        for (EntState e : this.getSnapshot(Temporality.Present).getStates(false, false)) {
            ((Monster)e.getEnt()).onLockGameplayImplications();
        }
        return true;
    }

    public void setup(List<Hero> heroes, List<Monster> monsters) {
        DungeonScreen ds = DungeonScreen.get();
        if (ds != null) {
            DungeonScreen.get().resetFromSetup();
        }
        this.commandHistory.clear();
        this.futureCommands.clear();
        this.pastCommands.clear();
        this.snapshotMap.clear();
        this.baseSnapshot = new Snapshot(this);
        for (Global gt : this.baseSnapshot.getGlobals()) {
            gt.affectStartMonsters(monsters);
        }
        for (Hero h : heroes) {
            h.setRealFightLog(this);
        }
        for (Monster m : monsters) {
            m.setRealFightLog(this);
        }
        this.setHeroes(heroes);
        this.setEnemies(monsters);
        this.baseSnapshot.setupCombat();
        this.recalculateToFuture();
        this.updateAllTemporalities();
    }

    public void resetForNewFight() {
        this.endNotified = false;
        this.updatedTemporalities.clear();
        this.snapshotMap.clear();
        this.baseSnapshot = new Snapshot(this);
        this.commandHistory.clear();
        this.pastCommands.clear();
        this.futureCommands.clear();
        this.recalculateToFuture();
    }

    public void setEnemies(List<Monster> monsters) {
        this.baseSnapshot.addEntities(monsters);
    }

    public void setHeroes(List<Hero> heroes) {
        this.baseSnapshot.addEntities(heroes);
    }

    public void resetTurn(boolean skipUpdate) {
        if (!skipUpdate && !this.dungeonContext.skipStats()) {
            StatSnapshot ss = this.makeSnapshot();
            for (StatUpdate su : this.statUpdates) {
                su.updateEndOfRound(ss);
            }
        }
        this.awaitingTurnOver = false;
        this.baseSnapshot = this.getSnapshot(Temporality.Future).copy();
        this.commandHistory.addAll(this.pastCommands);
        this.pastCommands.clear();
        this.futureCommands.clear();
        this.addCommand(new StartTurnCommand(), false);
        this.addCommand(new EndTurnCommand(true), true);
        this.addCommand(new EndTurnCommand(false), true);
        this.recalculateToFuture();
        this.updateAllTemporalities();
        if (!skipUpdate && !this.checkEnd()) {
            BulletStuff.refreshEntities(this.getSnapshot(Temporality.Present).getAliveEntities());
            PhaseManager.get().popPhase();
        }
    }

    private void manageOnSaveEffects(Snapshot prePresent, Command command, List<Hero> previouslyAlive) {
        List<Hero> nowFutureAlive = this.getSnapshot(Temporality.Future).getAliveHeroEntities();
        boolean didSomething = false;
        if (!nowFutureAlive.equals(previouslyAlive)) {
            EntState saverState = null;
            if (command.getSource() != null) {
                saverState = this.getState(Temporality.Present, command.getSource());
            }
            for (int i = 0; i < nowFutureAlive.size(); ++i) {
                Hero saved = nowFutureAlive.get(i);
                if (previouslyAlive.contains(saved)) continue;
                if (saverState != null) {
                    didSomething |= saverState.onRescue(saved, command);
                }
                didSomething |= command.onRescue(saved, command.getSource(), this.getSnapshot(Temporality.Present), prePresent);
            }
        }
        if (didSomething) {
            this.getSnapshot(Temporality.Present).checkHpLimits(command.getSource(), command);
            this.recalculateToFuture();
            this.manageOnSaveEffects(prePresent, command, nowFutureAlive);
        }
    }

    private void manageOnKillEffects(Snapshot prePresent, Command command, List<Ent> previouslyAlive) {
        List<Ent> nowAlive = this.getSnapshot(Temporality.Present).getAliveEntities();
        boolean didSomething = false;
        if (!nowAlive.equals(previouslyAlive)) {
            EntState killerState = null;
            if (command.getSource() != null) {
                killerState = this.getState(Temporality.Present, command.getSource());
            }
            int kills = 0;
            for (int i = 0; i < previouslyAlive.size(); ++i) {
                EntState demise;
                Ent maybeKilled = previouslyAlive.get(i);
                if (nowAlive.contains(maybeKilled) || (demise = this.getState(Temporality.Present, maybeKilled)) != null && demise.isFled()) continue;
                ++kills;
                if (killerState == null) continue;
                didSomething |= killerState.onKill(command, maybeKilled);
            }
            if (kills > 0) {
                didSomething |= command.onKill(command.getSource(), prePresent, this.getSnapshot(Temporality.Present));
            }
            if (killerState != null) {
                killerState.onTotalKills(kills);
            }
        }
        if (didSomething) {
            this.getSnapshot(Temporality.Present).checkHpLimits(command.getSource(), command);
            this.recalculateToFuture();
            this.manageOnKillEffects(prePresent, command, nowAlive);
        }
    }

    public void recalculateToFuture() {
        Snapshot current = this.getSnapshot(Temporality.Present);
        for (int i = 0; i < this.futureCommands.size(); ++i) {
            Command c = this.futureCommands.get(i);
            EntState sourceState = current.getState(c.getSource());
            if (sourceState != null && sourceState.skipTurn()) {
                this.snapshotMap.put(c, current);
                continue;
            }
            current = current.copy();
            c.enact(current);
            this.snapshotMap.put(c, current);
        }
        this.updatedTemporalities.add(Temporality.Future);
    }

    public void tick() {
        int i;
        if (this.endNotified) {
            return;
        }
        Command mostRecentlyImpacted = null;
        int pastCommandsSize = this.pastCommands.size();
        for (i = 0; i < pastCommandsSize; ++i) {
            Command c = this.pastCommands.get(i);
            if (c.skipped()) {
                mostRecentlyImpacted = c;
                continue;
            }
            c.checkImpacted();
            if (!c.getImpacted()) break;
            mostRecentlyImpacted = c;
        }
        if (mostRecentlyImpacted != this.visualCommand) {
            this.visualCommand = mostRecentlyImpacted;
            this.updatedTemporalities.add(Temporality.Visual);
        }
        this.manageSnapshotNotify();
        for (i = 0; i < this.pastCommands.size(); ++i) {
            boolean playerSource;
            Command c = this.pastCommands.get(i);
            if (c.getFinishedAnimating()) continue;
            boolean bl = playerSource = c.getSource() == null || c.getSource().isPlayer();
            if (!c.getStartedAnimating()) {
                c.startAnimation(this.getSnapshotBefore(c));
            }
            if (playerSource && !(c instanceof EndTurnCommand)) continue;
            return;
        }
        this.checkEnd();
        if (this.awaitingTurnOver) {
            this.resetTurn(false);
        }
    }

    public void instantCatchup() {
        for (Command pastCommand : this.pastCommands) {
            pastCommand.overrideSkip();
        }
    }

    private void updateStats(Snapshot previousFuture) {
        if (this.pastCommands.size() <= 1) {
            return;
        }
        StatSnapshot ss = this.makeSnapshot(previousFuture);
        List<Global> afterGlobals = ss.afterCommand.getGlobals();
        for (int i = 0; i < afterGlobals.size(); ++i) {
            Global g = afterGlobals.get(i);
            g.statSnapshotCheck(ss);
        }
        if (this.dungeonContext.skipStats()) {
            return;
        }
        Map<String, Stat> statMap = this.getContext().getStatsManager().getStatsMap();
        if (ss != null) {
            for (StatUpdate su : this.getStatUpdates()) {
                su.updateAfterCommand(ss, statMap);
            }
        }
    }

    public StatSnapshot makeSnapshot() {
        return this.makeSnapshot(this.getSnapshot(Temporality.Future));
    }

    private StatSnapshot makeSnapshot(Snapshot previousFuture) {
        Command origin = null;
        if (this.pastCommands.size() <= 0) {
            return new StatSnapshot(null, this.pastCommands, this.futureCommands, this.getSnapshot(Temporality.StartOfTurn), null, this.getSnapshot(Temporality.Future), this.getSnapshot(Temporality.Future), previousFuture, this.dungeonContext);
        }
        origin = this.pastCommands.get(this.pastCommands.size() - 1);
        return new StatSnapshot(origin, this.pastCommands, this.futureCommands, this.getSnapshot(Temporality.StartOfTurn), this.getSnapshotBefore(origin), this.getSnapshotAfter(origin), this.getSnapshot(Temporality.Future), previousFuture, this.dungeonContext);
    }

    public List<StatUpdate> getStatUpdates() {
        return this.statUpdates;
    }

    public void registerStatUpdate(StatUpdate su) {
        this.statUpdates.add(su);
    }

    public Snapshot getSnapshot() {
        return this.getSnapshot(Temporality.Present);
    }

    public Snapshot getSnapshot(Temporality temporality) {
        return this.getSnapshotInternal(temporality);
    }

    private Snapshot getSnapshotInternal(Temporality temporality) {
        switch (temporality) {
            case Base: {
                return this.baseSnapshot;
            }
            case StartOfTurn: {
                Command lastStart = this.visualCommand;
                for (Command c : this.pastCommands) {
                    if (!(c instanceof StartTurnCommand)) continue;
                    lastStart = c;
                }
                return this.snapshotMap.get(lastStart);
            }
            case Visual: {
                Snapshot visual;
                if (this.visualCommand != null && (visual = this.snapshotMap.get(this.visualCommand)) != null) {
                    return visual;
                }
                return this.baseSnapshot;
            }
            case Present: {
                Snapshot presentSnapshot;
                if (this.pastCommands.size() != 0 && (presentSnapshot = this.snapshotMap.get(this.pastCommands.get(this.pastCommands.size() - 1))) != null) {
                    return presentSnapshot;
                }
                return this.baseSnapshot;
            }
            case Future: {
                if (this.futureCommands.size() == 0) {
                    return this.getSnapshotInternal(Temporality.Present);
                }
                Snapshot futureSnapshot = this.snapshotMap.get(this.futureCommands.get(this.futureCommands.size() - 1));
                if (futureSnapshot == null) {
                    return this.getSnapshotInternal(Temporality.Present);
                }
                return futureSnapshot;
            }
        }
        throw new RuntimeException("Attempting to get a snapshot with temporality " + (Object)((Object)temporality));
    }

    public EntState get(Ent ent, Temporality temporality) {
        return this.getSnapshot(temporality).getState(ent);
    }

    public void addCommand(Command command, boolean future) {
        if (this.tooManyCommands()) {
            this.cmdsErr();
            return;
        }
        Snapshot present = this.getSnapshot(Temporality.Present);
        if (present.isEnd()) {
            return;
        }
        Snapshot futureCopy = this.getSnapshot(Temporality.Future).copy();
        command.preEnact(present);
        command.lockSave(present);
        List<Hero> previouslyAliveHeroes = this.getSnapshot(Temporality.Future).getAliveHeroEntities();
        List<Ent> previouslyAliveEntities = this.getSnapshot(Temporality.Present).getAliveEntities();
        this.updatedTemporalities.add(Temporality.Future);
        if (future) {
            if (command instanceof EndTurnCommand) {
                this.futureCommands.add(command);
            } else {
                this.futureCommands.add(this.futureCommands.size() - 1, command);
                this.sortFutureActions();
            }
        } else {
            Snapshot newCurrent = this.getSnapshot(Temporality.Present).copy();
            command.enact(newCurrent);
            this.pastCommands.add(command);
            this.snapshotMap.put(command, newCurrent);
            this.updatedTemporalities.add(Temporality.Present);
        }
        this.getSnapshot(Temporality.Present).somethingChangedAllEntities();
        this.recalculateToFuture();
        this.manageOnSaveEffects(present, command, previouslyAliveHeroes);
        this.manageOnKillEffects(present, command, previouslyAliveEntities);
        if (!future) {
            this.updateStats(futureCopy);
        }
        this.updateAllTemporalities();
        this.markNotUndo();
    }

    public void somethingChangedAllSnapshots() {
        this.getSnapshot(Temporality.Base).somethingChangedAllEntities();
        this.getSnapshot(Temporality.Visual).somethingChangedAllEntities();
        this.getSnapshot(Temporality.Present).somethingChangedAllEntities();
        this.getSnapshot(Temporality.Future).somethingChangedAllEntities();
    }

    private void markNotUndo() {
        DungeonScreen ds = DungeonScreen.get();
        if (ds != null) {
            ds.nonUndo();
        }
    }

    public void addCommand(Targetable targetable, Ent target, boolean future) {
        if (target != null && !target.isPlayer() && targetable.getDerivedEffects(this.getSnapshot(Temporality.Present)).getType() == EffType.Damage) {
            Main.getSettings().setHasSworded(true);
        }
        Command c = Command.create(targetable, target);
        this.addCommand(c, future);
    }

    private void sortFutureActions() {
        Collections.sort(this.futureCommands, new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                Ent ent1 = o1.getSource();
                Ent ent2 = o2.getSource();
                if (ent1 != null && ent2 != null) {
                    List<Ent> entities = FightLog.this.getSnapshot(Temporality.Present).getAliveEntities();
                    return entities.indexOf(ent1) - entities.indexOf(ent2);
                }
                return 0;
            }
        });
    }

    public void enemyTurn() {
        this.awaitingTurnOver = true;
        this.pastCommands.addAll(this.futureCommands);
        this.futureCommands.clear();
        this.updatedTemporalities.add(Temporality.Present);
    }

    public boolean undo(boolean force) {
        if (!force && !this.canUndo()) {
            System.err.println("Can't undo, no past actions remaining");
            return false;
        }
        if (this.pastCommands.isEmpty()) {
            return false;
        }
        Sounds.playSound(Sounds.undo);
        Command topCommand = this.pastCommands.get(this.pastCommands.size() - 1);
        this.pastCommands.remove(topCommand);
        topCommand.undo();
        this.recalculateToFuture();
        this.somethingChangedAllSnapshots();
        this.updateAllTemporalities();
        return true;
    }

    private Command getTopCommandToUndo() {
        if (this.pastCommands.size() == 0) {
            return null;
        }
        return this.pastCommands.get(this.pastCommands.size() - 1);
    }

    public List<? extends Ent> getActiveEntities(boolean player) {
        return this.getSnapshot(Temporality.Present).getAliveEntities(player);
    }

    public List<? extends Ent> getActiveEntities() {
        return this.getSnapshot(Temporality.Present).getAliveEntities();
    }

    List<Command> getAllCommands() {
        ArrayList<Command> result = new ArrayList<Command>();
        result.addAll(this.pastCommands);
        result.addAll(this.futureCommands);
        return result;
    }

    public boolean checkEnd() {
        if (PhaseManager.get().getPhase() instanceof RunEndPhase) {
            return false;
        }
        if (this.endNotified) {
            return true;
        }
        int pastCommandsSize = this.pastCommands.size();
        for (int i = 0; i < pastCommandsSize; ++i) {
            Command c = this.pastCommands.get(i);
            if (c.getFinishedAnimating()) continue;
            return false;
        }
        if (this.getSnapshot(Temporality.Visual).isVictory()) {
            this.onVictory();
            return true;
        }
        if (this.getSnapshot(Temporality.Visual).isLoss()) {
            this.onDefeat();
            return true;
        }
        return false;
    }

    private void onVictory() {
        this.notifyEndOfFight(true);
        this.getSnapshot(Temporality.Present).endLevel();
        if (!this.dungeonContext.isAtLastLevel()) {
            this.futureCommands.clear();
            this.pastCommands.clear();
            this.commandHistory.clear();
            List<Hero> heroes = this.getContext().getParty().getHeroes();
            this.baseSnapshot = new Snapshot(this);
            this.baseSnapshot.addEntities(heroes);
            this.baseSnapshot.setupCombat();
            this.snapshotMap.clear();
            this.recalculateToFuture();
            this.updateAllTemporalities();
        }
        this.notifyVictory();
    }

    private void onDefeat() {
        this.notifyEndOfFight(false);
        this.notifyLoss();
    }

    private void notifyEndOfFight(boolean victory) {
        this.awaitingTurnOver = false;
        if (!this.dungeonContext.getContextConfig().skipStats()) {
            StatSnapshot ss = this.makeSnapshot();
            for (StatUpdate su : this.statUpdates) {
                su.endOfFight(ss, victory);
            }
        }
    }

    public boolean canUndo() {
        Command c = this.getTopCommandToUndo();
        return c != null && c.canUndo();
    }

    public EntState getState(Temporality temporality, Ent ent) {
        return this.getSnapshot(temporality).getState(ent);
    }

    public boolean anyHidingVisual() {
        return this.getSnapshot(Temporality.Visual).anyHidingEnemies();
    }

    public void registerSnapshotListener(SnapshotChangeListener snapshotChangeListener, Temporality ... requestedTemporailities) {
        for (Temporality t : requestedTemporailities) {
            List<SnapshotChangeListener> a = this.snapshotListeners.get((Object)t);
            if (a == null) {
                a = new ArrayList<SnapshotChangeListener>();
                this.snapshotListeners.put(t, a);
            }
            if (a.contains(snapshotChangeListener)) continue;
            a.add(snapshotChangeListener);
        }
    }

    private void manageSnapshotNotify() {
        if (TestRunner.isTesting()) {
            return;
        }
        for (Temporality t : this.updatedTemporalities) {
            Snapshot s = this.getSnapshot(t);
            if (s == null) continue;
            for (Ent de : s.getEntities(null, null)) {
                EntState es = s.getState(de);
                de.setState(t, es);
            }
            if (this.snapshotListeners.get((Object)t) == null) continue;
            for (SnapshotChangeListener scl : this.snapshotListeners.get((Object)t)) {
                scl.snapshotChanged(t, this.getSnapshot(t));
            }
        }
        this.updatedTemporalities.clear();
    }

    public void registerVictoryLossListener(VictoryLossListener vll) {
        this.victoryLossListeners.add(vll);
    }

    private void notifyVictory() {
        this.endNotified = true;
        for (VictoryLossListener vll : this.victoryLossListeners) {
            vll.victory();
        }
    }

    private void notifyLoss() {
        this.endNotified = true;
        for (VictoryLossListener vll : this.victoryLossListeners) {
            vll.loss();
        }
    }

    public Snapshot getSnapshotAfter(Command command) {
        return this.snapshotMap.get(command);
    }

    public Snapshot getSnapshotBefore(Command command) {
        Command prev = this.getCommandBefore(command);
        if (prev == null) {
            return this.getSnapshot(Temporality.Base);
        }
        return this.snapshotMap.get(prev);
    }

    private Command getCommandBefore(Command command) {
        if (command == null) {
            throw new RuntimeException("uhoh null command");
        }
        int pastIndex = this.pastCommands.indexOf(command);
        if (pastIndex == 0) {
            if (this.commandHistory.size() > 0) {
                return this.commandHistory.get(this.commandHistory.size() - 1);
            }
            return null;
        }
        if (pastIndex > 0) {
            return this.pastCommands.get(pastIndex - 1);
        }
        int futureIndex = this.futureCommands.indexOf(command);
        if (futureIndex == 0) {
            return this.pastCommands.get(this.pastCommands.size() - 1);
        }
        if (futureIndex > 0) {
            return this.futureCommands.get(futureIndex - 1);
        }
        int historyIndex = this.commandHistory.indexOf(command);
        if (historyIndex > 0) {
            return this.commandHistory.get(historyIndex - 1);
        }
        if (historyIndex == 0) {
            return null;
        }
        return null;
    }

    private void addSavedCommands(List<String> commandStrings, boolean player) {
        for (String s : commandStrings) {
            Snapshot present = this.getSnapshot(Temporality.Present);
            this.addCommand(Command.load(s, present), !player);
        }
    }

    public static boolean isSpecialSave(String sideState) {
        return FightLog.isSpecialSave(sideState, true) || FightLog.isSpecialSave(sideState, false);
    }

    public static boolean isSpecialSave(String sideState, boolean hero) {
        return sideState != null && sideState.startsWith(hero ? "h" : "m");
    }

    private static String getSpecialSaveSidesStart() {
        if (RollManager.predictionSavePlayer == null) {
            return "";
        }
        return RollManager.predictionSavePlayer != false ? "h" : "m";
    }

    public String serialiseSides() {
        String result = FightLog.getSpecialSaveSidesStart();
        List<Ent> entities = this.getSnapshot(Temporality.Present).getEntities(null, null);
        for (Ent de : entities) {
            int sideIndex = de.getDie().getSideIndex();
            if (sideIndex == -1) {
                sideIndex = !de.isPlayer() ? 0 : Tann.randomInt(6);
            }
            result = result + sideIndex;
        }
        return result;
    }

    public List<String> serialiseCommands() {
        ArrayList<String> result = new ArrayList<String>();
        List<Command> commands = this.getAllCommandsIncludingHistory();
        int loopEnd = commands.size();
        for (int i = 0; i < loopEnd; ++i) {
            Command c = commands.get(i);
            if (c.getLockedSave() == null) {
                TannLog.log("Error, null command save");
            }
            if (c.getLockedSave().equals(Command.SKIP)) continue;
            result.add(c.getLockedSave());
        }
        return result;
    }

    private List<Command> getAllCommandsIncludingHistory() {
        ArrayList<Command> all = new ArrayList<Command>();
        all.addAll(this.commandHistory);
        all.addAll(this.pastCommands);
        all.addAll(this.futureCommands);
        return all;
    }

    public DungeonContext getContext() {
        return this.dungeonContext;
    }

    public void refreshPresentBaseStats() {
        this.getSnapshot(Temporality.Base).updateAllBaseStats();
        this.getSnapshot(Temporality.Present).updateAllBaseStats();
        this.recalculateToFuture();
    }

    public void updateOutOfCombat() {
        this.baseSnapshot = this.baseSnapshot.copy();
        this.baseSnapshot.updateAllBaseStats();
        if (this.pastCommands.size() > 0) {
            TannLog.log("Updating out of combat with past commands uhoh", TannLog.Severity.error);
        }
        if (this.getSnapshot(Temporality.Present) != this.baseSnapshot || this.getSnapshot(Temporality.Future) != this.baseSnapshot || this.getSnapshot(Temporality.Visual) != this.baseSnapshot) {
            TannLog.log("Updating out of combat with snapshots working uhoh uhoh", TannLog.Severity.error);
        }
        this.updateAllTemporalities();
    }

    public void updateAllTemporalities() {
        this.updatedTemporalities.addAll(Arrays.asList(Temporality.values()));
        this.manageSnapshotNotify();
    }

    public void maybeStart() {
        if (this.pastCommands.size() == 0) {
            this.resetTurn(true);
        }
    }

    public Command getCommandFromSnapshot(Snapshot newSnapshot) {
        for (Command c : this.snapshotMap.keySet()) {
            if (this.snapshotMap.get(c) != newSnapshot) continue;
            return c;
        }
        return null;
    }

    public DieCommand getDieCommandFromAtOrBeforeSnapshot(Snapshot s) {
        int index = this.getIndexOfCommandFromSnapshot(s);
        if (index == -1) {
            index = this.pastCommands.size() - 1;
        }
        for (int i = index; i >= 0; --i) {
            Command pastCommand = this.pastCommands.get(i);
            if (!(pastCommand instanceof DieCommand)) continue;
            return (DieCommand)pastCommand;
        }
        return null;
    }

    private int getIndexOfCommandFromSnapshot(Snapshot s) {
        for (Command c : this.snapshotMap.keySet()) {
            if (this.snapshotMap.get(c) != s) continue;
            return this.pastCommands.indexOf(c);
        }
        return -1;
    }

    public void enemiesSurrendered() {
        Snapshot pres = this.getSnapshot(Temporality.Present);
        pres.allFlee();
        this.updateAllTemporalities();
    }

    public Eff getContemporaneousEffect(DieCommand lastTargetableCommand) {
        if (lastTargetableCommand == null) {
            return null;
        }
        Snapshot s = this.getSnapshotBefore(lastTargetableCommand);
        if (s == null) {
            return null;
        }
        return lastTargetableCommand.dt.getDerivedEffect(s);
    }

    public void resetDueToFiddling() {
        this.resetDueToFiddling(this.dungeonContext.getParty().getHeroes(), MonsterTypeLib.monsterList(this.dungeonContext.getCurrentLevel().getMonsterList()));
    }

    public void resetDueToFiddling(List<Hero> heroes, List<Monster> monsters) {
        this.setup(heroes, monsters);
        BulletStuff.refreshEntities(this.getSnapshot(Temporality.Present).getAliveEntities());
    }

    public boolean isVictoryAssured() {
        return this.getSnapshot(Temporality.Future).isVictory();
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public DieCommand getFirstAttackAfter(Snapshot snapshot, Ent ent) {
        Command sourceCommand = this.getCommandFromSnapshot(snapshot);
        if (sourceCommand == null) {
            return FightLog.getFirstAttack(this.futureCommands, ent, 0);
        }
        List<List> cmdsl = Arrays.asList(this.pastCommands, this.futureCommands);
        for (int llIndex = 0; llIndex < cmdsl.size(); ++llIndex) {
            DieCommand possible;
            int indexInList;
            List cmds = cmdsl.get(llIndex);
            int startIndex = indexInList = cmds.indexOf(sourceCommand);
            if (indexInList >= 0) {
                startIndex = indexInList + 1;
            } else if (cmds == this.futureCommands && this.pastCommands.contains(sourceCommand)) {
                startIndex = 0;
            }
            if (startIndex == -1 || (possible = FightLog.getFirstAttack(cmds, ent, startIndex)) == null) continue;
            return possible;
        }
        return null;
    }

    private static DieCommand getFirstAttack(List<Command> list, Ent ent, int startIndex) {
        for (int i = startIndex; i < list.size(); ++i) {
            DieCommand dc;
            Command possible = list.get(i);
            if (!(possible instanceof DieCommand) || (dc = (DieCommand)possible).getSource() != ent) continue;
            return dc;
        }
        return null;
    }

    private boolean tooManyCommands() {
        return this.commandHistory.size() + this.pastCommands.size() + this.futureCommands.size() > 1000;
    }

    private void cmdsErr() {
        Sounds.playSound(Sounds.error);
        String msg = "error, too many commands [red]'you lose'[cu]";
        TannLog.error(msg);
        if (DungeonScreen.get() != null) {
            DungeonScreen.get().showDialog(msg);
        }
    }

    public static enum Temporality {
        Base,
        Visual,
        Present,
        Future,
        StartOfTurn;

    }
}

