/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.leaderboard;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import com.tann.dice.Main;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.leaderboard.LeaderboardDisplaySettings;
import com.tann.dice.gameplay.leaderboard.LeaderboardEntry;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import java.util.List;

public class LeaderboardDisplay
extends Group {
    LeaderboardDisplaySettings displaySettings = new LeaderboardDisplaySettings(LeaderboardDisplaySettings.LeaderboardDisplaySettingsType.Page);
    final Leaderboard leaderboard;

    public LeaderboardDisplay(Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
        this.setSize(this.getWidth(), LeaderboardDisplay.baseHeight());
        this.setTransform(false);
        this.layout();
    }

    public static int baseWidth() {
        return Main.isPortrait() ? 120 : 212;
    }

    public static int baseHeight() {
        return Main.isPortrait() ? 144 : 134;
    }

    public void layout() {
        this.layout(false);
    }

    public void layout(boolean fail) {
        Group a;
        this.clearChildren();
        this.setSize(LeaderboardDisplay.baseWidth(), LeaderboardDisplay.baseHeight());
        Pixl p = new Pixl(2);
        p.row(2).text(this.leaderboard.getColouredName()).row();
        if (this.leaderboard.getDescription() != null) {
            p.text(this.leaderboard.getDescription(), (int)((float)LeaderboardDisplay.baseWidth() * 0.98f)).row();
        }
        if (!this.leaderboard.isScoreHighEnough(this.leaderboard.getScore())) {
            p.text("[grey]Qualifying score: " + this.leaderboard.getRequiredScoreString());
            if (this.leaderboard.getScore() != 0) {
                if (Main.isPortrait()) {
                    p.row();
                }
                p.text("[grey] (your score: " + this.leaderboard.getScoreString(this.leaderboard.getScore()) + ")");
            }
            p.row();
        }
        if (fail) {
            p.actor(new Pixl(5, 5).border(Colours.red).text("[text]failed :(").row().text("[text]bug or server down").row().text("[text]or maybe your internet").row());
        } else if (this.leaderboard.getEntries() == null) {
            a = new Pixl(20).text("Loading...").pix();
            p.actor(a);
            this.leaderboard.makeRequest(this.displaySettings, new Runnable(){

                @Override
                public void run() {
                    LeaderboardDisplay.this.layout();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    LeaderboardDisplay.this.failLayout();
                }
            });
        } else {
            Actor bottom;
            int gap = 2;
            Pixl nameP = new Pixl(gap);
            Pixl scoreP = new Pixl(gap);
            Pixl submittedP = new Pixl(gap);
            Pixl positionP = new Pixl(gap);
            Pixl platformP = new Pixl(gap);
            long myId = Main.getSettings().getHighscoreIdentifier();
            String topColTag = "[text]";
            positionP.text("[text]#").row();
            nameP.text("[text]name").row();
            scoreP.text("[text]" + this.leaderboard.getScoreName()).row();
            submittedP.text("[text]submitted").row();
            platformP.text("[text]platform").row();
            Array<LeaderboardEntry> entriesArray = this.leaderboard.getEntries();
            List<LeaderboardEntry> entries = Tann.arrayToList(entriesArray);
            for (int i = 0; i < entries.size(); ++i) {
                String posPref;
                String authorString;
                LeaderboardEntry entry = entries.get(i);
                boolean myRow = entry.author_identifier == myId;
                String rowPref = "[text]";
                if (myRow) {
                    rowPref = "[pink]";
                }
                if ((authorString = entry.author) == null || authorString.length() == 0) {
                    authorString = "BLANK_NAME";
                }
                authorString = TextWriter.stripTags(authorString);
                int position = entry.position;
                switch (position) {
                    case 1: {
                        posPref = "[yellow]";
                        break;
                    }
                    case 2: {
                        posPref = "[light]";
                        break;
                    }
                    case 3: {
                        posPref = "[orange]";
                        break;
                    }
                    default: {
                        posPref = myRow ? rowPref : "[text]";
                    }
                }
                positionP.text(posPref + position).row(2);
                nameP.text(posPref + Tann.makeEllipses(TextWriter.rebracketTags(authorString), 10)).row(2);
                scoreP.text(posPref + this.leaderboard.getScoreString(entry.score)).row(2);
                if (Main.isPortrait()) continue;
                submittedP.text(this.getTaggedTime(Tann.getTimeDescription(entry.submitted_time))).row(2);
                platformP.text(this.getPlatStringTagged(entry.platform)).row(2);
            }
            Group ppp = positionP.pix(8);
            int hhh = (int)ppp.getHeight();
            p.actor(ppp).actor(LeaderboardDisplay.makeSeparator(hhh)).actor(nameP.pix(8)).actor(LeaderboardDisplay.makeSeparator(hhh)).actor(scoreP.pix(8));
            if (!Main.isPortrait()) {
                p.actor(LeaderboardDisplay.makeSeparator(hhh)).actor(submittedP.pix(8)).actor(LeaderboardDisplay.makeSeparator(hhh)).actor(platformP.pix(8));
            }
            if ((bottom = this.displaySettings.makeActor(this)) != null) {
                p.row().actor(bottom);
            }
        }
        a = p.pix();
        this.addActor(a);
        Tann.center(a);
        a.setY(this.getHeight() - a.getHeight() - 2.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, Colours.purple, 1);
        super.draw(batch, parentAlpha);
    }

    private String getTaggedTime(String d) {
        if (d.contains("days")) {
            return "[text]" + d;
        }
        if (d.contains("day")) {
            return "[light]" + d;
        }
        return "[grey]" + d;
    }

    private String getPlatStringTagged(String platform) {
        if (platform == null) {
            return "[yellow]?";
        }
        if (platform.equalsIgnoreCase("android")) {
            return "[green]" + platform;
        }
        if (platform.equalsIgnoreCase("desktop")) {
            return "[text]" + platform;
        }
        if (platform.equalsIgnoreCase("iOS")) {
            return "[orange]" + platform;
        }
        return "[pink]" + platform;
    }

    private static Actor makeSeparator(int height) {
        return new Rectactor(1, height, Colours.grey);
    }

    private void failLayout() {
        this.layout(true);
    }

    public void setNewDisplaySettings(LeaderboardDisplaySettings leaderboardDisplaySettings) {
        this.displaySettings = leaderboardDisplaySettings;
        this.leaderboard.entries = null;
        this.layout();
    }
}

