/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice;

import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.lang.Words;
import java.util.ArrayList;
import java.util.List;

public class ChoiceType {
    ChoiceStyle cs;
    int v;
    transient List<Choosable> currentChoices = new ArrayList<Choosable>();

    public ChoiceType(String s) {
        String[] parts = s.split("#");
        this.cs = ChoiceStyle.valueOf(parts[0]);
        this.v = Integer.parseInt(parts[1]);
    }

    public String toSaveString() {
        return (Object)((Object)this.cs) + "#" + this.v;
    }

    public ChoiceType(ChoiceStyle choiceStyle, int value) {
        this.cs = choiceStyle;
        this.v = value;
    }

    public boolean toggleChoice(Choosable c) {
        if (this.currentChoices.contains(c)) {
            this.currentChoices.remove(c);
            Sounds.playSound(Sounds.pop);
        } else {
            this.currentChoices.add(c);
            Sounds.playSound(Sounds.pip);
        }
        return this.checkValid(false);
    }

    public void clearChoices() {
        this.currentChoices.clear();
    }

    public boolean checkValid(boolean confirm) {
        switch (this.cs) {
            case Number: {
                return this.currentChoices.size() == this.v;
            }
            case UpToNumber: {
                return this.currentChoices.size() <= this.v && confirm;
            }
            case PointBuy: {
                if (this.currentChoices.isEmpty()) {
                    return false;
                }
                int total = 0;
                for (Choosable c : this.currentChoices) {
                    total += c.getTier();
                }
                if (this.v > 0 && (float)total < (float)this.v * 0.7f) {
                    return false;
                }
                if (this.v < 0 && (float)total < (float)this.v * 1.5f) {
                    return false;
                }
                return total <= this.v && !this.currentChoices.isEmpty();
            }
            case Optional: {
                return true;
            }
        }
        throw new RuntimeException("uhoh invalid choicestyle: " + (Object)((Object)this.cs));
    }

    public String getDescription(List<Choosable> options) {
        if (options.size() == 0) {
            return "wtf/?";
        }
        String choiceName = options.get(0).describe();
        for (Choosable c : options) {
            String s;
            if (ChoosableUtils.isMeta(c) || (s = c.describe()).equalsIgnoreCase(choiceName)) continue;
            choiceName = Words.plural("thing", this.v);
            break;
        }
        switch (this.cs) {
            case Number: {
                String amtString = this.v == 1 ? (Words.startsWithVowel(choiceName) ? "an" : "a") : "" + this.v;
                return "Choose " + amtString + " " + Words.plural(choiceName, this.v);
            }
            case UpToNumber: {
                return "Choose up to " + this.v + " " + Words.plural(choiceName, this.v);
            }
            case PointBuy: {
                return "Choose " + Words.plural(choiceName, true) + " with a combined value of " + Words.getTierString(this.v, true);
            }
            case Optional: {
                return null;
            }
        }
        throw new RuntimeException("uhoh invalid choicestyle: " + (Object)((Object)this.cs));
    }

    public static enum ChoiceStyle {
        Number,
        PointBuy,
        UpToNumber,
        Optional;

    }
}

