/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.meta;

import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MissingnoPhase;

public class BooleanPhase
extends Phase {
    final String key;
    final int threshold;
    final Phase a;
    final Phase b;
    static final String MINI_SEPS = ";";
    static final String BOOL_PHASE_SEP = "@2";

    public BooleanPhase(String key, int threshold, Phase a, Phase b) {
        this.key = key;
        this.threshold = threshold;
        this.a = a;
        this.b = b;
    }

    public BooleanPhase(String data) {
        String[] parts = data.split(MINI_SEPS, 3);
        this.key = parts[0];
        this.threshold = Integer.parseInt(parts[1]);
        String[] phaseStrings = parts[2].split(BOOL_PHASE_SEP, 2);
        this.a = Phase.deserialise(phaseStrings[0]);
        this.b = Phase.deserialise(phaseStrings[1]);
        if (this.a instanceof MissingnoPhase || this.b instanceof MissingnoPhase) {
            throw new RuntimeException("Invalid Boolean phase " + data);
        }
    }

    @Override
    public void activate() {
        DungeonContext dc = this.getContext();
        if (dc == null) {
            this.pushPhaseAndEnd(new MessagePhase("Failed to find context"));
            return;
        }
        Integer v = dc.getValue(this.key);
        if (v == null || v < this.threshold) {
            this.pushPhaseAndEnd(this.b);
        } else {
            this.pushPhaseAndEnd(this.a);
        }
    }

    @Override
    public String serialise() {
        return "b" + this.key + MINI_SEPS + this.threshold + MINI_SEPS + this.a.serialise() + BOOL_PHASE_SEP + this.b.serialise();
    }

    private void pushPhaseAndEnd(Phase p) {
        PhaseManager.get().pushPhaseNext(p);
        PhaseManager.get().popPhase(this.getClass());
    }

    @Override
    public void deactivate() {
    }

    @Override
    public boolean canSave() {
        return true;
    }
}

