/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.fightEnd;

import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.gameplay.PlayerRollingPhase;
import com.tann.dice.gameplay.progress.StatSnapshot;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.fightEnd.FightEndCurseAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.fightEnd.fleeAchievement.FleeAchievement;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class FightEndAchievement
extends Achievement {
    public FightEndAchievement(String name, String description, Unlockable ... unlockables) {
        super(name, description, unlockables);
    }

    public abstract boolean endOfFightCheck(StatSnapshot var1, boolean var2);

    public static List<Achievement> make() {
        ArrayList<Achievement> all = new ArrayList<Achievement>();
        all.addAll(FightEndCurseAchievement.makeAll());
        all.addAll(FleeAchievement.makeAll());
        all.addAll(Arrays.asList(new FightEndAchievement("First Boss", "Beat level 4", new Unlockable[]{HeroCol.red, HeroCol.blue}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.context.getCurrentLevelNumber() >= 4;
            }
        }.diff(0.0f), new FightEndAchievement("Unlock a door", "Beat level 8", new Unlockable[]{Mode.SHORTCUT}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.context.getCurrentLevelNumber() >= 8;
            }
        }.diff(0.0f), new FightEndAchievement("Cheat Death", "Win the Tarantus fight with no dead heroes", new Unlockable[]{ItemLib.byName("Determination")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                if (ss.afterCommand.getEntities(true, true).size() > 0) {
                    return false;
                }
                for (Ent de : ss.afterCommand.getEntities(false, true)) {
                    if (!de.name.equalsIgnoreCase(MonsterTypeLib.byName("tarantus").getName(false))) continue;
                    return true;
                }
                return false;
            }
        }.diff(12.0f), new FightEndAchievement("Draw", "Win and lose a fight at the same time", new Unlockable[]{ItemLib.byName("knife bag")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return ss.afterCommand.isVictory() && ss.afterCommand.getEntities(true, false).size() == 0;
            }
        }.diff(10.0f), new FightEndAchievement("Survivor", "Win a fight with only one surviving hero", new Unlockable[]{ItemLib.byName("Candle")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.afterCommand.getEntities(true, false).size() == 1;
            }
        }.diff(7.0f), new FightEndAchievement("Alpha Strike", "Win a fight on the first turn", new Unlockable[]{ItemLib.byName("Hourglass")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.afterCommand.getTurn() == 1;
            }
        }.diff(7.0f), new FightEndAchievement("Alpha Strike+", "Win a fight on the first turn whilst rolling", new Unlockable[0]){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.afterCommand.getTurn() == 1 && PhaseManager.get().getPhase() instanceof PlayerRollingPhase;
            }
        }.diff(7.0f), new FightEndAchievement("Crushed", "Beat a boss fight on the first turn", new Unlockable[]{ItemLib.byName("Learn Infinity")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.afterCommand.getTurn() == 1 && ss.context.isBossFight();
            }
        }.diff(12.0f), new FightEndAchievement("Crushed+", "Beat the final boss fight on the first turn", new Unlockable[]{OptionLib.ROMAN_MODE}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                return victory && ss.afterCommand.getTurn() == 1 && ss.context.isAtLastLevel();
            }
        }.diff(12.0f), new FightEndAchievement("Last legs", "Win a fight with 4+ heroes on 1hp", new Unlockable[]{ItemLib.byName("Relic")}){

            @Override
            public boolean endOfFightCheck(StatSnapshot ss, boolean victory) {
                if (!victory) {
                    return false;
                }
                int atOne = 0;
                for (EntState m : ss.afterCommand.getAliveHeroStates()) {
                    if (m.getHp() != 1) continue;
                    ++atOne;
                }
                return atOne >= 4;
            }
        }.diff(7.0f)));
        return all;
    }
}

