/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.GSCConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ParamCondition;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.GenericStateCondition;
import com.tann.dice.util.lang.Words;

public class GlobalAllEntitiesRestricted
extends GlobalLinked {
    final boolean player;
    final ConditionalRequirement conReq;
    final Personal personal;
    long extraCollision;

    public GlobalAllEntitiesRestricted(boolean player, ConditionalRequirement req, Personal personal) {
        super(personal);
        this.player = player;
        this.conReq = req;
        this.personal = personal;
    }

    public GlobalAllEntitiesRestricted(boolean player, GenericStateCondition gsc, Personal personal) {
        this(player, new GSCConditionalRequirement(gsc), personal);
        this.extraCollision = gsc.getCollision();
    }

    @Override
    public String describeForSelfBuff() {
        return this.describeRestriction() + ":[n]" + this.personal.describeForSelfBuff();
    }

    private String describeRestriction() {
        if (this.conReq instanceof GSCConditionalRequirement) {
            return this.conReq.getBasicString() + " " + (this.player ? "heroes" : "monsters");
        }
        boolean plural = this.conReq.isPlural();
        boolean xWith = this.conReq instanceof GSCConditionalRequirement || this.conReq instanceof ParamCondition;
        String start = plural ? "All " : "The ";
        String cbs = this.conReq.getBasicString().toLowerCase();
        if (xWith) {
            start = this.player ? start + "heroes " : start + "monsters ";
            return start + cbs;
        }
        return start + cbs + " " + Words.entName(null, this.player, plural ? Boolean.valueOf(true) : null);
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (entState.getEnt().isPlayer() != this.player || entState.getSnapshot() == null) {
            return null;
        }
        boolean valid = this.conReq.isValid(entState.getSnapshot(), entState, entState, null);
        if (valid) {
            return this.personal;
        }
        return super.getLinkedTrigger(entState);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return DipPanel.makeSidePanelGroup(big, this.conReq.getRestrictionActor(), this.personal, GlobalAllEntities.colForPlayer(this.player));
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.extraCollision | this.personal.getCollisionBits(player);
    }

    @Override
    public boolean isMultiplable() {
        return false;
    }

    @Override
    public String hyphenTag() {
        return ModifierUtils.hyphenTag(this.personal.hyphenTag(), GlobalAllEntitiesRestricted.makeTag(this.conReq));
    }

    private static String makeTag(ConditionalRequirement conReq) {
        if (conReq instanceof ParamCondition) {
            return ((ParamCondition)conReq).hyphenTag();
        }
        return null;
    }
}

