/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.TextWriter;

public class GlobalEveryNthDice
extends GlobalLinked {
    final int num;
    final boolean every;
    final AffectSides linked;
    private final String desc;

    public GlobalEveryNthDice(int num, Keyword k) {
        this(num, true, new AffectSides(new AddKeyword(k)), "gains " + k.getColourTaggedString());
    }

    private GlobalEveryNthDice(int num, boolean every, AffectSides linked, String desc) {
        super(linked);
        this.desc = desc;
        this.num = num;
        this.every = every;
        this.linked = linked;
        if (linked instanceof AffectSides) {
            linked.buffPriority();
        }
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return new Pixl(2, 2).border(Colours.green).actor(new TextWriter(this.describeFreqShort() + ":", 35)).gap(2).actor(this.linked.makePanelActor(big)).pix();
    }

    @Override
    public String describeForSelfBuff() {
        return this.describeFreq() + " " + this.desc + ModifierUtils.afterItems();
    }

    private String describeFreq() {
        return this.describeFreqShort() + " you use each turn";
    }

    private String describeFreqShort() {
        if (this.every) {
            return "Every " + Words.ordinal(this.num) + " dice";
        }
        return "The " + Words.ordinal(this.num) + " dice";
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (!entState.isPlayer()) {
            return null;
        }
        Snapshot s = entState.getSnapshot();
        if (s == null) {
            return null;
        }
        int diceUsed = s.getNumDiceUsedThisTurn();
        if (!this.every && this.num == diceUsed + 1 || this.every && (diceUsed + 1) % this.num == 0) {
            return this.linked;
        }
        return null;
    }

    public static Modifier makeNthKeyword(int n, Keyword k) {
        float allTier = KUtils.getModTierAllHero(k);
        float multiplier = (float)(1.0 / Math.pow(n, 1.05f));
        float tier = allTier * multiplier;
        return new Modifier(tier, Words.ordinal(n) + " " + k.name(), new GlobalEveryNthDice(n, k)).rarity(Rarity.THIRD);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return Collision.ignored(this.linked.getCollisionBits(true), Collision.GENERIC_ALL_SIDES_HERO);
    }
}

