/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ui.TextWriter;

public class GlobalSize
extends GlobalLinked {
    final EntSize size;
    final Personal trigger;
    final String prefix;

    public GlobalSize(EntSize size, Personal trigger) {
        super(trigger);
        this.size = size;
        this.trigger = trigger;
        switch (size) {
            case small: {
                this.prefix = "All tiny enemies " + GlobalSize.ex("archer");
                break;
            }
            case reg: {
                this.prefix = "All hero-sized enemies " + GlobalSize.ex("wolf");
                break;
            }
            case big: {
                this.prefix = "All big enemies " + GlobalSize.ex("troll");
                break;
            }
            case huge: {
                this.prefix = "All huge enemies " + GlobalSize.ex("dragon");
                break;
            }
            default: {
                this.prefix = "All ??? enemies " + GlobalSize.ex("hm");
            }
        }
    }

    private static String ex(String monster) {
        return "[grey](such as " + monster + ")[cu][p]";
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (entState.getEnt().isPlayer() || this.size != entState.getEnt().getSize()) {
            return super.getLinkedTrigger(entState);
        }
        return this.trigger;
    }

    @Override
    public String describeForSelfBuff() {
        String gains = this.trigger.describeForSelfBuff();
        if (gains == null) {
            gains = this.trigger.describeForSelfBuff();
        }
        return this.prefix + ":[n]" + gains;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        String sizeName = (Object)((Object)this.size) + "";
        if (this.size == EntSize.reg) {
            sizeName = "hero-[n]sized";
        }
        return DipPanel.makeSidePanelGroup(big, (Actor)new TextWriter("[purple]" + sizeName), this.trigger, Colours.red);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.trigger.getCollisionBits(false);
    }
}

