/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.targetable.DieTargetable;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.command.SimpleCommand;
import com.tann.dice.gameplay.fightLog.event.entState.ChatStateEvent;
import com.tann.dice.gameplay.fightLog.event.snapshot.SnapshotEvent;
import com.tann.dice.gameplay.fightLog.listener.SnapshotChangeListener;
import com.tann.dice.gameplay.fightLog.listener.VictoryLossListener;
import com.tann.dice.gameplay.level.Level;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.endPhase.runEnd.RunEndPhase;
import com.tann.dice.gameplay.phase.gameplay.EnemyRollingPhase;
import com.tann.dice.gameplay.phase.gameplay.PlayerRollingPhase;
import com.tann.dice.gameplay.phase.gameplay.SurrenderPhase;
import com.tann.dice.gameplay.phase.gameplay.TargetingPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPanel;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.progress.MasterStats;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.save.LoadCrashException;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.save.SaveStateData;
import com.tann.dice.gameplay.save.antiCheese.AntiCheeseRerollInfo;
import com.tann.dice.gameplay.save.antiCheese.AnticheeseData;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.RollManager;
import com.tann.dice.screens.dungeon.TargetingManager;
import com.tann.dice.screens.dungeon.background.BackgroundHolder;
import com.tann.dice.screens.dungeon.background.Dust;
import com.tann.dice.screens.dungeon.panels.ConfirmButton;
import com.tann.dice.screens.dungeon.panels.EntContainer;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.Explanel.InfoPanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.threeD.DieRenderer;
import com.tann.dice.screens.dungeon.panels.time.Clock;
import com.tann.dice.screens.dungeon.panels.time.SpeedrunTimer;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.screens.generalPanels.PartyManagementPanel;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.screens.titleScreen.GameStart;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.VersionUtils;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.saves.Prefs;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.Button;
import com.tann.dice.util.ui.action.PixAction;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DungeonScreen
extends Screen
implements ExplanelReposition,
VictoryLossListener,
SnapshotChangeListener {
    private static DungeonScreen self;
    public EntContainer hero;
    public EntContainer enemy;
    FightLog fightLog;
    public TargetingManager targetingManager;
    public RollManager rollManager;
    public PartyManagementPanel partyManagementPanel;
    Party party;
    DungeonContext dungeonContext;
    public Group rollGroup = Tann.makeGroup(DungeonScreen.getBotButtWidth(), DungeonScreen.getBottomButtonHeight());
    public Button diceRollButton;
    public Button undoButton;
    public ConfirmButton confirmButton;
    public ConfirmButton doneRollingButton;
    public AbilityHolder abilityHolder;
    public Group optionsButtonsGroup;
    private boolean loading;
    TutorialManager tutorialManager;
    public StandardButton hiddenInventoryButton;
    int undosInARow = 0;
    private final List<Stat> storedMergedList;
    private SpeedrunTimer tt;
    private Clock clock;
    long lastSaved = -1L;
    Map<String, Integer> storedStats;
    Boolean allDiceUsed = null;
    private BackgroundHolder bgh;
    private List<Actor> cleanupActors = new ArrayList<Actor>();
    private Actor undoActor;
    private static final int TOP_BUTTON_GAP_FROM_TOP = 2;
    int lastTurn = 0;
    int stateIndex = 0;
    public static final int BASE_BOTTOM_BUTTON_HEIGHT = 29;
    public static boolean tinyPasting;

    public static DungeonScreen get() {
        return self;
    }

    public DungeonScreen(DungeonContext dungeonContext) {
        this(dungeonContext, null, null, null, null);
        String cheeseKey = dungeonContext.getContextConfig().getAnticheeseKey();
        if (cheeseKey != null) {
            this.saveAntiCheese();
        }
    }

    public DungeonScreen(DungeonContext dungeonContext, List<String> commandState, String sideSate, List<String> phases, String json) {
        self = this;
        this.dungeonContext = dungeonContext;
        this.party = dungeonContext.getParty();
        ContextConfig.resetCache();
        PhaseManager.get().clearListeners();
        Sounds.setSoundEnabled(true);
        this.storedMergedList = new ArrayList<Stat>(Main.self().masterStats.createMergedStats(dungeonContext.getContextConfig().mode).values());
        MasterStats.clearMergedStats();
        if (commandState != null || sideSate != null) {
            this.loadFromCommandState(commandState, sideSate, json);
        } else {
            this.fightLog = new FightLog(dungeonContext);
        }
        this.fightLog.registerSnapshotListener(this, FightLog.Temporality.Visual);
        this.fightLog.registerVictoryLossListener(this);
        this.fightLog.registerStatUpdate(dungeonContext.getStatsManager());
        this.fightLog.registerStatUpdate(Main.self().masterStats);
        this.rollManager = new RollManager(this.fightLog);
        this.targetingManager = new TargetingManager(this.fightLog);
        this.partyManagementPanel = new PartyManagementPanel(this.fightLog);
        this.addActor(new DieRenderer());
        this.enemy = new EntContainer(false);
        this.addActor(this.enemy);
        this.hero = new EntContainer(true);
        this.addActor(this.hero);
        this.tutorialManager = new TutorialManager(this);
        this.addActor(this.tutorialManager.tutorialHolder);
        this.fightLog.registerSnapshotListener(this.tutorialManager, FightLog.Temporality.Visual);
        this.fightLog.registerStatUpdate(this.tutorialManager);
        PhaseManager.get().registerPhaseListen(this.tutorialManager);
        int spellWidth = (int)(this.getWidth() - (float)(DungeonScreen.getBotButtWidth() * 2));
        if (OptionLib.GAP.c() != 0) {
            spellWidth = (int)((float)spellWidth * 0.56f);
            if (OptionLib.GAP.c() == 2) {
                spellWidth = (int)Math.min((float)spellWidth, this.getWidth() - (float)(DungeonScreen.getBotButtWidth() * 2) - this.enemy.getWidth() - 10.0f);
            }
        }
        this.abilityHolder = new AbilityHolder(spellWidth, this.fightLog);
        this.addActor(this.abilityHolder);
        this.abilityHolder.setPosition(DungeonScreen.getBotButtWidth(), -this.abilityHolder.getHeight());
        this.abilityHolder.toBack();
        this.slideSpellHolder(AbilityHolder.TuckState.OffScreen, false);
        this.setupButtons();
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!event.isHandled()) {
                    DungeonScreen.this.bottomClick();
                }
                return super.touchDown(event, x, y, pointer, button);
            }
        });
        this.bgh = new BackgroundHolder();
        this.bgh.populate(dungeonContext.getLevelTypes());
        this.refreshStoredStats();
        if (this.loading) {
            Snapshot s = this.fightLog.getSnapshot(FightLog.Temporality.Present);
            ArrayList<Ent> entitiesForBulletDiceList = new ArrayList<Ent>(s.getHeroesAliveAtStartOfTurn());
            entitiesForBulletDiceList.addAll(s.getAliveMonsterEntities());
            Tann.uniquify(entitiesForBulletDiceList);
            BulletStuff.refreshEntities(entitiesForBulletDiceList);
            this.fightLog.tick();
            PhaseManager.get().clearPhases();
            PhaseManager.get().deserialise(phases);
            int bgStartIndex = dungeonContext.getCurrentLevelNumber() - 1;
            this.bgh.setStartIndex(bgStartIndex);
            this.enemy.assumeHoldsDie();
            Sounds.setSoundEnabled(true);
            this.act(0.001f);
            this.fightLog.updateAllTemporalities();
            this.specialSaveConsiderations(sideSate);
            this.loading = false;
            dungeonContext.addTime(5.0f);
        } else {
            this.bgh.setStartIndex(dungeonContext.getCurrentLevelNumber() - 2);
            this.progressBackground();
            this.startGame(json != null);
        }
        this.fightLog.updateAllTemporalities();
        dungeonContext.startTimer();
        this.refreshTimer();
        this.refreshClock();
        this.addStreamerRects();
    }

    private void specialSaveConsiderations(String sideSate) {
        boolean activated;
        if (FightLog.isSpecialSave(sideSate, true) && (activated = this.fightLog.triggerAllHeroOnLandDueToSave())) {
            this.save();
        }
        if (FightLog.isSpecialSave(sideSate, false) && (activated = this.fightLog.triggerAllMonsterOnLandDueToSave())) {
            this.save();
        }
    }

    private void addStreamerRects() {
        int h;
        int y;
        int w;
        int x;
        boolean top;
        if (OptionLib.GAP.c() == 0) {
            return;
        }
        boolean bl = top = OptionLib.GAP.c() == 2;
        if (top) {
            x = (int)(this.confirmButton.getX() + this.confirmButton.getWidth());
            w = Main.width - x;
            y = (int)(this.enemy.getY() + this.enemy.getHeight());
            h = Main.height - y;
        } else {
            x = (int)(this.confirmButton.getX() + this.confirmButton.getWidth());
            w = Main.width - x;
            y = 0;
            h = (int)((float)Main.height - this.enemy.getHeight());
        }
        Color c = Colours.withAlpha(Colours.dark, 0.15f).cpy();
        Rectactor ra = new Rectactor(w, h, null, c);
        ra.setTouchable(Touchable.disabled);
        ra.setPosition(x, y);
        this.addActor(ra);
        ra.toBack();
    }

    private void loadFromCommandState(List<String> commandState, String sideSate, String json) {
        this.loading = true;
        BulletStuff.reset();
        Sounds.setSoundEnabled(false);
        try {
            this.fightLog = new FightLog(this.party.getHeroes(), MonsterTypeLib.monsterList(this.dungeonContext.getCurrentLevel().getMonsterList()), commandState, sideSate, this.dungeonContext);
        }
        catch (Exception stateLoadException) {
            TannLog.log("failed to load save properly from " + json, TannLog.Severity.error);
            this.showDialog("Failed to load save[n]Things may [red][sin]broken[sin][n][text]Restarting from start of battle");
            stateLoadException.printStackTrace();
            this.loading = false;
            commandState = null;
            sideSate = null;
            try {
                this.fightLog = new FightLog(this.dungeonContext);
                this.fightLog.setFailed(true);
                for (Hero h : this.party.getHeroes()) {
                    h.getDie().setSide(0);
                }
                Sounds.setSoundEnabled(true);
            }
            catch (Exception fallbackException) {
                DungeonScreen.clearStaticReference();
                throw new LoadCrashException(fallbackException);
            }
        }
    }

    public void startGame(boolean skipContextPhases) {
        PhaseManager pm = PhaseManager.get();
        pm.clearPhases();
        this.startLevel(skipContextPhases);
    }

    @Override
    public void loss() {
        this.enemy.assumeHoldsDie();
        this.hero.assumeHoldsDie();
        PhaseManager.get().clearPhases();
        PhaseManager.get().pushPhase(new RunEndPhase(false));
    }

    @Override
    public void victory() {
        this.enemy.assumeHoldsDie();
        this.hero.assumeHoldsDie();
        this.enemy.clearAfterInPlace();
        BulletStuff.clearAllDice();
        DungeonScreen.get().popAllLight();
        List<Phase> phases = PhaseManager.get().clearPhasesAndReturnEndable();
        Phase p = this.getDungeonContext().onWinLevel();
        if (p instanceof LevelEndPhase) {
            LevelEndPhase lep = (LevelEndPhase)p;
            for (Phase phase : phases) {
                lep.addPhase(phase);
            }
        }
        PhaseManager.get().pushPhase(p);
    }

    public void confirmClicked(boolean fromClick) {
        if (this.fightLog.getSnapshot(FightLog.Temporality.Present).isVictory()) {
            return;
        }
        if (fromClick) {
            this.popAllLight();
        }
        Phase phase = PhaseManager.get().getPhase();
        phase.confirmClicked(fromClick);
    }

    @Override
    public void preDraw(Batch batch) {
        batch.setColor(Colours.dark);
        Draw.fillRectangle(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        batch.setColor(Colours.z_white);
        this.renderBackground(batch);
        List<Ent> aliveEntities = this.fightLog.getSnapshot(FightLog.Temporality.Visual).getAliveEntities();
        int aliveEntitiesSize = aliveEntities.size();
        for (int i = 0; i < aliveEntitiesSize; ++i) {
            Ent de = aliveEntities.get(i);
            de.getEntPanel().drawBackground(batch);
        }
    }

    @Override
    public void postDraw(Batch batch) {
        int i;
        for (i = 0; i < this.enemy.getEntities().size(); ++i) {
            this.enemy.getEntities().get(i).getEntPanel().postDraw(batch);
        }
        for (i = 0; i < this.hero.getEntities().size(); ++i) {
            this.hero.getEntities().get(i).getEntPanel().postDraw(batch);
        }
    }

    public static void drawVersionPixel(Batch batch) {
        int y = Gdx.graphics.getHeight();
        batch.setColor(VersionUtils.VERSION_COL);
        Draw.pixel(batch, 0, --y);
        batch.setColor(Main.self().control.getCol());
        Draw.pixel(batch, 1, y);
    }

    @Override
    public void preTick(float delta) {
    }

    @Override
    public void postTick(float delta) {
    }

    @Override
    public void keyPress(int keycode) {
        switch (keycode) {
            case 32: {
                System.out.println("debug");
            }
        }
        Phase p = PhaseManager.get().getPhase();
        if (p != null) {
            p.keyPress(keycode);
        }
    }

    public void killAllEnemies() {
        if (!this.getFightLog().getSnapshot(FightLog.Temporality.Present).isVictory()) {
            this.getFightLog().addCommand(new SimpleCommand(null, new SimpleTargetable(null, new EffBill().group().kill().bEff())), false);
        }
    }

    @Override
    public Screen copy() {
        if (SaveState.hasSave(this.dungeonContext.getContextConfig().getGeneralSaveKey())) {
            return SaveState.load(this.dungeonContext.getContextConfig().getGeneralSaveKey()).makeDungeonScreen();
        }
        return new TitleScreen();
    }

    private SaveState makeSaveState() {
        try {
            return new SaveState(this.dungeonContext, this.fightLog.serialiseCommands(), this.fightLog.serialiseSides(), PhaseManager.get().serialise());
        }
        catch (Exception e) {
            e.printStackTrace();
            TannLog.log("Failed to save: " + e.getMessage());
            return null;
        }
    }

    public void mildSave() {
        this.save();
    }

    public void save() {
        this.lastSaved = System.currentTimeMillis();
        this.handleStatChanges();
        SaveState ss = this.makeSaveState();
        if (ss != null) {
            ss.save();
        }
    }

    private void handleStatChanges() {
        if (!OptionLib.SHOW_STAT_POPUPS.c()) {
            return;
        }
        List<TP<String, String>> changes = this.dungeonContext.getStatChanges(this.storedStats);
        this.refreshStoredStats();
        for (TP<String, String> tp : changes) {
            Group a = new Pixl(3, 3).border(Colours.purple).text("[grey]" + (String)tp.a + " : " + (String)tp.b).pix();
            this.addPopup(a);
        }
    }

    private void refreshStoredStats() {
        if (OptionLib.SHOW_STAT_POPUPS.c()) {
            this.storedStats = this.dungeonContext.getNonZeroStatMap();
        }
    }

    public void somethingChanged() {
        this.allDiceUsed = null;
        this.targetingManager.anythingChanged();
    }

    public boolean checkAllDiceUsedCached() {
        if (this.allDiceUsed == null) {
            this.allDiceUsed = this.checkAllDiceUsed(false);
        }
        return this.allDiceUsed;
    }

    public int numUnusedDice(boolean allowSkipInadvisable) {
        int result = 0;
        List<? extends Ent> entities = this.fightLog.getActiveEntities(true);
        Snapshot present = this.fightLog.getSnapshot(FightLog.Temporality.Present);
        for (int i = 0; i < entities.size(); ++i) {
            EntDie d = entities.get(i).getDie();
            DieTargetable dt = d.getTargetable();
            EntState es = present.getState(d.ent);
            if (!es.canUse() || !this.targetingManager.isUsable(dt, allowSkipInadvisable)) continue;
            Eff e = dt.getDerivedEffects();
            if (allowSkipInadvisable && e.allowAutoskip() || allowSkipInadvisable && es.isInadvisable(e)) continue;
            ++result;
        }
        return result;
    }

    public boolean checkAllDiceUsed(boolean allowSkipBadKeywords) {
        return this.numUnusedDice(allowSkipBadKeywords) == 0;
    }

    @Override
    public void act(float delta) {
        this.fightLog.tick();
        super.act(delta);
        PhaseManager.get().tick(delta);
        this.bgh.act(delta);
    }

    public void startLevel(boolean skipContextPhases) {
        MasterStats.clearMergedStats();
        BulletStuff.reset();
        this.getFightLog().resetForNewFight();
        Level l = this.dungeonContext.getCurrentLevel();
        List<Monster> monsters = MonsterTypeLib.monsterList(l.getMonsterList());
        Float diffD = l.getDiffD();
        if (OptionLib.SHOW_LEVEL_DIFF.c() && diffD != null) {
            this.addPopup(new Pixl(4, 4).border(Colours.orange).text(l.diffDeltaString()).pix());
        }
        List<Hero> heroes = this.party.getHeroes();
        this.getFightLog().setup(heroes, monsters);
        BulletStuff.refreshEntities(this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveEntities());
        PhaseManager pm = PhaseManager.get();
        if (!skipContextPhases && this.dungeonContext.isFirstLevel()) {
            ArrayList<Phase> phases = new ArrayList<Phase>();
            this.dungeonContext.addPhasesFromCurrentLevel(phases);
            for (Phase p : phases) {
                pm.pushPhase(p);
            }
        }
        if (this.party.hasAnyItems() && !pm.has(LevelEndPhase.class)) {
            LevelEndPhase toAdd = new LevelEndPhase(true);
            if (pm.has(ChoicePhase.class)) {
                pm.pushPhaseAfter(toAdd, ChoicePhase.class);
            } else {
                pm.pushPhase(toAdd);
            }
        }
        pm.pushPhase(new EnemyRollingPhase());
        this.save();
        if (Main.self().control.useBackups()) {
            Prefs.backupSave();
        }
    }

    private void renderBackground(Batch batch) {
        if (this.bgh != null) {
            this.bgh.draw(batch, 1.0f);
        }
    }

    public void progressBackground() {
        if (TestRunner.isTesting()) {
            return;
        }
        Vector2 dist = this.bgh.progress();
        this.enemy.setInPlace(false);
        this.enemy.slideIn(dist, new Runnable(){

            @Override
            public void run() {
                DungeonScreen.this.enemy.setInPlace(true);
            }
        });
    }

    public DungeonContext getDungeonContext() {
        return this.dungeonContext;
    }

    public FightLog getFightLog() {
        return this.fightLog;
    }

    @Override
    public void repositionExplanel(Explanel exp) {
        if (Main.isPortrait()) {
            exp.setPosition((int)((float)(Main.width / 2) - exp.getWidth() / 2.0f), InfoPanel.getPortraitPanelY() + exp.getExtraBelowExtent());
        } else {
            exp.setPosition((int)((float)(Main.width / 2) - exp.getWidth() / 2.0f), (int)((float)(Main.height / 2) - exp.getHeight() / 2.0f));
        }
    }

    public void addCleanupActor(Actor a) {
        this.cleanupActors.add(a);
    }

    public void removeAllEffects() {
        for (Actor a : this.cleanupActors) {
            a.remove();
        }
        this.cleanupActors.clear();
    }

    private void bottomClick() {
        if (Main.scale == 0) {
            return;
        }
        if (this.stackContains(Explanel.class) || this.stackContains(DiePanel.class)) {
            Sounds.playSound(Sounds.pop);
        }
        if (this.popAllLight()) {
            return;
        }
        if (this.pop(InventoryPanel.class)) {
            return;
        }
        if (this.targetingManager.deselectTargetable()) {
            return;
        }
        if (!BulletStuff.isMouseOnDice() && Dust.allowActor(this.getActorUnderMouse())) {
            this.makeDust();
        }
    }

    public void slideButton(Actor button, boolean in, boolean instant, float delay) {
        button.clearActions();
        if (DungeonScreen.get().isLoading()) {
            instant = true;
        }
        Action move = PixAction.moveTo((int)button.getX(), in ? 0 : (int)(-button.getHeight()) - 30, instant ? 0.0f : 0.3f, Chrono.i);
        if (delay > 0.0f && !instant) {
            button.addAction(Actions.delay(delay, move));
        } else {
            button.addAction(move);
        }
    }

    public void slideButton(Actor button, boolean in, boolean instant) {
        this.slideButton(button, in, instant, 0.0f);
    }

    private void setupButtons() {
        this.diceRollButton = new Button(DungeonScreen.getBotButtWidth(), DungeonScreen.getBottomButtonHeight(), null, new Runnable(){

            @Override
            public void run() {
                DungeonScreen.this.popAllLight();
                DungeonScreen.this.rollManager.requestPlayerRoll();
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (OptionLib.LONGTAP_END.c()) {
                    DungeonScreen.this.popAllLight();
                    DungeonScreen.this.confirmClicked(true);
                }
            }
        }){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                super.draw(batch, parentAlpha);
                if (!Main.getSettings().isHasRolled()) {
                    boolean anyRollingOrUnlocking = false;
                    for (Ent ent : DungeonScreen.this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveHeroEntities()) {
                        Die.DieState state = ent.getDie().getState();
                        if (state != Die.DieState.Rolling && state != Die.DieState.Unlocking) continue;
                        anyRollingOrUnlocking = true;
                        break;
                    }
                    if (!anyRollingOrUnlocking) {
                        Tann.drawPatch(batch, this, this.getPatch(), Colours.shiftedTowards(Colours.dark, Colours.green, Main.pulsateFactor() / 2.0f), Colours.grey, 1);
                    }
                }
                int border = 2;
                TextureRegion pairODice = Images.reroll;
                int n = TannFont.font.getWidth("reroll");
                int imageWidth = pairODice.getRegionWidth();
                int gap = (int)((this.getWidth() - (float)n - (float)imageWidth - (float)(border * 2)) / 3.0f);
                batch.setColor(Colours.z_white);
                batch.draw(pairODice, (float)((int)(this.getX() + (float)border + (float)gap)), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(pairODice.getRegionHeight() / 2))));
                Snapshot present = DungeonScreen.this.getFightLog().getSnapshot(FightLog.Temporality.Present);
                int rolls = present.getRolls();
                int maxRolls = present.getMaxRolls();
                String rollText = rolls + "/" + maxRolls;
                batch.setColor(Colours.light);
                if (rolls == 0) {
                    batch.setColor(Colours.red);
                }
                int start = border + gap * 2 + pairODice.getRegionWidth();
                int lineGap = 10;
                TannFont.font.drawString(batch, "Reroll", (float)(start + TannFont.font.getWidth(rollText) / 2), (float)((int)(this.getY() + this.getHeight() / 2.0f + (float)(lineGap / 2))), 1);
                TannFont.font.drawString(batch, rollText, (float)(start + TannFont.font.getWidth(rollText) / 2), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(lineGap / 2))), 1);
            }
        };
        this.diceRollButton.setInputBorder(Main.self().control.getConfirmButtonThumbpadRadius(), 0);
        this.diceRollButton.setSpecialBorderRight(false);
        this.rollGroup.addActor(this.diceRollButton);
        this.rollGroup.setTransform(false);
        this.addActor(this.rollGroup);
        this.slideButton(this.rollGroup, false, false);
        this.confirmButton = new ConfirmButton(DungeonScreen.getBotButtWidth(), DungeonScreen.getBottomButtonHeight());
        this.confirmButton.setState(ConfirmButton.ConfirmState.UsingDice);
        this.confirmButton.setRunnable(new Runnable(){

            @Override
            public void run() {
                if (!Main.getSettings().hasAttemptedLevel() && DungeonScreen.this.numUnusedDice(true) >= 2) {
                    DungeonScreen.this.showDialog("First, use[n]your dice", Colours.red);
                    Sounds.playSound(Sounds.error);
                    return;
                }
                DungeonScreen.this.popAllLight();
                DungeonScreen.this.confirmClicked(true);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (OptionLib.LONGTAP_END.c()) {
                    DungeonScreen.this.popAllLight();
                    DungeonScreen.this.requestUndo();
                }
            }
        });
        if (DungeonScreen.isWish()) {
            this.confirmButton.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    if (DungeonScreen.this.confirmButton.getConfirmState() == ConfirmButton.ConfirmState.UsingDice || DungeonScreen.this.confirmButton.getConfirmState() == ConfirmButton.ConfirmState.AllDiceUsed) {
                        DungeonScreen.this.killAllEnemies();
                        return true;
                    }
                    return super.info(button, x, y);
                }
            });
        }
        this.confirmButton.setInputBorder(Main.self().control.getConfirmButtonThumbpadRadius(), 1);
        this.addActor(this.confirmButton);
        this.confirmButton.setPosition(this.getWidth() - this.confirmButton.getWidth(), -this.diceRollButton.getHeight());
        if (OptionLib.GAP.c() > 0) {
            this.confirmButton.setX(this.abilityHolder.getX() + this.abilityHolder.getWidth());
        }
        this.slideButton(this.confirmButton, false, false);
        this.confirmButton.setSpecialBorderRight(true);
        this.doneRollingButton = new ConfirmButton(DungeonScreen.getBotButtWidth(), DungeonScreen.getBottomButtonHeight());
        this.doneRollingButton.setState(ConfirmButton.ConfirmState.RollingDice);
        this.doneRollingButton.setRunnable(new Runnable(){

            @Override
            public void run() {
                DungeonScreen.this.popAllLight();
                DungeonScreen.this.confirmClicked(true);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (OptionLib.LONGTAP_END.c()) {
                    DungeonScreen.this.popAllLight();
                    DungeonScreen.this.rollManager.requestPlayerRoll();
                }
            }
        });
        this.doneRollingButton.setInputBorder(Main.self().control.getConfirmButtonThumbpadRadius(), 1);
        this.addActor(this.doneRollingButton);
        this.doneRollingButton.setPosition(this.getWidth() - this.doneRollingButton.getWidth(), -this.diceRollButton.getHeight());
        if (OptionLib.GAP.c() > 0) {
            this.doneRollingButton.setX(this.abilityHolder.getX() + this.abilityHolder.getWidth());
        }
        this.slideButton(this.doneRollingButton, false, false);
        this.doneRollingButton.setSpecialBorderRight(true);
        this.undoButton = new Button(DungeonScreen.getBotButtWidth(), DungeonScreen.getBottomButtonHeight(), null, new Runnable(){

            @Override
            public void run() {
                DungeonScreen.this.requestUndo();
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (OptionLib.LONGTAP_END.c()) {
                    DungeonScreen.this.popAllLight();
                    DungeonScreen.this.confirmClicked(true);
                }
            }
        }){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                super.draw(batch, parentAlpha);
                DungeonScreen.this.undoActor.setPosition(this.getX() + this.getWidth() / 2.0f - DungeonScreen.this.undoActor.getWidth() / 2.0f, this.getY() + this.getHeight() / 2.0f - DungeonScreen.this.undoActor.getHeight() / 2.0f);
                DungeonScreen.this.undoActor.draw(batch, parentAlpha);
            }
        };
        this.undoButton.setSpecialBorderRight(false);
        this.setupUndoActor();
        this.undoButton.setBorder(Colours.dark, Colours.purple);
        this.addActor(this.undoButton);
        this.undoButton.setPosition(0.0f, -this.diceRollButton.getHeight());
        this.slideButton(this.undoButton, false, false);
        this.undoButton.setInputBorder(Main.self().control.getConfirmButtonThumbpadRadius(), 0);
        this.refreshTopButtonsPanel();
        this.hiddenInventoryButton = new StandardButton("[orange]Inventory", Colours.orange);
        this.hiddenInventoryButton.setRunnable(new Runnable(){

            @Override
            public void run() {
                if (PhaseManager.get().getPhase().showCornerInventory()) {
                    LevelEndPanel.showPartyPanel();
                } else {
                    Sounds.playSound(Sounds.error);
                }
            }
        });
        this.addActor(this.hiddenInventoryButton);
        this.hiddenInventoryButton.setPosition(0.0f, -this.hiddenInventoryButton.getHeight());
    }

    private void setupUndoActor() {
        if (this.undoActor != null) {
            this.undoActor.remove();
        }
        Phase phase = PhaseManager.get().getPhase();
        boolean undoToReroll = !this.fightLog.canUndo() && phase instanceof TargetingPhase;
        boolean showRerolls = undoToReroll || phase instanceof TargetingPhase;
        this.undoActor = DungeonScreen.makeUndoActor(undoToReroll, showRerolls ? ((TargetingPhase)phase).getUnusedRolls() : 0);
    }

    public static Actor makeUndoActor(boolean undoToReroll, int rolls) {
        Pixl pix = new Pixl(3);
        Pixl textPix = new Pixl(1);
        String pr = Words.plural("roll", rolls);
        if (undoToReroll) {
            textPix.row();
            String tag = rolls == 0 ? "[red]" : "[grey]";
            String rollString = rolls + "";
            rollString = rollString + " " + pr;
            if (OptionLib.GAP.c() > 0) {
                rollString = rolls + "";
            }
            textPix.row().text(tag + rollString);
        } else {
            textPix.text("Undo");
            if (rolls > 0) {
                textPix.row().text("[grey](" + rolls + " " + pr + ")");
            }
        }
        if (Main.isPortrait()) {
            pix.image(Images.undo, Colours.light).row(5).actor(textPix.pix());
        } else {
            pix.image(Images.undo, Colours.light).gap(5).actor(textPix.pix());
        }
        return pix.pix();
    }

    public void toggleHiddenInventory(boolean show) {
        if (!this.getDungeonContext().allowInventory()) {
            return;
        }
        int gap = 4;
        this.hiddenInventoryButton.addAction(Actions.moveTo(gap, show ? (float)gap : -this.hiddenInventoryButton.getHeight(), 0.3f, Chrono.i));
    }

    public void requestUndo() {
        boolean fightLogUndid = this.fightLog.undo(false);
        this.popAllLight();
        if (fightLogUndid) {
            ++this.undosInARow;
            this.getTutorialManager().onAction(TutorialManager.TutorialAction.Undo, this.undosInARow);
            this.getDungeonContext().getStatsManager().onUndo(this.undosInARow);
            if (this.undosInARow > 3 && this.undosInARow % 4 == 0) {
                this.externalChatEvent(ChatStateEvent.Undizzy);
            }
            this.mildSave();
        } else {
            Phase current = PhaseManager.get().getPhase();
            if (!(current instanceof TargetingPhase)) {
                return;
            }
            TargetingPhase tp = (TargetingPhase)current;
            int rolls = tp.getUnusedRolls();
            if (rolls == 0) {
                Sounds.playSound(Sounds.error);
                return;
            }
            ++this.undosInARow;
            PhaseManager.get().removePhaseClass(TargetingPhase.class);
            PhaseManager.get().pushPhase(new PlayerRollingPhase(rolls));
            Sounds.playSound(Sounds.flap);
            BulletStuff.resetAlignment();
        }
    }

    public void nonUndo() {
        this.undosInARow = 0;
    }

    public void refreshTopButtonsPanel() {
        if (this.optionsButtonsGroup != null) {
            this.optionsButtonsGroup.remove();
        }
        this.optionsButtonsGroup = DungeonUtils.makeButtonsGroup(this.dungeonContext, this.fightLog, this);
        this.addActor(this.optionsButtonsGroup);
        if (Main.isPortrait()) {
            this.optionsButtonsGroup.setPosition(0.0f, DungeonUtils.getPortraitPanelY(this.optionsButtonsGroup));
        } else {
            this.optionsButtonsGroup.setPosition((int)(this.getWidth() / 2.0f - this.optionsButtonsGroup.getWidth() / 2.0f), this.getHeight() - this.optionsButtonsGroup.getHeight() - 2.0f - (float)Main.self().notch(0));
        }
        TannStageUtils.putBehindAlwaysOnTop(this.optionsButtonsGroup);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public TutorialManager getTutorialManager() {
        return this.tutorialManager;
    }

    public static void clearStaticReference() {
        BulletStuff.reset();
        PhaseManager.get().clearPhases();
        self = null;
    }

    @Override
    public void snapshotChanged(FightLog.Temporality temporality, Snapshot newSnapshot) {
        switch (temporality) {
            case Visual: {
                List<SnapshotEvent> events = newSnapshot.getEvents();
                if (!this.isLoading()) {
                    for (int i = this.stateIndex; i < events.size(); ++i) {
                        SnapshotEvent se = events.get(i);
                        se.act(this.abilityHolder);
                    }
                }
                this.stateIndex = events.size();
                this.enemy.setEntities(newSnapshot, newSnapshot.getEntities(false, null), newSnapshot.getReinforcements());
                this.hero.setEntities(newSnapshot, newSnapshot.getEntities(true, null), new ArrayList<Monster>());
            }
        }
        this.setupUndoActor();
        this.somethingChanged();
        int newTurn = newSnapshot.getTurn();
        if (newTurn != this.lastTurn) {
            this.refreshTopButtonsPanel();
        }
        this.lastTurn = newTurn;
    }

    public void slideSpellHolder(AbilityHolder.TuckState tuckState, boolean instant) {
        if (DungeonScreen.get().isLoading()) {
            instant = true;
        }
        this.abilityHolder.tuck(tuckState, instant);
    }

    public void restart(boolean countsAsLoss) {
        this.restart(countsAsLoss, AntiCheeseRerollInfo.makeBlank());
    }

    public void restart(boolean countsAsLoss, AntiCheeseRerollInfo antiCheeseRerollInfo) {
        if (countsAsLoss) {
            try {
                this.dungeonContext.logDefeatBackground(this.fightLog.makeSnapshot());
            }
            catch (Exception e) {
                TannLog.log("Failed to merge stats: " + e.getMessage(), TannLog.Severity.error);
                e.printStackTrace();
            }
        }
        this.dungeonContext.getContextConfig().clearSave();
        GameStart.start(this.dungeonContext.getContextConfig().makeContext(antiCheeseRerollInfo));
    }

    @Override
    public String getReportString() {
        return this.reportStringSave(true);
    }

    public String reportStringSave(boolean mini) {
        if (this.getDungeonContext() != null) {
            String s = Prefs.getString(DungeonScreen.get().getDungeonContext().getContextConfig().getGeneralSaveKey(), null);
            if (s == null) {
                return "invalid save";
            }
            SaveStateData ssd = Main.getJson().fromJson(SaveStateData.class, s);
            if (mini) {
                ssd.trimContextDataForReport();
            }
            String result = Main.getJson(mini).toJson(ssd);
            if (mini) {
                result = PasteMode.encloseBackticks(result);
            }
            return result;
        }
        return null;
    }

    public void enterPhase(Phase phase) {
        this.toggleHiddenInventory(phase.showCornerInventory());
        this.setupUndoActor();
    }

    public void onLock() {
        this.getTutorialManager().onLock(DungeonScreen.get().getFightLog().getSnapshot(FightLog.Temporality.Present).getEntities(true, false));
        if (this.allHeroesLockedOrLocking() && PhaseManager.get().getPhase() instanceof PlayerRollingPhase) {
            this.confirmClicked(false);
        }
    }

    private boolean allHeroesLockedOrLocking() {
        for (Hero h : this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveHeroEntities()) {
            Die.DieState st = h.getDie().getState();
            if (st.isLockedOrLocking()) continue;
            return false;
        }
        return true;
    }

    public boolean anyDeathAnimationsOngoing() {
        return this.hero.anyDeathAnimationsOngoing() || this.enemy.anyDeathAnimationsOngoing();
    }

    public void makeDust() {
        Sounds.playSound(Sounds.dust);
        Dust.addDust(this);
    }

    public List<Stat> getStoredMergedList() {
        return this.storedMergedList;
    }

    private void saveAntiCheese() {
        AnticheeseData existing = this.dungeonContext.getContextConfig().getAnticheese();
        String s = this.reportStringSave(false);
        if (existing == null) {
            AnticheeseData acd = new AnticheeseData(s);
            this.dungeonContext.getContextConfig().saveAnticheese(acd);
        } else {
            existing.setSaveState(s);
            this.dungeonContext.getContextConfig().saveAnticheese(existing);
        }
    }

    public void resetFromSetup() {
        TannStageUtils.clearActorsOfType(this, FXContainer.class);
    }

    public static boolean checkActive(Ent de) {
        if (DungeonScreen.get() == null || DungeonScreen.get().getFightLog() == null) {
            return false;
        }
        return DungeonScreen.get().getFightLog().getActiveEntities().contains(de);
    }

    @Override
    public void afterSet() {
        PhaseManager.get().activateCurrentPhase();
    }

    public void refreshTimer() {
        if (this.tt != null) {
            this.tt.remove();
        }
        if (OptionLib.SHOW_TIMER.c()) {
            this.tt = new SpeedrunTimer(this.dungeonContext);
            this.addActor(this.tt);
            this.tt.toBack();
            this.tt.setY((int)((float)Main.height - this.tt.getHeight() - 3.0f));
            this.tt.setX(Main.isPortrait() ? (float)(Main.width / 2 + 4) : this.optionsButtonsGroup.getX() + this.optionsButtonsGroup.getWidth() + 2.0f);
        }
    }

    public void refreshClock() {
        if (this.clock != null) {
            this.clock.remove();
        }
        if (OptionLib.SHOW_CLOCK.c()) {
            this.clock = new Clock();
            this.addActor(this.clock);
            this.clock.toBack();
            this.clock.setX(Main.isPortrait() ? (float)(Main.width / 2) - this.clock.getWidth() - 4.0f : this.optionsButtonsGroup.getX() - this.clock.getWidth() - 4.0f);
            this.clock.setY((int)((float)Main.height - this.clock.getHeight() - 3.0f));
        }
    }

    public static DungeonContext getCurrentContextIfInGame() {
        DungeonScreen ds = DungeonScreen.getCurrentScreenIfDungeon(true);
        if (ds == null) {
            return null;
        }
        DungeonContext dc = ds.getDungeonContext();
        if (dc == null) {
            return null;
        }
        return dc;
    }

    public static DungeonScreen getCurrentScreenIfDungeon(boolean allowLoading) {
        Screen s = Main.getCurrentScreen();
        if (allowLoading) {
            s = DungeonScreen.get();
        }
        if (s instanceof DungeonScreen) {
            DungeonScreen ds = (DungeonScreen)s;
            return ds;
        }
        return null;
    }

    public void manualFlee() {
        this.popAllMedium();
        if (!Main.self().masterStats.allowFlee()) {
            List<EntState> states = this.getFightLog().getSnapshot(FightLog.Temporality.Present).getStates(false, false);
            this.showDialog("[purple]" + SurrenderPhase.describeGroupOfEnemies(states) + " " + Words.plural("does", states.size()) + " not allow you to flee");
            return;
        }
        if (this.canFleePhase()) {
            PhaseManager.get().getPhase().deactivate();
            this.getFightLog().addCommand(new SimpleCommand(null, new SimpleTargetable(null, new EffBill().friendly().group().flee().bEff())), false);
        } else {
            this.showDialog("[red]cannot flee here...");
        }
    }

    public boolean canFleePhase() {
        return PhaseManager.get().getPhase().canFlee() && !this.fightLog.getSnapshot(FightLog.Temporality.Present).isEnd();
    }

    public static int getBotButtWidth() {
        float base = 84.0f;
        if (Main.isPortrait()) {
            return (int)(base * 0.5f);
        }
        if (OptionLib.GAP.c() > 0) {
            return (int)(base * 0.7f);
        }
        return (int)base;
    }

    public static int getBottomButtonHeight() {
        return (int)(29.0f * (Main.isPortrait() ? 2.0f : 1.0f));
    }

    @Override
    public boolean skipMonkey() {
        return PhaseManager.get().getPhase() instanceof EnemyRollingPhase;
    }

    public EntContainer getContainer(boolean player) {
        return player ? this.hero : this.enemy;
    }

    public void allHeroDiceLanded() {
        this.abilityHolder.allDiceLanded();
    }

    public void heroDiceRolled() {
        this.abilityHolder.heroDiceRolled();
    }

    public static boolean isWish() {
        return self != null && DungeonScreen.self.dungeonContext != null && DungeonScreen.self.dungeonContext.isWishable();
    }

    private void externalChatEvent(ChatStateEvent cse) {
        if (this.hero.getEntities().isEmpty()) {
            return;
        }
        cse.actWithChance(Tann.pick(this.hero.getEntities()).getEntPanel());
    }

    public String tryTinyPaste() {
        tinyPasting = true;
        SaveState ss = this.makeSaveState();
        if (ss == null) {
            tinyPasting = false;
            return null;
        }
        String s = Main.getJson(true).toJson(ss.toData().trimContextDataForReport());
        tinyPasting = false;
        if (s == null) {
            return null;
        }
        return PasteMode.encloseBackticks(s);
    }

    @Override
    public void showDialog(String s, Color border) {
        if (this.getTopPushedActor() == null && this.abilityHolder != null) {
            this.abilityHolder.addWisp(s);
            return;
        }
        super.showDialog(s, border);
    }
}

