/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.Main;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.Button;

public class ConfirmButton
extends Button {
    int data;
    ConfirmState confirmState = ConfirmState.Unset;
    int border = 1;
    TextureRegion tick = Images.tick;

    public ConfirmButton(float width, float height) {
        super(width, height, null, null);
    }

    public void setState(ConfirmState state, int data) {
        this.confirmState = state;
        this.data = data;
    }

    public ConfirmState getConfirmState() {
        return this.confirmState;
    }

    public void setState(ConfirmState state) {
        this.setState(state, -1);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.confirmState.pulsate && Main.self().settings.getTutorialProgress() < 0.9f) {
            Tann.drawPatch(batch, this, this.getPatch(), Colours.shiftedTowards(Colours.dark, Colours.green, Main.pulsateFactor() / 2.0f), Colours.grey, 1);
        }
        float gap = (this.getHeight() - (float)(this.border * 2) - (float)this.tick.getRegionHeight() - (float)TannFont.font.getHeight()) / 3.0f;
        batch.setColor(this.confirmState.textColour);
        String text = this.confirmState.confirmText;
        if (Main.isPortrait() && text.contains(" ")) {
            int dist = TannFont.font.getHeight() + 2;
            int y = (int)(this.getY() + (float)this.border + gap + (float)(dist / 2));
            for (String s : text.split(" ")) {
                TannFont.font.drawString(batch, s, (int)((float)((int)this.getX()) + this.getWidth() / 2.0f - (float)TannFont.font.getWidth(s) / 2.0f), y);
                y -= dist;
            }
        } else {
            TannFont.font.drawString(batch, text, (int)((float)((int)this.getX()) + this.getWidth() / 2.0f - (float)TannFont.font.getWidth(text) / 2.0f), (int)((float)((int)this.getY() + this.border) + gap));
        }
        if (this.data > 0) {
            batch.setColor(Colours.z_white);
            int skullGap = 1;
            int skullBorder = 3;
            for (int i = 0; i < this.data; ++i) {
                batch.draw(Images.confirmSkull, this.getX() + (float)skullBorder + (float)((Images.confirmSkull.getRegionHeight() + skullGap) * (i / 3)), this.getY() + this.getHeight() - (float)skullBorder - (float)(Images.confirmSkull.getRegionHeight() * (i % 3 + 1)) - (float)(skullGap * (i % 3)));
            }
        }
        batch.setColor(this.confirmState.tickColour);
        batch.draw(this.tick, (float)((int)((float)((int)this.getX()) + this.getWidth() / 2.0f - (float)(this.tick.getRegionWidth() / 2))), (float)((int)((float)((int)this.getY() + this.border) + gap * 2.0f + (float)TannFont.font.getHeight())));
    }

    public static enum ConfirmState {
        RollingDice("Done Rolling", Colours.grey, Colours.grey, false),
        AllDiceLocked("Done Rolling", Colours.light, Colours.light, true),
        UsingDice("End turn", Colours.grey, Colours.grey, false),
        AllDiceUsed("End turn", Colours.light, Colours.light, true),
        Unset("Unset", Colours.green, Colours.light, false);

        String confirmText;
        Color textColour;
        Color tickColour;
        boolean pulsate;

        private ConfirmState(String confirmText, Color tickColour, Color textColour, boolean pulsate) {
            this.confirmText = confirmText;
            this.textColour = textColour;
            this.tickColour = tickColour;
            this.pulsate = pulsate;
        }
    }
}

