/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.tann.dice.Main;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.screens.dungeon.panels.book.Book;
import com.tann.dice.screens.dungeon.panels.book.TopTab;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.ContentPanel;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.HelpPage;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.LedgerPage;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.StuffPage;
import com.tann.dice.screens.dungeon.panels.book.sidebar.SideBar;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class BookPage
extends Group {
    public static final int SIDE_WIDTH = 45;
    private int aboveTitlesTopArea;
    public final String title;
    protected SideBar sideBar;
    protected ContentPanel contentPanel;
    protected Map<String, Stat> allMergedStats;

    public BookPage(String title, Map<String, Stat> allMergedStats, int width, int height) {
        this.setSize(width, height);
        this.aboveTitlesTopArea = Book.getMainTitlesHeight();
        this.title = title;
        this.allMergedStats = allMergedStats;
        this.setTransform(false);
        this.setup(this.getAllListItems());
        this.setTouchable(Touchable.childrenOnly);
    }

    public Color getColour() {
        return Colours.light;
    }

    public TopTab makeTopTab() {
        return new TopTab(this, "[b]" + this.title);
    }

    public static List<BookPage> getAll(Map<String, Stat> allMergedStats, int width, int height) {
        return Arrays.asList(new HelpPage(width, height), new LedgerPage(allMergedStats, width, height), new StuffPage(allMergedStats, width, height));
    }

    public static String getChosenString(int chosen, int rejected) {
        if (chosen + rejected == 0) {
            return "[text]Not encountered yet...";
        }
        int prc = (int)((float)chosen / (float)(chosen + rejected) * 100.0f);
        String prcString = prc + "%";
        String colourTag = "[orange]";
        if (prc < 50) {
            colourTag = "[red]";
        } else if (prc > 50) {
            colourTag = "[green]";
        }
        prcString = colourTag + prcString + "[cu]";
        return "chosen " + chosen + "/" + (chosen + rejected) + " ([h]" + prcString + "[h])";
    }

    public static void push(Actor a) {
        Sounds.playSound(Sounds.pipSmall);
        Main.getCurrentScreen().push(a, true, true, true, 0.7f);
        Tann.center(a);
    }

    public void onFocus(String defaultSidebar) {
        TopTab sb;
        if (defaultSidebar != null) {
            this.showDefaultSidebar(defaultSidebar);
            return;
        }
        String pg = Main.getSettings().getLastSpecificPage(this);
        if (pg != null && (sb = this.getSideBarItemFromString(pg)) != null) {
            this.openSidebar(sb);
            return;
        }
        this.openSidebar(this.sideBar.getItems().get(0));
    }

    public static int getPadding() {
        return 1;
    }

    private int getContentPanelWidth() {
        return (int)(this.getWidth() - (float)BookPage.getSideWidth());
    }

    private int getContentWidth() {
        return this.getContentPanelWidth() - BookPage.getPadding() * 2 + (this instanceof HelpPage ? -8 : 0);
    }

    private int getContentHeight() {
        if (Main.isPortrait()) {
            return (int)(this.getHeight() - (float)this.aboveTitlesTopArea - this.sideBar.getHeight()) - BookPage.getPadding() * 2 + 1;
        }
        return (int)this.getHeight() - BookPage.getPadding() * 2 - 1;
    }

    private int getContentPanelHeight() {
        return this.getContentHeight() + BookPage.getPadding() * 2;
    }

    protected abstract List<TopTab> getAllListItems();

    protected void setup(List<TopTab> items) {
        this.sideBar = new SideBar();
        this.sideBar.setDrawBorder(!Main.isPortrait() && !(this instanceof StuffPage));
        this.setSidebarItems(items);
        this.contentPanel = new ContentPanel(this.getContentPanelWidth(), this.getContentPanelHeight(), this);
        this.addActor(this.sideBar);
        this.addActor(this.contentPanel);
        if (Main.isPortrait()) {
            this.sideBar.setPosition(0.0f, this.getHeight() - this.sideBar.getHeight() - (float)this.aboveTitlesTopArea + 1.0f);
        } else {
            this.sideBar.setPosition(0.0f, -1.0f);
        }
        this.setContentPosition();
    }

    public void setSidebarItems(List<TopTab> items) {
        for (final TopTab sbi : items) {
            this.sideBar.addItem(sbi);
            sbi.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Sounds.playSound(Sounds.pipSmall);
                    BookPage.this.openSidebar(sbi);
                    return true;
                }
            });
        }
        if (Main.isPortrait()) {
            this.sideBar.layoutHori((int)this.getWidth(), 18);
        } else {
            this.sideBar.layoutVerti((int)this.getHeight() - this.aboveTitlesTopArea);
        }
    }

    public void showDefaultSidebar(String defaultSidebar) {
        TopTab sbi = this.getSideBarItemFromString(defaultSidebar);
        if (sbi != null) {
            this.openSidebar(sbi);
        }
    }

    private TopTab getSideBarItemFromString(String defaultSidebar) {
        for (TopTab item : this.sideBar.getItems()) {
            if (!item.getTabName().toLowerCase().endsWith(defaultSidebar.toLowerCase())) continue;
            return item;
        }
        return null;
    }

    protected void openSidebar(TopTab sbi) {
        this.sideBar.highlightItem(sbi);
        Actor a = this.getContentActorFromSidebar(sbi.getIdentifier(), this.getContentWidth());
        this.showThing(a, a.getName() != null && a.getName().contains("bot"));
        Main.getSettings().setLastAlmanacPage(this.title + "-" + sbi.getTabName());
    }

    public void showThing(Actor a) {
        this.showThing(a, false);
    }

    public void showThing(Actor a, boolean scrollToBottom) {
        this.contentPanel.setContent(a);
        this.contentPanel.layout();
        this.contentPanel.setScrollPercentY(scrollToBottom ? 1.0f : 0.0f);
        this.contentPanel.updateVisualScroll();
        this.setContentPosition();
        Main.stage.setScrollFocus(this.contentPanel);
    }

    private void setContentPosition() {
        int toX = (int)((float)BookPage.getSideWidth() + (float)this.getContentPanelWidth() / 2.0f - this.contentPanel.getWidth() / 2.0f);
        this.contentPanel.setX(toX);
        if (this.contentPanel.getHeight() < (float)(this.getContentPanelHeight() - BookPage.getPadding())) {
            this.contentPanel.setY((float)this.getContentPanelHeight() - this.contentPanel.getHeight() - (float)BookPage.getPadding());
        } else {
            this.contentPanel.setY((int)((float)this.getContentPanelHeight() / 2.0f - this.contentPanel.getHeight() / 2.0f));
        }
    }

    public List<Actor> debugGiveAllActors() {
        ArrayList<Actor> acs = new ArrayList<Actor>();
        for (TopTab allListItem : this.getAllListItems()) {
            acs.add(this.getContentActorFromSidebar(allListItem.getIdentifier(), this.getContentWidth()));
        }
        return acs;
    }

    protected abstract Actor getContentActorFromSidebar(Object var1, int var2);

    public static int getSideWidth() {
        return Main.isPortrait() ? 0 : 45;
    }

    public SideBar getSideBar() {
        return this.sideBar;
    }
}

