/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.ice;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;

public class FreezeActor
extends CombatEffectActor {
    static final float IN = 0.1f;
    static final float HOLD = 0.3f;
    static final float OUT = 0.3f;
    static final float ALPHA = 0.65f;
    Ent target;

    public FreezeActor(Ent target) {
        this.target = target;
    }

    @Override
    protected void start(FightLog fightLog) {
        Sounds.playSoundDelayed(Sounds.deboost, 1.0f, 1.0f, this.getImpactDuration() * 0.3f);
        Actor a = new Actor(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                batch.setColor(this.getColor());
                Images.icePatch.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        };
        int border = 3;
        EntPanel targetPanel = this.target.getEntPanel();
        a.setSize(targetPanel.getWidth() + (float)(border * 2), targetPanel.getHeight() + (float)(border * 2));
        targetPanel.addActor(a);
        a.setPosition(-border, -border);
        Color col = Colours.shiftedTowards(Colours.light, Colours.blue, 0.5f);
        a.setColor(Colours.withAlpha(col, 0.0f));
        a.addAction(Actions.sequence((Action)Actions.alpha(0.65f, 0.1f), (Action)Actions.delay(0.3f), Tann.fadeAndRemove(0.3f)));
    }

    @Override
    protected float getImpactDuration() {
        return 0.25f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.45000002f;
    }
}

