/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.poison;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Noise;
import com.tann.dice.util.Tann;
import java.util.List;

public class PoisonCloudActor
extends CombatEffectActor {
    List<EntState> targets;
    private static final float START_DURATION = 0.8f;
    private static final float IMPACT_RATIO = 0.2f;

    public PoisonCloudActor(List<EntState> targets) {
        this.targets = targets;
    }

    @Override
    protected void start(FightLog fightLog) {
        Sounds.playSound(Sounds.poison);
        this.setY(PoisonCloudActor.getBotMost(this.targets));
        this.setHeight(PoisonCloudActor.getTopMost(this.targets) - this.getY());
        EntPanel first = this.targets.get(0).getEnt().getEntPanel();
        float widthStart = 0.0f;
        this.setX(Tann.getAbsoluteCoordinates((Actor)first).x + first.getWidth() * widthStart);
        this.setWidth(first.getWidth() * (1.0f - widthStart));
        DungeonScreen.get().addActor(this);
        this.addAction(Actions.sequence((Action)Actions.fadeOut(0.8f), (Action)Actions.removeActor()));
        int totalSkulls = this.targets.size() * 2;
        for (int i = 0; i < totalSkulls; ++i) {
            float ratio = 0.64000005f / (float)totalSkulls * (float)i;
            this.addAction(Actions.delay(ratio, Actions.run(new Runnable(){

                @Override
                public void run() {
                    PoisonCloudActor.this.addSkull();
                }
            })));
        }
    }

    private void addSkull() {
        ImageActor ia = new ImageActor(Images.combatEffectPoisonSkull);
        ia.setColor(Colours.withAlpha(Colours.green, 1.0f));
        DungeonScreen.get().addActor(ia);
        ia.setPosition(this.getX() + Tann.random(this.getWidth() - ia.getWidth()), this.getY() + Tann.random(this.getHeight() - ia.getHeight()));
        float fadeDuration = 0.64000005f;
        int moveAmount = 4;
        ia.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(0.0f, moveAmount, fadeDuration), (Action)Actions.fadeOut(fadeDuration)), (Action)Actions.removeActor()));
        this.toFront();
    }

    @Override
    protected float getImpactDuration() {
        return 0.16000001f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.64000005f;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        int pixelSize = 1;
        float freq = 0.08f;
        float upFreq = 0.5f;
        float halfHeight = this.getHeight() / 2.0f;
        float halfWidth = this.getWidth() / 2.0f;
        float distRatio = (halfWidth + halfHeight) / 2.0f;
        int x = 0;
        while ((float)x < this.getWidth()) {
            int y = 0;
            while ((float)y < this.getHeight()) {
                float perlin = (float)Noise.noise((double)((float)x * freq), (double)((float)y * freq), (double)(Main.secs * upFreq), 1);
                float perlinRatio = (perlin + 1.0f) / 2.0f;
                float xDist = halfWidth - (float)x;
                float yDist = halfHeight - (float)y;
                float dist = (float)(Math.sqrt(xDist * xDist + yDist * yDist) / (double)distRatio);
                float alpha = (float)((double)perlinRatio * Math.pow(1.0f - dist, 1.5));
                alpha = (double)(alpha = Interpolation.pow3Out.apply(alpha)) > 0.3 ? 0.8f : 0.0f;
                Color sourceCol = (double)perlinRatio > 0.6 ? Colours.purple : Colours.green;
                batch.setColor(Colours.withAlpha(sourceCol, alpha *= this.getColor().a));
                Draw.fillRectangle(batch, this.getX() + (float)x, this.getY() + (float)y, pixelSize, pixelSize);
                y += pixelSize;
            }
            x += pixelSize;
        }
        super.draw(batch, parentAlpha);
    }
}

