/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.simplePanelImage;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;

public class SimplePanelImage
extends CombatEffectActor {
    final Ent target;
    final TextureRegion image;
    final Eff eff;
    final String[] overrideSound;

    public SimplePanelImage(Ent target, TextureRegion image, Eff eff) {
        this(target, image, eff, null);
    }

    public SimplePanelImage(Ent target, TextureRegion image, Eff eff, String[] overrideSound) {
        this.target = target;
        this.image = image;
        this.eff = eff;
        this.overrideSound = overrideSound;
        this.setSize(image.getRegionWidth(), image.getRegionHeight());
    }

    @Override
    protected void start(FightLog fightLog) {
        if (this.overrideSound != null) {
            Sounds.playSound(this.overrideSound);
        } else {
            this.eff.playSound();
        }
        EntPanel panel = this.target.getEntPanel();
        panel.addActor(this);
        this.setPosition((int)(panel.HPHolder.getX(1) - this.getWidth() / 2.0f), (int)(panel.HPHolder.getY(1) - this.getHeight() / 2.0f));
        this.addAction(Actions.sequence((Action)Actions.fadeOut(this.getExtraDuration(), Interpolation.pow2In), (Action)Actions.removeActor()));
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        batch.draw(this.image, this.getX(), this.getY());
    }

    @Override
    protected float getImpactDuration() {
        return 0.0f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.4f;
    }
}

