/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import java.util.List;

public class TriggerPanel
extends Actor {
    Ent ent;
    private static final int GAP = 1;
    private static final int BUFFSIZE = 5;
    private static final int WIDTH = 5;
    int itemsPerColumn;
    final boolean horizontal;

    public TriggerPanel(Ent ent, boolean horizontal) {
        this.ent = ent;
        this.horizontal = horizontal;
        if (ent.getSize() == EntSize.huge) {
            this.itemsPerColumn = 4;
        } else if (horizontal) {
            this.itemsPerColumn = 1;
        } else {
            switch (ent.getSize()) {
                case small: {
                    this.itemsPerColumn = 1;
                    break;
                }
                case reg: {
                    this.itemsPerColumn = 2;
                    break;
                }
                case big: {
                    this.itemsPerColumn = 3;
                }
            }
        }
        this.setSize(5.0f, this.itemsPerColumn * 5 + (this.itemsPerColumn - 1) * 1);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        batch.setColor(Colours.z_white);
        List<Personal> visualTriggerList = this.ent.getState(FightLog.Temporality.Visual).getActiveTriggers();
        List<Personal> allTriggers = this.ent.getEntPanel().getAllDescribableTriggers();
        int drawIndex = 0;
        for (int i = 0; i < allTriggers.size(); ++i) {
            Boolean incoming;
            boolean drawAsIncoming;
            Personal t = allTriggers.get(i);
            if (!t.showInEntPanel() || t.skipNetAndIcon()) continue;
            int yCo = drawIndex % this.itemsPerColumn;
            int xCo = drawIndex / this.itemsPerColumn;
            if (!(this.ent.isPlayer() || this.horizontal && this.ent.getSize() != EntSize.small)) {
                xCo = -xCo;
            }
            boolean bl = drawAsIncoming = (incoming = Personal.treatAsIncoming(t, visualTriggerList)) == null || incoming != false;
            if (drawAsIncoming && !t.showAsIncoming()) continue;
            int x = (int)(this.getX() + (float)(xCo * 6));
            int y = (int)(this.getY() + this.getHeight() - (float)(6 * (yCo + 1)) + 1.0f);
            batch.setColor(Colours.z_white);
            TextureRegion pImage = t.getImage();
            if (pImage == null) {
                pImage = Images.triggerBug;
            }
            if (drawAsIncoming) {
                float min = 0.2f;
                float max = 0.99f;
                batch.setColor(Colours.withAlpha(Colours.z_white, min + (max - min) * Main.pulsateFactor()));
            }
            batch.draw(pImage, (float)x, (float)y);
            ++drawIndex;
        }
    }
}

