/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.generalPanels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.entPanel.ItemHeroPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.AlternativePop;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.KeyListen;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PopRequirement;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.List;

public class PartyManagementPanel
extends Group
implements PostPop,
ExplanelReposition,
AlternativePop,
PopRequirement,
KeyListen {
    final FightLog fightLog;
    List<DiePanel> diePanels = new ArrayList<DiePanel>();
    InventoryPanel invPan;
    public static boolean tinyPanels;
    ItemHeroPanel draggingPanel;

    public PartyManagementPanel(FightLog fightLog) {
        this.fightLog = fightLog;
        this.setTransform(false);
    }

    private Party getParty() {
        return this.fightLog.getContext().getParty();
    }

    public void refresh() {
        tinyPanels = false;
        this.getParty().refreshAllSlots();
        this.clearChildren();
        this.diePanels.clear();
        int gap = 2;
        ArrayList<Hero> heroList = new ArrayList<Hero>(this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveHeroEntities());
        for (int i = heroList.size() - 1; i >= 0; --i) {
            Hero h = (Hero)heroList.get(i);
            if (!h.getBlankState().skipEquipScreen()) continue;
            heroList.remove(i);
        }
        if (heroList.size() == 0) {
            return;
        }
        DiePanel examplePanel = ((Hero)heroList.get(0)).getDiePanel();
        examplePanel.layout(false);
        int panelWidth = (int)examplePanel.getWidth();
        int panelHeight = (int)examplePanel.getHeight();
        int totalPanelsPlusInv = heroList.size() + 1;
        float rawAcross = (float)(Main.width - 5) / ((float)panelWidth * 1.05f);
        int panelsAcross = (int)Math.min(4.0f, rawAcross);
        int panelsDown = (int)Math.ceil((float)totalPanelsPlusInv / (float)panelsAcross);
        if (panelsAcross == 1 && rawAcross > 1.4f || panelsDown * panelHeight > Main.height) {
            tinyPanels = true;
            DiePanel dp = ((Hero)heroList.get(0)).getDiePanel();
            dp.layout(true);
            panelWidth = (int)dp.getWidth();
            float fpa = Math.max(1.0f, (float)(Main.width - 5) / ((float)panelWidth * 1.05f));
            panelsAcross = (int)fpa;
            if (panelsAcross == 1 && fpa > 1.7f) {
                panelsAcross = 2;
            }
            panelsDown = (int)Math.ceil((float)totalPanelsPlusInv / (float)panelsAcross);
        }
        if (heroList.size() == 5 && panelsDown > 2 && !Main.isPortrait()) {
            panelsAcross = 3;
            panelsDown = 2;
        }
        for (int test = panelsAcross - 1; test >= 0; --test) {
            if (test * panelsDown < totalPanelsPlusInv) continue;
            panelsAcross = test;
        }
        this.setSize(panelWidth * panelsAcross + gap * (panelsAcross + 1), panelHeight * panelsDown + gap * (panelsDown + 1));
        InventoryPanel.resetSingleton();
        this.invPan = InventoryPanel.get();
        this.invPan.reset();
        for (int x = 0; x < panelsAcross; ++x) {
            for (int y = 0; y < panelsDown; ++y) {
                int xPos = x * panelWidth + gap * (x + 1);
                int yPos = (int)(this.getHeight() - (float)((y + 1) * panelHeight)) - gap * (y + 1);
                if (y == 0 && x == panelsAcross - 1) {
                    this.invPan.setPosition(xPos + 2, yPos);
                    continue;
                }
                int heroIndex = y * panelsAcross + x;
                if (y > 0) {
                    --heroIndex;
                }
                if (heroIndex >= heroList.size()) continue;
                Ent de = (Ent)heroList.get(heroIndex);
                DiePanel dp = de.getDiePanel();
                dp.setTraitsVisible(false);
                dp.clearActions();
                dp.setScale(1.0f);
                dp.setPosition(xPos, yPos);
                this.addActor(dp);
                this.diePanels.add(dp);
            }
        }
        this.addActor(this.invPan);
        Group done = new Pixl(0, 1).border(Colours.grey).actor(new ImageActor(Images.ui_crossAlmanac, Colours.grey)).pix();
        this.addActor(done);
        done.setPosition((int)(this.getWidth() - done.getWidth()), (int)(this.getHeight() - done.getHeight()));
        done.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                PartyManagementPanel.this.doneAction();
                return true;
            }
        });
        done.toBack();
        Party prty = this.fightLog.getContext().getParty();
        if (prty.getItems().size() > 2) {
            this.invPan.addZoom(prty);
        }
    }

    private void doneAction() {
        Main.getCurrentScreen().popAllLight();
        Main.getCurrentScreen().pop(PartyManagementPanel.class);
        Sounds.playSound(Sounds.pop);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, Colours.grey, 1);
        super.draw(batch, parentAlpha);
    }

    public void equip(Ent ent, Item item, int index) {
        Item replaced;
        Party p = this.fightLog.getContext().getParty();
        TP<int[], int[]> before = p.getWholePartyHash();
        if (index == 3 && ent.getNumberItemSlots() < 4) {
            index = 2;
        }
        if (index == 2 && ent.getNumberItemSlots() < 3) {
            index = 0;
        }
        index = Math.min(index, ent.getNumberItemSlots() - 1);
        Main.getSettings().setHasEquipped(true);
        if (!item.usableBy(ent)) {
            Sounds.playSound(Sounds.error);
            return;
        }
        Ent previousHolder = p.getEquippee(item);
        int previousSlot = -1;
        if (previousHolder != null) {
            previousSlot = previousHolder.removeItem(item);
        }
        if ((replaced = ent.addItem(item, index)) != null) {
            if (previousHolder == ent) {
                DungeonScreen.get().getTutorialManager().onAction(TutorialManager.TutorialAction.SwapItems);
            }
            if (previousHolder != null && previousSlot != -1) {
                previousHolder.addItem(replaced, previousSlot);
            } else {
                p.addItem(replaced);
            }
        }
        Sounds.playSound(Sounds.drop);
        p.refreshAllSlots();
        this.invPan.reset();
        for (Hero h : p.getHeroes()) {
            h.updateOutOfCombat();
        }
        TP<int[], int[]> after = p.getWholePartyHash();
        PartyManagementPanel.sortFlashes(p, before, after);
        p.afterEquip();
    }

    public static void sortFlashes(Party p, TP<int[], int[]> before, TP<int[], int[]> after) {
        for (int i = 0; i < p.getHeroes().size(); ++i) {
            Hero h = p.getHeroes().get(i);
            int[] previousHashes = new int[6];
            int[] afterHashes = new int[6];
            System.arraycopy(before.b, i * 6, previousHashes, 0, 6);
            System.arraycopy(after.b, i * 6, afterHashes, 0, 6);
            DiePanel dp = h.getDiePanel();
            dp.layout();
            dp.flash(((int[])before.a)[i * 2], ((int[])after.a)[i * 2], ((int[])before.a)[i * 2 + 1], ((int[])after.a)[i * 2 + 1], previousHashes, afterHashes);
            h.getDie().clearTextureCache();
        }
    }

    @Override
    public void postPop() {
        this.releasePanel();
    }

    @Override
    public void repositionExplanel(Explanel exp) {
        int x = (int)((float)(Gdx.input.getX() / Main.scale) - exp.getMaxWidth() / 2.0f);
        int xOverflow = (int)(exp.getMaxWidth() - exp.getWidth());
        x = (int)Math.min((float)Main.width - exp.getWidth() - (float)(xOverflow / 2), (float)Math.max(xOverflow / 2, x));
        exp.setX(x);
        if (Main.isPortrait()) {
            exp.setY((Gdx.graphics.getHeight() - Gdx.input.getY()) / Main.scale + exp.getExtraBelowExtent() + 30);
        } else {
            exp.setY((int)((float)Main.height - exp.getHeight() - 2.0f));
        }
    }

    @Override
    public boolean alternativePop() {
        for (Ent ent : this.getHeroes()) {
            ent.getDiePanel().setTraitsVisible(true);
        }
        Tann.slideAway(this, Tann.TannPosition.Bot, 1, true);
        PhaseManager.get().getPhase().refreshPhase();
        return true;
    }

    private List<Hero> getHeroes() {
        return this.fightLog.getSnapshot(FightLog.Temporality.Present).getAliveHeroEntities();
    }

    @Override
    public boolean allowPop() {
        return true;
    }

    public void releasePanel() {
        if (this.draggingPanel == null) {
            return;
        }
        Vector2 dragMid = Tann.getAbsoluteCoordinates(this.draggingPanel).cpy().add(this.draggingPanel.getWidth() / 2.0f, this.draggingPanel.getHeight() / 2.0f);
        this.draggingPanel.remove();
        if (this.draggingPanel == null) {
            return;
        }
        boolean equipped = false;
        for (DiePanel dp : this.diePanels) {
            int index;
            Tann.TannPosition pos = Tann.globalOver(dp, dragMid.x, dragMid.y, 0.4f);
            Tann.TannPosition xPos = Tann.globalOverX(dp, dragMid.x, dragMid.y, 0.6f - (tinyPanels ? 0.22f : 0.0f));
            if (xPos == Tann.TannPosition.Right && Tann.globalOverX(dp, dragMid.x, dragMid.y, 0.8f - (tinyPanels ? 0.12f : 0.0f)) == Tann.TannPosition.Right) {
                xPos = Tann.TannPosition.Center;
            }
            if (pos == Tann.TannPosition.Bot) {
                index = 1;
            } else {
                int n = xPos == Tann.TannPosition.Right ? 2 : (index = xPos == Tann.TannPosition.Center ? 3 : 0);
            }
            if (pos == null || dp.ent.getNumberItemSlots() <= 0) continue;
            this.equip(dp.ent, this.draggingPanel.item, index);
            equipped = true;
            break;
        }
        if (!equipped) {
            Party p = this.fightLog.getContext().getParty();
            TP<int[], int[]> before = p.getWholePartyHash();
            p.unequip(this.draggingPanel.item);
            p.addItem(this.draggingPanel.item, this.getInventoryPosition());
            Sounds.playSound(Sounds.drop);
            PartyManagementPanel.sortFlashes(p, before, p.getWholePartyHash());
        }
        this.draggingPanel = null;
        DungeonScreen.get().save();
    }

    public int getInventoryPosition() {
        float x = Gdx.input.getX() / Main.scale;
        float y = Main.height - Gdx.input.getY() / Main.scale;
        Vector2 pos = new Vector2(x, y);
        pos.sub(Tann.getAbsoluteCoordinates(this.invPan));
        pos.scl(1.0f / (float)Images.itemBorder.getRegionHeight());
        if (pos.x < 0.0f || pos.x > (float)InventoryPanel.getAcross() || pos.y < 0.0f || pos.y > 3.0f) {
            return -1;
        }
        return (int)pos.y * InventoryPanel.getAcross() + (int)pos.x;
    }

    public boolean isDragging() {
        return this.draggingPanel != null;
    }

    public Item getDraggingItem() {
        if (this.draggingPanel == null) {
            return null;
        }
        return this.draggingPanel.item;
    }

    public boolean dragPanel(ItemHeroPanel ep) {
        if (this.draggingPanel == ep) {
            return false;
        }
        Main.getCurrentScreen().popAllLight();
        this.draggingPanel = ep;
        Sounds.playSound(Sounds.pickup, 1.0f, Tann.random(0.8f, 1.2f));
        Party p = this.fightLog.getContext().getParty();
        p.removeItem(ep.item);
        ep.remove();
        ep.toFront();
        InventoryPanel.get().addActor(ep);
        ItemPanel exp = new ItemPanel(ep.item, true);
        TannStageUtils.removeCopyButton(exp);
        ep.addActor(exp);
        exp.setPosition((int)(ep.getWidth() / 2.0f - exp.getWidth() / 2.0f), (int)(ep.getHeight() + 5.0f));
        return true;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        Vector2 coord = Tann.getAbsoluteCoordinates(this.invPan);
        if (this.draggingPanel != null) {
            this.draggingPanel.setPosition((int)((float)(Gdx.input.getX() / Main.scale) - coord.x - this.draggingPanel.getWidth() / 2.0f), (int)((float)(Main.height - Gdx.input.getY() / Main.scale) - coord.y - this.draggingPanel.getHeight() / 2.0f));
        }
    }

    public void onShow() {
        for (Item i : this.fightLog.getContext().getParty().getItems()) {
            i.setNew(false);
        }
        if (this.getWidth() > (float)Main.width * 1.1f || this.getHeight() > (float)Main.height * 1.1f) {
            DungeonScreen.get().showDialog("Maybe decrease UI scale in [white][cog]");
        }
    }

    @Override
    public boolean keyPress(int keycode) {
        switch (keycode) {
            case 46: {
                this.randomiseEquipment();
                return true;
            }
            case 37: 
            case 66: 
            case 111: 
            case 160: {
                this.doneAction();
            }
        }
        return true;
    }

    private void randomiseEquipment() {
        Party p = this.fightLog.getContext().getParty();
        TP<int[], int[]> before = p.getWholePartyHash();
        this.releasePanel();
        if (p.randomiseEquipment()) {
            for (Hero h : p.getHeroes()) {
                h.updateOutOfCombat();
            }
            Sounds.playSound(Sounds.flap);
            PartyManagementPanel.sortFlashes(p, before, p.getWholePartyHash());
            DungeonScreen.get().save();
        }
    }
}

