/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.titleScreen;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.meta.folder.FolderMode;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ModesPanel
extends Group {
    static final int GAP = 5;
    static final int WIDTH = 50;
    static final int LEFT_BORDER = 1;
    List<StandardButton> modeButtons = new ArrayList<StandardButton>();
    Actor fullGroup = null;
    Mode selectedMode;
    Runnable onChangeMode;
    boolean out = false;

    public ModesPanel() {
        this.setSize(61.0f, Main.height);
        this.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                return true;
            }
        });
        this.layout();
    }

    public void layout() {
        this.clearChildren();
        ImageActor modesTab = new ImageActor(Main.demo ? Images.moneyButton : Images.modesButton);
        this.addActor(modesTab);
        modesTab.setPosition(-modesTab.getWidth() + 1.0f, (int)(this.getHeight() - modesTab.getHeight()) / 2);
        modesTab.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                ModesPanel.this.slide(!ModesPanel.this.out, true);
                event.cancel();
                return true;
            }
        });
        boolean initiallyVisible = this.out || !Main.self().control.hasNotches();
        this.fullGroup = null;
        if (Main.demo) {
            Actor fullGroup = ModesPanel.makeFullVersionGroup();
            this.fullGroup = fullGroup = new Pixl(0, 4).actor(fullGroup).pix();
            this.fullGroup.setVisible(initiallyVisible);
            this.addActor(fullGroup);
            this.setSize(fullGroup.getWidth() + 10.0f + 1.0f, Main.height);
            Tann.center(fullGroup);
            return;
        }
        int topBotGap = 8;
        Pixl right = new Pixl(0);
        right.row(8);
        ArrayList<Mode> modes = new ArrayList<Mode>(Mode.getPlayableModes());
        Collections.sort(modes, new Comparator<Mode>(){

            @Override
            public int compare(Mode o1, Mode o2) {
                return Boolean.compare(UnUtil.isLocked(o1), UnUtil.isLocked(o2));
            }
        });
        for (int i = 0; i < modes.size(); ++i) {
            final Mode m = (Mode)modes.get(i);
            if (m.skipFromMainList()) continue;
            final boolean locked = UnUtil.isLocked(m);
            StandardButton tb = m.makeModeSelectButton();
            tb.setVisible(initiallyVisible);
            this.modeButtons.add(tb);
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    if (locked) {
                        if (m instanceof FolderMode) {
                            FolderMode f = (FolderMode)m;
                            List<Mode> cm = f.getContainedModes();
                            if (!cm.isEmpty() && UnUtil.isLocked(cm.get(0))) {
                                AchLib.showUnlockFor(cm.get(0));
                            } else {
                                Main.getCurrentScreen().showDialog(m.getTextButtonName() + "[n](a locked folder)");
                                Sounds.playSound(Sounds.pip);
                            }
                        } else {
                            AchLib.showUnlockFor(m);
                        }
                    } else {
                        Sounds.playSound(Sounds.pipSmall);
                        ModesPanel.this.selectMode(m);
                        ModesPanel.this.slide(false, false);
                    }
                }
            });
            right.actor(tb);
            if (i >= modes.size() - 1) continue;
            right.row(3);
        }
        right.row(8);
        Group modesColumn = right.pix();
        int gap = (int)(this.getWidth() - modesColumn.getWidth() - 6.0f) / 2;
        Group a = new Pixl().gap(gap).actor(modesColumn).gap(gap).pix();
        this.addActor(a);
        a.setPosition((float)((int)(this.getWidth() - a.getWidth())) / 2.0f + 1.0f, (int)(this.getHeight() / 2.0f - a.getHeight() / 2.0f));
    }

    public static Actor makeFullVersionGroup() {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList("- [light]Single purchase", "- [light]No ads, offline", "- [orange]20-level dungeon", "- [orange]Too many modes", "- [yellow]" + HeroTypeUtils.getNumNormalHeroes() + " heroes", "- [yellow]" + MonsterTypeLib.getNumNormalMonsters() + " monsters", "- [grey]" + ItemLib.getNumNormalItems() + " items", "- [grey]" + Keyword.values().length + " keywords", "- [purple]\u221e curses", "- [purple]Weird modding"));
        Main.self().control.affectAdvertLines(lines);
        Pixl p = new Pixl(3);
        Pixl lp = new Pixl(3);
        for (String line : lines) {
            lp.text(line).row();
        }
        p.actor(lp.pix(8)).row();
        p.actor(Main.self().control.makePaymentRequestActor());
        return p.pix();
    }

    private void selectMode(Mode m) {
        if (m == this.selectedMode) {
            return;
        }
        this.selectedMode = m;
        for (StandardButton tb : this.modeButtons) {
            tb.setBorder(tb.getText().equals(m.getTextButtonName()) ? Colours.light : Colours.grey);
        }
        if (this.onChangeMode != null) {
            this.onChangeMode.run();
        }
    }

    public void setOnChangeMode(Runnable onChangeMode) {
        this.onChangeMode = onChangeMode;
    }

    public Mode getSelectedMode() {
        return this.selectedMode;
    }

    private void updatePanelContentVisibility() {
        if (!Main.self().control.hasNotches()) {
            return;
        }
        for (int i = 0; i < this.modeButtons.size(); ++i) {
            this.modeButtons.get(i).setVisible(this.out);
        }
        if (this.fullGroup != null) {
            this.fullGroup.setVisible(this.out);
        }
    }

    public void slide(boolean out, boolean manual) {
        if (this.out == out) {
            return;
        }
        this.out = out;
        this.addAction(Actions.moveTo((float)Main.width - (out ? this.getWidth() : 0.0f) - (float)Main.self().notch(1), 0.0f, 0.3f, Chrono.i));
        this.updatePanelContentVisibility();
        if (manual) {
            Sounds.playSound(out ? Sounds.lock : Sounds.unlock);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(Colours.light);
        Draw.fillRectangle(batch, this.getX(), this.getY(), 1.0f, this.getHeight());
        batch.setColor(Colours.dark);
        Draw.fillRectangle(batch, this.getX() + 1.0f, this.getY(), this.getWidth() - 1.0f + 50.0f, this.getHeight());
        super.draw(batch, parentAlpha);
    }

    public void selectFirstUnlocked(Mode prefMode) {
        if (prefMode != null) {
            if (!UnUtil.isLocked(prefMode)) {
                this.selectMode(prefMode);
                return;
            }
            TannLog.log("Trying to load into locked mode: " + prefMode);
        }
        for (Mode m : Mode.getPlayableModes()) {
            if (UnUtil.isLocked(m)) continue;
            this.selectMode(m);
            return;
        }
    }
}

