/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.platform.control.desktop.DesktopControl;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.test.util.SkipNonTann;
import com.tann.dice.test.util.Test;
import com.tann.dice.test.util.TestPlat;
import com.tann.dice.util.Tann;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestFiles {
    @Test
    public static void testSoundFiles() {
        ArrayList<String> bads = new ArrayList<String>();
        for (Field f : Sounds.class.getFields()) {
            if (!f.getType().isArray()) continue;
            try {
                String[] val = (String[])f.get(null);
                if (val.length != 0) continue;
                bads.add(f.getName());
            }
            catch (IllegalAccessException e) {
                bads.add(f.getName());
                e.printStackTrace();
            }
        }
        Tann.assertTrue("no bad sounds: " + bads, bads.size() == 0);
    }

    @Test
    @TestPlat(platformClass=DesktopControl.class)
    @SkipNonTann
    public static void testImageFiles() {
        ArrayList<String> imagesPaths = new ArrayList<String>();
        for (Field f : Images.class.getFields()) {
            if (f.getType() != TextureRegion.class) continue;
            try {
                TextureRegion tr = (TextureRegion)f.get(null);
                if (!(tr instanceof TextureAtlas.AtlasRegion)) continue;
                TextureAtlas.AtlasRegion ar = (TextureAtlas.AtlasRegion)tr;
                String path = ar.name;
                imagesPaths.add(path);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        List<FileHandle> handles = TestFiles.getAll(Gdx.files.internal("C:/code/workspace/Dicegeon/images/2d"));
        for (FileHandle fh : handles) {
            if (!fh.extension().equals("png")) continue;
            String path = fh.path().substring(37);
            if ((path = path.substring(0, path.length() - 4)).startsWith("3dlink") || path.startsWith("combatEffects") || path.startsWith("portrait") || path.startsWith("patch") || path.startsWith("achievement") || path.startsWith("font") || path.startsWith("item") || path.startsWith("misc") || path.startsWith("lapel2d") || path.startsWith("spell") || path.startsWith("style") || path.startsWith("trigger") || path.startsWith("ui/minimap")) continue;
            filePaths.add(path);
        }
        filePaths.removeAll(imagesPaths);
        Tann.assertTrue("no unused files: " + filePaths, filePaths.isEmpty());
    }

    @Test
    @TestPlat(platformClass=DesktopControl.class)
    public static void checkUnusedSoundFiles() {
        ArrayList<String> javaStrings = new ArrayList<String>();
        for (Field f : Sounds.class.getFields()) {
            if (!f.getType().isArray()) continue;
            try {
                String[] val = (String[])f.get(null);
                javaStrings.addAll(Arrays.asList(val));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> fileStrings = new ArrayList<String>();
        List<FileHandle> handles = TestFiles.getAll(Gdx.files.internal("sfx"));
        for (FileHandle fh : handles) {
            fileStrings.add(fh.path());
        }
        fileStrings.removeAll(javaStrings);
        Tann.assertTrue("no unused files: " + fileStrings, fileStrings.isEmpty());
    }

    public static List<FileHandle> getAll(FileHandle parent) {
        ArrayList<FileHandle> result = new ArrayList<FileHandle>();
        TestFiles.getAll(parent, result);
        return result;
    }

    private static void getAll(FileHandle parent, List<FileHandle> partial) {
        if (parent.isDirectory()) {
            for (FileHandle f : parent.list()) {
                TestFiles.getAll(f, partial);
            }
        } else {
            partial.add(parent);
        }
    }
}

