/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test.util;

import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.misc.DebugConfig;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.targetable.DieTargetable;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.command.AbilityCommand;
import com.tann.dice.gameplay.fightLog.command.DieCommand;
import com.tann.dice.gameplay.fightLog.command.SimpleCommand;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.TestAffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Tann;
import java.util.List;

public class TestUtils {
    public static List<Hero> heroes;
    public static List<Monster> monsters;

    public static FightLog setupFight(HeroType[] heroTypes, MonsterType[] monsterTypes) {
        return TestUtils.setupFight(heroTypes, monsterTypes, new Modifier[0]);
    }

    public static FightLog setupFight(HeroType[] heroTypes, MonsterType[] monsterTypes, Modifier[] modifiers) {
        return TestUtils.setupFight(HeroTypeUtils.getHeroes(heroTypes), MonsterTypeLib.monsterList(monsterTypes), modifiers);
    }

    public static FightLog setupFight(Hero h, MonsterType mt) {
        return TestUtils.setupFight(Tann.asList(h), Tann.asList(mt.makeEnt()), new Modifier[0]);
    }

    public static FightLog setupFight(List<Hero> heroes, List<Monster> monsters, Modifier[] modifiers) {
        TestUtils.heroes = heroes;
        TestUtils.monsters = monsters;
        DungeonContext dc = new DungeonContext(new DebugConfig(), new Party(heroes), 1);
        for (Modifier m : modifiers) {
            dc.addModifier(m);
        }
        FightLog f = new FightLog(dc);
        f.setup(heroes, monsters);
        f.resetTurn(true);
        return f;
    }

    public static FightLog setupFight() {
        return TestUtils.setupFight(new HeroType[]{HeroTypeUtils.byName("Fighter")}, new MonsterType[]{MonsterTypeLib.byName("testGoblin")});
    }

    public static FightLog setupFight(MonsterType ... monsters) {
        return TestUtils.setupFight(new HeroType[]{HeroTypeUtils.byName("Fighter")}, monsters);
    }

    public static void attack(FightLog fightLog, Ent source, Ent target, int damage) {
        TestUtils.attack(fightLog, source, target, damage, false);
    }

    public static void attack(FightLog fightLog, Ent source, Ent target, int damage, boolean future) {
        fightLog.addCommand(new SimpleCommand(target, new SimpleTargetable(source, ESB.dmg.val(damage).getBaseEffect())), future);
    }

    public static void hit(FightLog fightLog, Ent source, Ent target, EntSide entSide) {
        TestUtils.hit(fightLog, source, target, entSide, false);
    }

    public static void hit(FightLog fightLog, Ent source, Ent target, EntSide entSide, boolean future) {
        fightLog.addCommand(new SimpleCommand(target, new SimpleTargetable(source, entSide.getBaseEffect())), future);
    }

    public static void spell(FightLog fightLog, Spell s, Ent target) {
        fightLog.addCommand(new SimpleCommand(null, new SimpleTargetable(null, new EffBill().mana(s.getBaseCost()).bEff())), false);
        fightLog.addCommand(new AbilityCommand(s, target), false);
    }

    public static void hit(FightLog fightLog, Ent target, Personal trigger, boolean future) {
        fightLog.addCommand(new SimpleCommand(target, new SimpleTargetable(null, new EffBill().buff(new Buff(trigger)).bEff())), future);
    }

    public static void rollDamage(FightLog fightLog, Ent source, Ent target, int damage, boolean future) {
        TestUtils.rollHit(fightLog, source, target, ESB.dmg.val(damage), future);
    }

    public static void rollHit(FightLog fightLog, Ent source, Ent target, EntSide side) {
        TestUtils.rollHit(fightLog, source, target, side, false);
    }

    public static void rollHit(FightLog fightLog, Ent source, Ent target, EntSide side, boolean future) {
        TestUtils.turnInto(fightLog, source, side, future);
        fightLog.addCommand(source.getDie().getTargetable(), target, future);
    }

    public static void roll(FightLog fightLog, Ent source, Ent target, int side, boolean future) {
        fightLog.addCommand(new DieCommand(new DieTargetable(source, side), target), future);
    }

    public static void turnInto(FightLog fightLog, Ent source, EntSide side, boolean future) {
        fightLog.addCommand(new SimpleCommand(source, new SimpleTargetable(null, new EffBill().buff(new Buff(new TestAffectSides(new ReplaceWith(side)))).bEff())), future);
        source.getDie().setSide(0);
    }

    public static void turnInto(FightLog fightLog, Ent source, EntSide side) {
        TestUtils.turnInto(fightLog, source, side, false);
    }

    public static void hit(FightLog fightLog, Ent target, Eff eff) {
        TestUtils.hit(fightLog, target, eff, false);
    }

    public static void hit(FightLog fightLog, Ent target, Eff eff, boolean future) {
        fightLog.addCommand(new SimpleCommand(target, new SimpleTargetable(null, eff)), future);
    }

    public static void addTrigger(FightLog f, Ent target, Personal trigger) {
        f.addCommand(new SimpleCommand(target, new SimpleTargetable(null, new EffBill().buff(new Buff(trigger)).bEff())), false);
    }

    public static EntState getState(FightLog fightLog, Ent ent) {
        return TestUtils.getState(fightLog, ent, FightLog.Temporality.Present);
    }

    public static EntState getState(FightLog fightLog, Ent ent, FightLog.Temporality temporality) {
        return fightLog.getState(temporality, ent);
    }

    public static boolean undo(FightLog fightLog, boolean force) {
        return fightLog.undo(force);
    }

    public static boolean undo(FightLog fightLog) {
        return TestUtils.undo(fightLog, true);
    }

    public static int countDyingHeroes(FightLog fightLog) {
        int dead = 0;
        for (Hero h : heroes) {
            if (!TestUtils.getState(fightLog, h, FightLog.Temporality.Future).isDead()) continue;
            ++dead;
        }
        return dead;
    }

    public static String hashDeathState(FightLog fightLog, List<? extends Ent> entities) {
        String hash = "";
        for (Ent ent : entities) {
            hash = hash + (TestUtils.getState(fightLog, ent, FightLog.Temporality.Future).isDead() ? "d" : "a");
        }
        return hash;
    }

    public static void nextTurn(FightLog f) {
        f.resetTurn(true);
    }

    public static FightLog loadFromString(String paste) {
        SaveState result = SaveState.loadPasteModeString(paste, true);
        DungeonScreen ds = result.makeDungeonScreen();
        DungeonScreen.clearStaticReference();
        FightLog f = ds.getFightLog();
        if (f.isFailed()) {
            throw new RuntimeException("Failed to load test save from " + paste);
        }
        return f;
    }

    public static boolean shouldCrash() {
        return TestRunner.isTesting();
    }
}

