/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class LockOverlay
extends Actor {
    final Group toLock;
    final boolean chains;
    private Color background = Colours.dark;

    public LockOverlay(Group toLock, boolean hasChains) {
        this.toLock = toLock;
        this.chains = hasChains;
        boolean gap = true;
        this.setSize(toLock.getWidth() - 2.0f, toLock.getHeight() - 2.0f);
        this.setPosition((float)gap, (float)gap);
        toLock.addActor(this);
    }

    public void setBackground(Color col) {
        this.background = col;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (!this.chains) {
            batch.setColor(Colours.z_white);
            batch.draw(Images.padlock, (float)((int)(this.getX() + this.getWidth() / 2.0f - (float)(Images.padlock.getRegionWidth() / 2))), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(Images.padlock.getRegionHeight() / 2))));
            return;
        }
        Draw.fillActor(batch, (Actor)this, this.background);
        batch.setColor(Colours.withAlpha(Colours.grey, this.getColor().a));
        batch.draw(Images.padlock, (float)((int)(this.getX() + this.getWidth() / 2.0f - (float)(Images.padlock.getRegionWidth() / 2))), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(Images.padlock.getRegionHeight() / 2))));
        Draw.drawLine(batch, (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth() - 1.0f), (int)(this.getY() + this.getHeight() - 1.0f), 1.0f);
        Draw.drawLine(batch, (int)this.getX(), (int)(this.getY() + this.getHeight() - 1.0f), (int)(this.getX() + this.getWidth() - 1.0f), (int)this.getY(), 1.0f);
    }
}

