/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannStage;
import com.tann.dice.util.image.Img64;
import com.tann.dice.util.ui.TextBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextWriter
extends Group {
    String[] split;
    public String text;
    TannFont font = TannFont.font;
    private static final int LINE_GAP = 1;
    int x;
    int y;
    int lineHeight = 0;
    Color borderCol;
    int borderSize;
    TextureRegion image;
    private static Map<String, TextureRegion> textureMap = new HashMap<String, TextureRegion>();
    private static Map<String, Color> colorMap = new HashMap<String, Color>();
    int max = 0;
    static final float maxRatio = 0.5f;
    int guessedMax;
    private Color overrideColor;

    public TextWriter(String text) {
        this(text, Integer.MAX_VALUE);
    }

    public TextWriter(String text, TextureRegion image) {
        this(text, Integer.MAX_VALUE, null, 0, image);
    }

    public TextWriter(String text, TextureRegion image, int width) {
        this(text, width, null, 0, image);
    }

    public TextWriter(String text, int width) {
        this(text, width, null, 0);
    }

    public TextWriter(String text, int width, Color borderCol, int borderSize) {
        this(text, width, borderCol, borderSize, null);
    }

    public TextWriter(String text, int width, Color borderCol, int borderSize, TextureRegion image) {
        this.setTransform(false);
        this.text = text;
        this.borderSize = borderSize;
        this.borderCol = borderCol;
        this.image = image;
        this.setWidth(width);
        this.layout();
    }

    public static void setup() {
        textureMap.put("fullHeart", Images.fullHeart);
        textureMap.put("confirmSkull", Images.confirmSkull);
        textureMap.put("roso", Images.roso);
        textureMap.put("zablocki", Images.zablocki);
        textureMap.put("hp", Images.hp);
        textureMap.put("hp-plus", Images.hp_plus);
        textureMap.put("hp-hole", Images.hp_hole);
        textureMap.put("hp-girder", Images.hp_girder);
        textureMap.put("hp-cross", Images.hp_cross);
        textureMap.put("hp-square", Images.hp_square);
        textureMap.put("hp-diamond", Images.hp_diamond);
        textureMap.put("hp-bar", Images.hp_bar);
        textureMap.put("hp-bracket", Images.hp_bracket);
        textureMap.put("hp-glider", Images.hp_glider);
        textureMap.put("hp-reverse", Images.hp_reverse);
        textureMap.put("hp-arrow_left", Images.hp_arrow_left);
        textureMap.put("hp-arrow_up", Images.hp_arrow_up);
        textureMap.put("hp-arrow_down", Images.hp_arrow_down);
        textureMap.put("mana", Images.mana);
        textureMap.put("checkbox", Images.checkbox);
        textureMap.put("checkboxTicked", Images.checkbox_ticked);
        textureMap.put("info", Images.info);
        textureMap.put("pips", Images.pips);
        textureMap.put("plus", Images.plusBig);
        textureMap.put("tick", Images.tickSmall);
        textureMap.put("plusfive", Images.plusFive);
        textureMap.put("minus", Images.minusBig);
        textureMap.put("equals", Images.equalsBig);
        textureMap.put("petrify-diagram", Images.itemDiagramPetrify);
        textureMap.put("mysteryVoice", Images.mv);
        textureMap.put("cog", Images.cog);
        textureMap.put("hash", Images.hash);
        textureMap.put("tinyDice", Images.tinyDice);
        colorMap.put("white", Colours.z_white);
        colorMap.put("red", Colours.red);
        colorMap.put("brown", Colours.brown);
        colorMap.put("purple", Colours.purple);
        colorMap.put("blue", Colours.blue);
        colorMap.put("dark", Colours.dark);
        colorMap.put("light", Colours.light);
        colorMap.put("yellow", Colours.yellow);
        colorMap.put("orange", Colours.orange);
        colorMap.put("grey", Colours.grey);
        colorMap.put("ultragrey", Colours.shiftedTowards(Colours.text, Colours.dark, 0.6f).cpy());
        colorMap.put("secret", Colours.shiftedTowards(Colours.text, Colours.dark, 0.25f).cpy());
        colorMap.put("green", Colours.green);
        colorMap.put("pink", Colours.pink);
        colorMap.put("shift", Colours.SHIFTER);
        colorMap.put("text", Colours.text);
        colorMap.put("blurple", Colours.BLURPLE);
        for (HeroCol value : HeroCol.values()) {
            if (colorMap.get(value.colName) != null) continue;
            colorMap.put(value.colName, value.col);
        }
    }

    public static String getNameForColour(Color c) {
        for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
            if (!entry.getValue().equals(c)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getTag(Color c) {
        String name = TextWriter.getNameForColour(c);
        if (name == null) {
            return "";
        }
        return "[" + name + "]";
    }

    public static String getTag(TextureRegion a) {
        for (Map.Entry<String, TextureRegion> stringTextureRegionEntry : textureMap.entrySet()) {
            if (stringTextureRegionEntry.getValue() != a) continue;
            return "[" + stringTextureRegionEntry.getKey() + "]";
        }
        return "invalid image";
    }

    public void layout() {
        this.guessedMax = TannFont.guessMaxTextLength(0.5f);
        this.max = 0;
        if (this.text == null) {
            this.text = "?? null ??";
        }
        this.split = this.text.split("[\\[\\]]");
        Color currentColour = Colours.text;
        Color previousColour = Colours.pink;
        Color p2Colour = Colours.pink;
        this.clearChildren();
        int index = 0;
        this.x = 0;
        this.y = 0;
        boolean wiggle = false;
        boolean sin = false;
        boolean bold = false;
        boolean italics = false;
        boolean glitch = false;
        ArrayList<Actor> lineActors = new ArrayList<Actor>();
        ArrayList<Actor> wordActors = new ArrayList<Actor>();
        for (String s : this.split) {
            TextBox tb;
            if (s.isEmpty()) {
                ++index;
                continue;
            }
            if (index % 2 == 0) {
                String[] words = s.split(" ", -1);
                if (words.length == 0) {
                    this.x += this.font.getSpaceWidth(italics);
                }
                for (int i = 0; i < words.length; ++i) {
                    String word;
                    if (i > 0) {
                        this.addWord(wordActors, lineActors);
                        this.x += this.font.getSpaceWidth(italics);
                    }
                    if ((tb = new TextBox(word = words[i], wiggle, sin, bold, italics, i == 0, glitch)).getWidth() > (float)Main.width * 0.5f) {
                        tb = new TextBox(Tann.makeEllipses(word, this.guessedMax), wiggle, sin, bold, italics, i == 0, glitch);
                    }
                    tb.setColor(this.overrideColor == null ? currentColour : this.overrideColor);
                    wordActors.add(tb);
                }
            } else {
                boolean image = false;
                switch (s) {
                    case "h": {
                        this.addWord(wordActors, lineActors);
                        this.x += this.font.getSpaceWidth(italics) / 2;
                        break;
                    }
                    case "nbp": {
                        tb = new TextBox(" ", wiggle, sin, bold, italics, false, glitch);
                        wordActors.add(tb);
                        break;
                    }
                    case "p": {
                        this.addWord(wordActors, lineActors);
                        ++this.x;
                        break;
                    }
                    case "n": {
                        this.addWord(wordActors, lineActors);
                        this.nextLine(lineActors);
                        break;
                    }
                    case "n2": {
                        this.addWord(wordActors, lineActors);
                        this.lineHeight += 2;
                        this.nextLine(lineActors);
                        break;
                    }
                    case "nh": {
                        this.addWord(wordActors, lineActors);
                        this.nextLine(lineActors);
                        this.y -= this.font.getLineHeight() / 3;
                        break;
                    }
                    case "wiggle": {
                        wiggle = !wiggle;
                        break;
                    }
                    case "sin": {
                        sin = !sin;
                        break;
                    }
                    case "b": {
                        bold = !bold;
                        break;
                    }
                    case "g": {
                        glitch = !glitch;
                        break;
                    }
                    case "i": {
                        italics = !italics;
                        break;
                    }
                    case "cu": {
                        currentColour = previousColour;
                        previousColour = p2Colour;
                        break;
                    }
                    case "blank": {
                        wordActors.add(new TextWriter(""));
                        break;
                    }
                    default: {
                        image = true;
                    }
                }
                Color c = TextWriter.getMapCol(s);
                if (c != null) {
                    p2Colour = previousColour;
                    previousColour = currentColour;
                    currentColour = c;
                    image = false;
                }
                if (image) {
                    Actor tr = this.fetchActorFromTag(s, this.overrideColor == null ? currentColour : this.overrideColor);
                    if (tr == null) {
                        String cont = "{" + s + "}";
                        TextBox tb2 = new TextBox(cont);
                        if (tb2.getWidth() > (float)Main.width * 0.5f) {
                            tb2 = new TextBox(Tann.makeEllipses(cont, this.guessedMax), wiggle, sin, bold, italics, false, glitch);
                        }
                        tb2.setColor(currentColour);
                        wordActors.add(tb2);
                    } else {
                        wordActors.add(tr);
                    }
                }
            }
            ++index;
        }
        if (wordActors.size() > 0) {
            this.addWord(wordActors, lineActors);
        }
        if (lineActors.size() > 0) {
            this.nextLine(lineActors);
        }
        this.setSize(this.max + this.borderSize * 2, -this.y + this.borderSize * 2);
        for (Actor a : this.getChildren()) {
            a.setX(a.getX() + (float)this.borderSize);
            a.setY((int)(this.getHeight() + a.getY() - a.getHeight() / 2.0f - (float)this.borderSize));
        }
    }

    public static Color getMapCol(String s) {
        String COL_STR = "col";
        if (s.startsWith("col")) {
            String rem = s.substring(3);
            if (colorMap.get(rem) != null) {
                return colorMap.get(rem);
            }
            if (rem.length() == 3 || rem.length() == 6) {
                Color c = Colours.fromHex(rem);
                if (c == Colours.pink) {
                    return null;
                }
                colorMap.put(rem, c);
                return c;
            }
        }
        return colorMap.get(s);
    }

    private Actor fetchActorFromTag(String s, Color currentCol) {
        String key;
        Integer v;
        DungeonContext dc;
        if (textureMap.get(s) != null) {
            return new ImageActor(textureMap.get(s), currentCol);
        }
        if (s.equals("image") || s.equals("img")) {
            return new ImageActor(this.image, currentCol);
        }
        Item i = ItemLib.byName(s);
        if (!i.isMissingno()) {
            return new ImageActor(i.getImage());
        }
        EntType e = EntTypeUtils.byName(s);
        if (!e.isMissingno()) {
            return new ImageActor(e.portrait);
        }
        Texture t = Img64.fromString(s);
        if (t != null) {
            return new ImageActor(new TextureRegion(t));
        }
        String VAL_STR = "val";
        if (s.startsWith("val") && (dc = DungeonScreen.getCurrentContextIfInGame()) != null && (v = dc.getValue(key = s.substring(3))) != null) {
            return new TextWriter(TextWriter.getTag(currentCol) + v);
        }
        return null;
    }

    private void addWord(List<Actor> wordActors, List<Actor> lineActors) {
        Actor a = this.makeActorFrom(wordActors);
        if (a == null) {
            return;
        }
        Actor last = wordActors.get(wordActors.size() - 1);
        boolean it = last instanceof TextBox && ((TextBox)last).italics;
        wordActors.clear();
        if (this.x != 0 && (float)this.x + a.getWidth() > this.getWidth()) {
            this.nextLine(lineActors);
        }
        a.setPosition(this.x, this.y);
        this.x = (int)((float)this.x + a.getWidth());
        this.max = Math.max(this.x + (it ? 2 : 0), this.max);
        this.lineHeight = Math.max(this.lineHeight, this.font.getLineHeight() - 1);
        for (int i = 0; i < wordActors.size(); ++i) {
            this.lineHeight = (int)Math.max((float)this.lineHeight, wordActors.get(i).getHeight());
        }
        lineActors.add(a);
    }

    private Actor makeActorFrom(List<Actor> wordActors) {
        if (wordActors.size() == 0) {
            return null;
        }
        if (wordActors.size() == 1) {
            return wordActors.get(0);
        }
        Group g = Tann.makeGroup();
        int x = 0;
        for (Actor a : wordActors) {
            g.setHeight(Math.max(g.getHeight(), a.getHeight()));
        }
        for (Actor a : wordActors) {
            g.addActor(a);
            a.setPosition(x, (int)((g.getHeight() - a.getHeight()) / 2.0f));
            x = (int)((float)x + a.getWidth());
        }
        g.setWidth(x);
        return g;
    }

    private void nextLine(List<Actor> lineActors) {
        this.x = 0;
        if (this.y != 0) {
            --this.y;
        }
        for (Actor a : lineActors) {
            this.lineHeight = (int)Math.max((float)this.lineHeight, a.getHeight());
        }
        for (Actor a : lineActors) {
            this.addActor(a);
            a.setY((int)((float)this.y - (float)this.lineHeight / 2.0f));
        }
        this.y -= this.lineHeight;
        lineActors.clear();
        this.lineHeight = 0;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.borderCol != null) {
            Draw.fillActor(batch, this, Colours.dark, this.borderCol, 1);
        }
        super.draw(batch, parentAlpha);
    }

    public void setText(String text) {
        this.text = text;
        this.setWidth(2.1474836E9f);
        this.layout();
    }

    public void setAlpha(float alpha) {
        TannStage.alphaSetRecursive(this, alpha);
    }

    public void setOverrideColour(Color color) {
        this.overrideColor = color;
        this.layout();
    }

    public static String stripTags(String text) {
        return text.replaceAll("\\[.*?\\]", "");
    }

    public static String rebracketTags(String input) {
        return input.replaceAll("\\[", "{").replaceAll("\\]", "}");
    }
}

